package com.mwc.sqld.db;

public class SimpleDeleteEngine implements DeleteEngine {
   private int _deleteCount;
   
   private void _doDelete(int i, UpdateCurser data[], Criteria c)
   throws DBException {
      if(i >= data.length) {
         if(c == null || c.match(data)) {
            for(int j = 0; j < data.length; j++) {
               if(!data[j].remove())
                  throw new DBException("Can't do remove on curser!");
               _deleteCount++;
            }
         }
         return;
      }
      data[i].reset();
      while(data[i].next()) {
         _doDelete(i+1, data, c);
      }
   }
   
   /**
    * Do a delete operation on some cursers for some given criteria.
    * @param data the array of cursers to traverse.
    * @param c the criteria for deletetion, null for delte all.
    * @return the number of records delteted.
    * @exception DBException if an underlying db exception is thrown.
    */
   public int delete(UpdateCurser data[], 
                     Criteria c) 
   throws DBException {
      _deleteCount = 0;
      _doDelete(0, data, c);
      return _deleteCount;
   }
}