package com.mwc.sqld.db;

import java.util.*;

public class SimpleUpdateEngine implements UpdateEngine {
   private int _updateCount;
   
   private void _doUpdate(int i, UpdateCurser data[], LinkedList setList, Criteria c)
   throws DBException {
      if(i >= data.length) {
         if(c == null || c.match(data)) {
            Iterator iterator;
            Object []array;
            String columnName;
            Expression expression;
            Object value;
            iterator = setList.iterator();
            boolean found;
            while(iterator.hasNext()) {
               array = (Object[])iterator.next();
               columnName = (String)array[0];
               found = false;
               for(int j = 0; j < data.length; j++) {
                  if(data[j].getValue(columnName) != null) {
                     expression = (Expression)array[1];
                     value = expression.eval(data);
                     if(value == null)
                        throw new DBException("Unable to eval expression for set on column \"" + columnName + "\"!");
                     if(value.equals("") && data[j].notNull(columnName))
                        throw new DBException("Column \"" + columnName + "\" does not allow NULL!");
                     if(SQLTypeChecker.badTypes(value, 
                                                data[j].getType(columnName)))
                        throw new DBException("Expected type \"" + data[j].getType(columnName) 
                                              + "\" for column \"" + columnName + "\"!");
                     if(!data[j].setValue(columnName, value.toString()))
                        throw new DBException("Unable to update column " + columnName + "!");
                     found = true;
                  }
               }
               if(!found)
                  throw new DBException("Column name " + columnName + " was not found!");
               _updateCount++;
            }
         }
         return;
      }
      data[i].reset();
      while(data[i].next()) {
         _doUpdate(i+1, data, setList, c);
      }
   }

   public int update(UpdateCurser data[], LinkedList setList, Criteria c) 
   throws DBException {
      _updateCount = 0;
      _doUpdate(0, data, setList, c);
      return _updateCount;
   }
}