package com.mwc.sqld.db;

import java.util.*;
import java.io.*;

class Comp implements ValueLookupComparator {
   public int compare(ValueLookup vl0, ValueLookup vl1) {
      int left0 = Integer.parseInt(vl0.getValue("col1"));
      int right0 = Integer.parseInt(vl1.getValue("col1"));

      int left1 = Integer.parseInt(vl0.getValue("col2"));
      int right1 = Integer.parseInt(vl1.getValue("col2"));
         
      if(left0 < right0)
         return -1;
      else if(left0 > right0) 
         return 1;
      else {
         if(left1 < right1)
            return -1;
         else if(left1 > right1)
            return 1;
         else
            return 0;
      }
   }
}

public class TestTextDatabase {  
   public static void main(String args[])
   throws Exception {
      TextDatabase db = new TextDatabase("test", "test");
      Table tbl = db.getTable("table1");
      if(tbl == null) {
         tbl = db.createTable("table1", 
                              new String[][] {
                                 {"col1", "int"},
                                 {"col2", "int"}
                              });
         System.out.println("BUILDING TABLE");
         for(int i = 0; i < 10000; i++) {
System.out.println("INSERT="+i);
            LinkedList values = new LinkedList();
            for(int j = 0; j < 2; j++)
               values.add(((int)(Math.random()*1000))+"");
            tbl.insert(values);
         }
      }
      
      Curser curser = tbl.getNewCurser();
      Sorter sorter = db.getNewSorter();
      System.out.println("SORTING TABLE");
      Date start = new Date();
      curser = sorter.sort(curser, new Comp());
      Date end = new Date();

      int lineNumber = 1;
      while(curser.next()) {
         lineNumber++;
         System.out.println("\"" + curser.getValue("col1") + "\",\""
                            +curser.getValue("col2") + "\"");
         System.out.flush();
      }
      
      System.out.println("TOTAL TIME SPENT SORTING=" + (end.getTime() - start.getTime()) +"milliseconds");
      
      curser.close();
            
      if(db.modified())
         db.save();
   }
}