package com.mwc.sqld.jdbc;

import java.sql.*;
import java.io.*;
import java.util.*;
import java.net.*;
import java.math.*;

import com.mwc.util.SQLEncoder;

public class SQLDDriver implements java.sql.Driver {
   /**
    * This drivers version.
    */
   public static final String VERSION = "1.0.0";
   
   static {
      try {
         DriverManager.registerDriver(new SQLDDriver());
      }
      catch(SQLException sqle) {
         ;
      }
   }
      
   // Returns true if the driver thinks that it can open a connection to the given URL. 
   public boolean acceptsURL(String url)
   throws SQLException {
      return url.toLowerCase().startsWith("jdbc:sqld:");
   }
   
   class SQLDConnection implements Connection {
      private String _url;
      private String _host;
      private int _port;
      private String _currCat;
      private Socket _sock;
      private PrintWriter _out;
      private BufferedReader _br;
      private String _username;
      private String _password;

      class SQLDDatabaseMetaData implements DatabaseMetaData {
         private Connection _connection;
         
         SQLDDatabaseMetaData(Connection connnection) {
            _connection = connnection;
         }
         
         // Can all the procedures returned by getProcedures be called by the current user? 
         public boolean allProceduresAreCallable() 
         throws SQLException {
            return false;
         }
         
         // Can all the tables returned by getTable be SELECTed by the current user? 
         public boolean allTablesAreSelectable() 
         throws SQLException {
            return true;
         }
         
         // Does a data definition statement within a transaction force the transaction to commit? 
         public boolean dataDefinitionCausesTransactionCommit() 
         throws SQLException {
            return true;
         }
         
         // Is a data definition statement within a transaction ignored? 
         public boolean dataDefinitionIgnoredInTransactions() 
         throws SQLException {
            return true;
         }
         
         // Indicates whether or not a visible row delete can be detected by calling ResultSet.rowDeleted(). 
         public boolean deletesAreDetected(int type) 
         throws SQLException {
            return false;
         }

         // Did getMaxRowSize() include LONGVARCHAR and LONGVARBINARY blobs? 
         public boolean doesMaxRowSizeIncludeBlobs() 
         throws SQLException {
            return false;
         }
         
         // Gets a description of a table's optimal set of columns that uniquely identifies a row. 
         public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets the catalog names available in this database. 
         public ResultSet getCatalogs() 
         throws SQLException {
            Statement s = _connection.createStatement();
            String catalog = _connection.getCatalog();
            _connection.setCatalog("MasterDB");
            try {
              return s.executeQuery("SELECT name AS TABLE_CAT FROM Databases");
            }
            finally {
               if(catalog != null)
                  _connection.setCatalog(catalog);
               s.close();
            }
         }
         
         // What's the separator between catalog and table name? 
         public String getCatalogSeparator() 
         throws SQLException {
            return ".";
         }
         
         // What's the database vendor's preferred term for "catalog"? 
         public String getCatalogTerm() 
         throws SQLException {
            return "catalog";
         }
         
         // Gets a description of the access rights for a table's columns. 
         public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of table columns available in the specified catalog. 
         public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Retrieves the connection that produced this metadata object. 
         public Connection getConnection() 
         throws SQLException {
            return _connection;
         }
         
         // Gets a description of the foreign key columns in the foreign key table that reference the primary key columns of the primary key table (describe how one table imports another's key.) This should normally return a single foreign key/primary key pair (most tables only import a foreign key from a table once.) They are ordered by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, and KEY_SEQ. 
         public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }

         // What's the name of this database product? 
         public String getDatabaseProductName() 
         throws SQLException {
            return "SQLD";
         }

         // What's the version of this database product? 
         public String getDatabaseProductVersion() 
         throws SQLException {
            return "1.0.0";
         }
         
         // What's the database's default transaction isolation level? The values are defined in java.sql.Connection. 
         public int getDefaultTransactionIsolation() 
         throws SQLException {
            return Connection.TRANSACTION_NONE;
         }
         
         // What's this JDBC driver's major version number? 
         public int getDriverMajorVersion() {
            return 2;
         }
         
         // What's this JDBC driver's minor version number? 
         public int getDriverMinorVersion() {
            return 0;
         }
         
         // What's the name of this JDBC driver? 
         public String getDriverName() 
         throws SQLException {
            return "SQLD JDBC Driver";
         }
         
         // What's the version of this JDBC driver? 
         public String getDriverVersion() 
         throws SQLException {
            return VERSION;
         }
         
         // Gets a description of the foreign key columns that reference a table's primary key columns (the foreign keys exported by a table). 
         public ResultSet getExportedKeys(String catalog, String schema, String table) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets all the "extra" characters that can be used in unquoted identifier names (those beyond a-z, A-Z, 0-9 and _). 
         public String getExtraNameCharacters() 
         throws SQLException {
            return "";
         }
         
         // What's the string used to quote SQL identifiers? This returns a space " " if identifier quoting isn't supported. 
         public String getIdentifierQuoteString() 
         throws SQLException {
            return "\"";
         }
         
         // Gets a description of the primary key columns that are referenced by a table's foreign key columns (the primary keys imported by a table). 
         public ResultSet getImportedKeys(String catalog, String schema, String table) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of a table's indices and statistics. 
         public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // How many hex characters can you have in an inline binary literal? 
         public int getMaxBinaryLiteralLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length of a catalog name? 
         public int getMaxCatalogNameLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the max length for a character literal? 
         public int getMaxCharLiteralLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the limit on column name length? 
         public int getMaxColumnNameLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of columns in a "GROUP BY" clause? 
         public int getMaxColumnsInGroupBy() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of columns allowed in an index? 
         public int getMaxColumnsInIndex() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of columns in an "ORDER BY" clause? 
         public int getMaxColumnsInOrderBy() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of columns in a "SELECT" list? 
         public int getMaxColumnsInSelect() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of columns in a table? 
         public int getMaxColumnsInTable() 
         throws SQLException {
            return 0;
         }
         
         // How many active connections can we have at a time to this database? 
         public int getMaxConnections() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum cursor name length? 
         public int getMaxCursorNameLength() 
         throws SQLException {
            return 0;
         }
         
         // Retrieves the maximum number of bytes for an index, including all of the parts of the index. 
         public int getMaxIndexLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length of a procedure name? 
         public int getMaxProcedureNameLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length of a single row? 
         public int getMaxRowSize() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length allowed for a schema name? 
         public int getMaxSchemaNameLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length of an SQL statement? 
         public int getMaxStatementLength() 
         throws SQLException {
            return 0;
         }
         
         // How many active statements can we have open at one time to this database? 
         public int getMaxStatements() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum length of a table name? 
         public int getMaxTableNameLength() 
         throws SQLException {
            return 0;
         }
         
         // What's the maximum number of tables in a SELECT statement? 
         public int getMaxTablesInSelect() 
         throws SQLException {
            return 0;
         }
         

         // What's the maximum length of a user name? 
         public int getMaxUserNameLength() 
         throws SQLException {
            return 0;
         }
         
         // Gets a comma-separated list of math functions. 
         public String getNumericFunctions() 
         throws SQLException {
            return "";
         }
         
         // Gets a description of a table's primary key columns. 
         public ResultSet getPrimaryKeys(String catalog, String schema, String table) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of a catalog's stored procedure parameters and result columns. 
         public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of the stored procedures available in a catalog. 
         public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // What's the database vendor's preferred term for "procedure"? 
         public String getProcedureTerm() 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }

         // Gets the schema names available in this database. 
         public ResultSet getSchemas() 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // What's the database vendor's preferred term for "schema"? 
         public String getSchemaTerm() 
         throws SQLException {
            return "schema";
         }
         
         // Gets the string that can be used to escape wildcard characters. 
         public String getSearchStringEscape() 
         throws SQLException {
            return "\\";
         }
         
         // Gets a comma-separated list of all a database's SQL keywords that are NOT also SQL92 keywords. 
         public String getSQLKeywords() 
         throws SQLException {
            return "CURRENT,DATABASE";
         }
         
         // Gets a comma-separated list of string functions. 
         public String getStringFunctions() 
         throws SQLException {
            return "LEFT,RIGHT,SOUNDEX,CONCAT,SUBSTRING";
         }
         
         // Gets a comma-separated list of system functions. 
         public String getSystemFunctions() 
         throws SQLException {
            return "";
         }
         
         // Gets a description of the access rights for each table available in a catalog. 
         public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of tables available in a catalog. 
         public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) 
         throws SQLException {
            String oldCatalog = _connection.getCatalog();
            _connection.setCatalog(catalog);
            try {
               Statement s = _connection.createStatement();
               if(catalog != null)
                  catalog = "\'" + SQLEncoder.encode(catalog) + "\'";
               String sql = "SELECT \'" + SQLEncoder.encode(catalog) + "\' AS TABLE_CAT, "
                            +"NULL AS TABLE_SCHEM, " 
                            +"TableName AS TABLE_NAME, "
                            +"\'TABLE\' AS TABLE_TYPE, "
                            +"\'None\' AS REMARKS "
                            +"FROM Master "
                            +"WHERE UNIQUE(\'TableName\', TableName) ";
               if(tableNamePattern != null)
                  sql += "AND ColumnName LIKE \'" + SQLEncoder.encode(tableNamePattern) + "\' ";
               sql += "ORDER BY TABLE_NAME";
               ResultSet rs = s.executeQuery(sql);
               return rs;
            }
            finally {
               _connection.setCatalog(oldCatalog);
            }
         }
         
         // Gets the table types available in this database. 
         public ResultSet getTableTypes() 
         throws SQLException {
            Statement s = _connection.createStatement();
            String sql = "SELECT \'TABLE\' AS TABLE_TYPE";
            ResultSet rs = s.executeQuery(sql);
            return rs;
         }
         
         // Gets a comma-separated list of time and date functions. 
         public String getTimeDateFunctions() 
         throws SQLException {
            return "";
         }
         
         // Gets a description of all the standard SQL types supported by this database. 
         public ResultSet getTypeInfo() 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Gets a description of the user-defined types defined in a particular schema. 
         public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // What's the url for this database? 
         public String getURL() 
         throws SQLException {
            return _url;
         }
         
         // What's our user name as known to the database? 
         public String getUserName() 
         throws SQLException {
            return _username;
         }
         
         // Gets a description of a table's columns that are automatically updated when any value in a row is updated. 
         public ResultSet getVersionColumns(String catalog, String schema, String table) 
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
         
         // Indicates whether or not a visible row insert can be detected by calling ResultSet.rowInserted(). 
         public boolean insertsAreDetected(int type) 
         throws SQLException {
            return false;
         }
         
         // Does a catalog appear at the start of a qualified table name? (Otherwise it appears at the end) 
         public boolean isCatalogAtStart() 
         throws SQLException {
            return true;
         }
         
         // Is the database in read-only mode? 
         public boolean isReadOnly() 
         throws SQLException {
            return false;
         }
         
         // Are concatenations between NULL and non-NULL values NULL? For SQL-92 compliance, a JDBC technology-enabled driver will return true. 
         public boolean nullPlusNonNullIsNull() 
         throws SQLException {
            return true;
         }
         
         // Are NULL values sorted at the end regardless of sort order? 
         public boolean nullsAreSortedAtEnd() 
         throws SQLException {
            return false;
         }
         
         // Are NULL values sorted at the start regardless of sort order? 
         public boolean nullsAreSortedAtStart() 
         throws SQLException {
            return true;
         }
         
         // Are NULL values sorted high? 
         public boolean nullsAreSortedHigh() 
         throws SQLException {
            return true;
         }
         
         // Are NULL values sorted low? 
         public boolean nullsAreSortedLow() 
         throws SQLException {
            return false;
         }
         
         // Indicates whether deletes made by others are visible. 
         public boolean othersDeletesAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Indicates whether inserts made by others are visible. 
         public boolean othersInsertsAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Indicates whether updates made by others are visible. 
         public boolean othersUpdatesAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Indicates whether a result set's own deletes are visible. 
         public boolean ownDeletesAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Indicates whether a result set's own inserts are visible. 
         public boolean ownInsertsAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Indicates whether a result set's own updates are visible. 
         public boolean ownUpdatesAreVisible(int type) 
         throws SQLException {
            return true;
         }
         
         // Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in lower case? 
         public boolean storesLowerCaseIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in lower case? 
         public boolean storesLowerCaseQuotedIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in mixed case? 
         public boolean storesMixedCaseIdentifiers() 
         throws SQLException {
            return true;
         }
         
         // Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in mixed case? 
         public boolean storesMixedCaseQuotedIdentifiers() 
         throws SQLException {
            return true;
         }
         
         // Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in upper case? 
         public boolean storesUpperCaseIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in upper case? 
         public boolean storesUpperCaseQuotedIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Is "ALTER TABLE" with add column supported? 
         public boolean supportsAlterTableWithAddColumn() 
         throws SQLException {
            return false;
         }
         
         // Is "ALTER TABLE" with drop column supported? 
         public boolean supportsAlterTableWithDropColumn() 
         throws SQLException {
            return false;
         }
         
         // Is the ANSI92 entry level SQL grammar supported? All JDBC CompliantTM drivers must return true. 
         public boolean supportsANSI92EntryLevelSQL() 
         throws SQLException {
            return true;
         }
         
         // Is the ANSI92 full SQL grammar supported? 
         public boolean supportsANSI92FullSQL() 
         throws SQLException {
            return false;
         }
         
         // Is the ANSI92 intermediate SQL grammar supported? 
         public boolean supportsANSI92IntermediateSQL() 
         throws SQLException {
            return false;
         }
         
         // Indicates whether the driver supports batch updates. 
         public boolean supportsBatchUpdates() 
         throws SQLException {
            return false;
         }
         
         // Can a catalog name be used in a data manipulation statement? 
         public boolean supportsCatalogsInDataManipulation() 
         throws SQLException {
            return false;
         }
         
         // Can a catalog name be used in an index definition statement? 
         public boolean supportsCatalogsInIndexDefinitions() 
         throws SQLException {
            return false;
         }
         
         // Can a catalog name be used in a privilege definition statement? 
         public boolean supportsCatalogsInPrivilegeDefinitions() 
         throws SQLException {
            return false;
         }
         
         // Can a catalog name be used in a procedure call statement? 
         public boolean supportsCatalogsInProcedureCalls() 
         throws SQLException {
            return false;
         }
         
         // Can a catalog name be used in a table definition statement? 
         public boolean supportsCatalogsInTableDefinitions() 
         throws SQLException {
            return false;
         }
                   
         // Is column aliasing supported?  
         public boolean supportsColumnAliasing() 
         throws SQLException {
            return true;
         }
         
         // Is the CONVERT function between SQL types supported? 
         public boolean supportsConvert() 
         throws SQLException {
            return false;
         }
         
         // Is CONVERT between the given SQL types supported? 
         public boolean supportsConvert(int fromType, int toType) 
         throws SQLException {
            return false;
         }
         
         // Is the ODBC Core SQL grammar supported? 
         public boolean supportsCoreSQLGrammar() 
         throws SQLException {
            return false;
         }
         
         // Are correlated subqueries supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsCorrelatedSubqueries() 
         throws SQLException {
            return true;
         }
         
         // Are both data definition and data manipulation statements within a transaction supported? 
         public boolean supportsDataDefinitionAndDataManipulationTransactions() 
         throws SQLException {
            return false;
         }
         
         // Are only data manipulation statements within a transaction supported? 
         public boolean supportsDataManipulationTransactionsOnly() 
         throws SQLException {
            return false;
         }
         
         // If table correlation names are supported, are they restricted to be different from the names of the tables? 
         public boolean supportsDifferentTableCorrelationNames() 
         throws SQLException {
            return false;
         }
         
         // Are expressions in "ORDER BY" lists supported? 
         public boolean supportsExpressionsInOrderBy() 
         throws SQLException {
            return false;
         }
         
         // Is the ODBC Extended SQL grammar supported? 
         public boolean supportsExtendedSQLGrammar() 
         throws SQLException {
            return false;
         }
         
         // Are full nested outer joins supported? 
         public boolean supportsFullOuterJoins() 
         throws SQLException {
            return false;
         }
         
         // Is some form of "GROUP BY" clause supported? 
         public boolean supportsGroupBy() 
         throws SQLException {
            return false;
         }
         
         // Can a "GROUP BY" clause add columns not in the SELECT provided it specifies all the columns in the SELECT? 
         public boolean supportsGroupByBeyondSelect() 
         throws SQLException {
            return false;
         }
         
         // Can a "GROUP BY" clause use columns not in the SELECT? 
         public boolean supportsGroupByUnrelated() 
         throws SQLException {
            return false;
         }
         
         // Is the SQL Integrity Enhancement Facility supported? 
         public boolean supportsIntegrityEnhancementFacility() 
         throws SQLException {
            return false;
         }
         
         // Is the escape character in "LIKE" clauses supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsLikeEscapeClause() 
         throws SQLException {
            return true;
         }
         
         // Is there limited support for outer joins? (This will be true if supportFullOuterJoins is true.) 
         public boolean supportsLimitedOuterJoins() 
         throws SQLException {
            return false;
         }
         
         // Is the ODBC Minimum SQL grammar supported? All JDBC CompliantTM drivers must return true. 
         public boolean supportsMinimumSQLGrammar() 
         throws SQLException {
            return true;
         }
          
         // Does the database treat mixed case unquoted SQL identifiers as case sensitive and as a result store them in mixed case? A JDBC CompliantTM driver will always return false. 
         public boolean supportsMixedCaseIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Does the database treat mixed case quoted SQL identifiers as case sensitive and as a result store them in mixed case? A JDBC CompliantTM driver will always return true. 
         public boolean supportsMixedCaseQuotedIdentifiers() 
         throws SQLException {
            return false;
         }
         
         // Are multiple ResultSet from a single execute supported? 
         public boolean supportsMultipleResultSets() 
         throws SQLException {
            return false;
         }
         
         // Can we have multiple transactions open at once (on different connections)? 
         public boolean supportsMultipleTransactions() 
         throws SQLException {
            return false;
         }
         
         // Can columns be defined as non-nullable? A JDBC CompliantTM driver always returns true. 
         public boolean supportsNonNullableColumns() 
         throws SQLException {
            return false;
         }
         
         // Can cursors remain open across commits? 
         public boolean supportsOpenCursorsAcrossCommit() 
         throws SQLException {
            return false;
         }
         
         // Can cursors remain open across rollbacks? 
         public boolean supportsOpenCursorsAcrossRollback() 
         throws SQLException {
            return false;
         }
         
         // Can statements remain open across commits? 
         public boolean supportsOpenStatementsAcrossCommit() 
         throws SQLException {
            return false;
         }
         
         // Can statements remain open across rollbacks? 
         public boolean supportsOpenStatementsAcrossRollback() 
         throws SQLException {
            return false;
         }
         
         // Can an "ORDER BY" clause use columns not in the SELECT statement? 
         public boolean supportsOrderByUnrelated() 
         throws SQLException {
            return true;
         }
         
         // Is some form of outer join supported? 
         public boolean supportsOuterJoins() 
         throws SQLException {
            return false;
         }
         
         // Is positioned DELETE supported? 
         public boolean supportsPositionedDelete() 
         throws SQLException {
            return false;
         }
         
         // Is positioned UPDATE supported? 
         public boolean supportsPositionedUpdate() 
         throws SQLException {
            return false;
         }
         
         // Does the database support the concurrency type in combination with the given result set type? 
         public boolean supportsResultSetConcurrency(int type, int concurrency) 
         throws SQLException {
            if(concurrency == ResultSet.CONCUR_READ_ONLY 
               && type == ResultSet.TYPE_FORWARD_ONLY)
               return true;
            return false;
         }
         
         // Does the database support the given result set type? 
         public boolean supportsResultSetType(int type) 
         throws SQLException {
            if(type == ResultSet.TYPE_FORWARD_ONLY)
               return true;
            return false;
         }
         
         // Can a schema name be used in a data manipulation statement? 
         public boolean supportsSchemasInDataManipulation() 
         throws SQLException {
            return false;
         }
         
         // Can a schema name be used in an index definition statement? 
         public boolean supportsSchemasInIndexDefinitions() 
         throws SQLException {
            return false;
         }
         
         // Can a schema name be used in a privilege definition statement? 
         public boolean supportsSchemasInPrivilegeDefinitions() 
         throws SQLException {
            return false;
         }
         
         // Can a schema name be used in a procedure call statement? 
         public boolean supportsSchemasInProcedureCalls() 
         throws SQLException {
            return false;
         }
         
         // Can a schema name be used in a table definition statement? 
         public boolean supportsSchemasInTableDefinitions() 
         throws SQLException {
            return false;
         }
         
         // Is SELECT for UPDATE supported? 
         public boolean supportsSelectForUpdate() 
         throws SQLException {
            return false;
         }
         
         // Are stored procedure calls using the stored procedure escape syntax supported? 
         public boolean supportsStoredProcedures() 
         throws SQLException {
            return false;
         }
         
         // Are subqueries in comparison expressions supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsSubqueriesInComparisons() 
         throws SQLException {
            return false;
         }
         
         // Are subqueries in 'exists' expressions supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsSubqueriesInExists() 
         throws SQLException {
            return false;
         }
         
         // Are subqueries in 'in' statements supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsSubqueriesInIns() 
         throws SQLException {
            return true;
         }
         
         // Are subqueries in quantified expressions supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsSubqueriesInQuantifieds() 
         throws SQLException {
            return false;
         }
         
         // Are table correlation names supported? A JDBC CompliantTM driver always returns true. 
         public boolean supportsTableCorrelationNames() 
         throws SQLException {
            return false;
         }
         
         // Does this database support the given transaction isolation level? 
         public boolean supportsTransactionIsolationLevel(int level) 
         throws SQLException {
            if(level == Connection.TRANSACTION_NONE)
               return true;
            return false;
         }
         
         // Are transactions supported? If not, invoking the method commit is a noop and the isolation level is TRANSACTION_NONE. 
         public boolean supportsTransactions() 
         throws SQLException {
            return false;
         }

         // Is SQL UNION supported? 
         public boolean supportsUnion() 
         throws SQLException {
            return false;
         }
         
         // Is SQL UNION ALL supported? 
         public boolean supportsUnionAll() 
         throws SQLException {
            return false;
         }
         
         // Indicates whether or not a visible row update can be detected by calling the method ResultSet.rowUpdated. 
         public boolean updatesAreDetected(int type) 
         throws SQLException {
            return false;
         }
         
         // Does the database use a file for each table? 
         public boolean usesLocalFilePerTable() 
         throws SQLException {
            return true;
         }
         
         // Does the database store tables in a local file? 
         public boolean usesLocalFiles() 
         throws SQLException {
            return true;
         }
      }
      
      private String _readError(BufferedReader br)
      throws IOException {
         String res;
         StringBuffer error = new StringBuffer();
         while((res = br.readLine()) != null) {
            if(res.compareTo("~~~END-OF-ERROR-MESSAGE~~~") == 0)
               break;
            error.append(res + "\n");
         }
         return error.toString();
      }
      
      private String _getResponse()
      throws IOException, SQLException {
         return _getResponse(_br);
      }
      
      private String _getResponse(BufferedReader br)
      throws IOException, SQLException {
         String res = br.readLine();
         if(res == null)
            throw new SQLException("Unable to read response code from server!");
         if(res.compareTo("ERROR") == 0)
            throw new SQLException(_readError(br));
         if(res.compareTo("OK") != 0 && res.compareTo("END") != 0)
            throw new SQLException("Bad response code!");
         return res;
      }
      
      private SQLDConnection(String url, Properties info)
      throws SQLException {
         _url = url;
         _username = info.getProperty("user");
         _password = info.getProperty("password");
         int i;
         url = url.substring(10);
         i = url.indexOf(':');
         if(i < 0 || (i+1) > url.length())
            throw new SQLException("No port number in the DB URL!");
         _host = url.substring(0, i);
         url = url.substring(i+1);
         i = url.indexOf(':');
         if(i >= 0 && (i+1) < url.length()) {
            _port = Integer.parseInt(url.substring(0,i));
            _currCat = url.substring(i+1);
         }
         else {
            _port = Integer.parseInt(url);
            _currCat = null;
         }
         
         _sock = null;
         try {
            _sock = new Socket(_host, _port);
            _out = new PrintWriter(new BufferedOutputStream(_sock.getOutputStream()));
            _br = new BufferedReader(new InputStreamReader(_sock.getInputStream()));
            String auth = _br.readLine();
            if(auth.compareTo("Authentication") != 0) 
               throw new SQLException("No Authentication!");
            _out.println(_username + ";" + _password + ";");
            _out.flush();
            _getResponse();
            if(_currCat != null) {
               _out.print("SET CURRENT DATABASE " + _currCat + ";");
               _out.flush();
               _getResponse();
            }
         }
         catch(IOException ioe) {
            if(_sock != null) {
               try {
                  _sock.close();
               }
               catch(IOException ioe2) {
                  ;
               }
            }
            throw new SQLException(ioe.getMessage());
         }
      }
      
      // Clears all warnings reported for this Connection object. 
      public void clearWarnings() 
      throws SQLException {
      }
      
      // Releases a Connection's database and JDBC resources immediately instead of waiting for them to be automatically released. 
      public void close()
      throws SQLException {
         try {
            synchronized(_out) {
               _out.println("exit;");
               _out.flush();
               _sock.close();
            }
         }
         catch(IOException ioe) {
            throw new SQLException(ioe.getMessage());
         }
      }
      
      // Makes all changes made since the previous commit/rollback permanent and releases any database locks currently held by the Connection. 
      public void commit()
      throws SQLException {
      }
      
      class SQLDStatement implements Statement {
         private ResultSet _currRS = null;
         private Connection _con;
         
         private SQLDStatement(Connection con) {
            _con = con;
         }
         
         // Adds an SQL command to the current batch of commmands for this Statement object. 
         public void addBatch(String sql)
         throws SQLException {
         }
         
         // Cancels this Statement object if both the DBMS and driver support aborting an SQL statement. 
         public void cancel()
         throws SQLException {
         }
          
         // Makes the set of commands in the current batch empty. 
         public void clearBatch()
         throws SQLException {
         }
          
         // Clears all the warnings reported on this Statement object. 
         public void clearWarnings()
         throws SQLException {
         }
         
 
         // Releases this Statement object's database and JDBC resources immediately instead of waiting for this to happen when it is automatically closed. 
         public void close()
         throws SQLException {
         }
         
         // Executes an SQL statement that may return multiple results. 
         public boolean execute(String sql)
         throws SQLException {
            throw new SQLException("Not implemented!");
         }
          
         // Submits a batch of commands to the database for execution and if all commands execute successfully, returns an array of update counts. 
         public int[] executeBatch()
         throws SQLException {
            return null;
         }
         
         class SQLDResultSet implements ResultSet {
            private String _id;
            private Socket _sock = null;
            private BufferedReader _br;
            private PrintStream _ps;
            private Hashtable _map;
            private Vector _columnNames = new Vector();
            private Vector _columnTypes = new Vector();
            private Vector _line;
            private Statement _s;
            private boolean _wasNull = false;
            
            private class SQLDResultSetMetaData implements ResultSetMetaData {
               // Gets the designated column's table's catalog name. 
               public String getCatalogName(int column) 
               throws SQLException {
                  return _currCat;
               }
               
               // Returns the fully-qualified name of the Java class whose instances are manufactured if the method ResultSet.getObject is called to retrieve a value from the column. 
               public String getColumnClassName(int column) 
               throws SQLException {
                  return "java.lang.String";
               }
         
               // Returns the number of columns in this ResultSet object. 
               public int getColumnCount() 
               throws SQLException {
                  return _columnNames.size();
               }
         
               // Indicates the designated column's normal maximum width in characters. 
               public int getColumnDisplaySize(int column) 
               throws SQLException {
                  return 1024;
               }
         
               // Gets the designated column's suggested title for use in printouts and displays. 
               public String getColumnLabel(int column) 
               throws SQLException {
                  column--;
                  return (String)_columnNames.elementAt(column);
               }
         
               // Get the designated column's name. 
               public String getColumnName(int column) 
               throws SQLException {
                  column--;
                  return (String)_columnNames.elementAt(column);
               }
               
               // Retrieves the designated column's SQL type. 
               public int getColumnType(int column) 
               throws SQLException {
                  column--;
                  String type = (String)_columnTypes.elementAt(column);
                  if(type.equalsIgnoreCase("INT"))
                     return Types.INTEGER;
                  else if(type.equalsIgnoreCase("TEXT"))
                     return Types.VARCHAR;
                  else if(type.equalsIgnoreCase("FLOAT"))
                     return Types.REAL;
                  else if(type.equalsIgnoreCase("BOOLEAN"))
                     return Types.INTEGER;
                  else
                     throw new SQLException("Unknown type!");
               }
               
               // Retrieves the designated column's database-specific type name. 
               public String getColumnTypeName(int column) 
               throws SQLException {
                  return (String)_columnTypes.elementAt(column);
               }
               
               // Get the designated column's number of decimal digits. 
               public int getPrecision(int column) 
               throws SQLException {
                  return -1;
               }
                  
               // Gets the designated column's number of digits to right of the decimal point. 
               public int getScale(int column) 
               throws SQLException {
                  return -1;
               }
         
               // Get the designated column's table's schema. 
               public String getSchemaName(int column) 
               throws SQLException {
                  return null;
               }
         
               // Gets the designated column's table name. 
               public String getTableName(int column) 
               throws SQLException {
                  return null;
               }
         
               // Indicates whether the designated column is automatically numbered, thus read-only. 
               public boolean isAutoIncrement(int column) 
               throws SQLException {
                  return false;
               } 
               
               // Indicates whether a column's case matters. 
               public boolean isCaseSensitive(int column) 
               throws SQLException {
                  return false;
               } 
         
               // Indicates whether the designated column is a cash value. 
               public boolean isCurrency(int column) 
               throws SQLException {
                  column--;
                  if(_columnTypes.elementAt(column).toString().equalsIgnoreCase("FLOAT"))
                     return true;
                  return false;
               } 
         
               // Indicates whether a write on the designated column will definitely succeed. 
               public boolean isDefinitelyWritable(int column) 
               throws SQLException {
                  return false;
               } 
               
               // Indicates the nullability of values in the designated column. 
               public int isNullable(int column) 
               throws SQLException {
                  return ResultSetMetaData.columnNullable;
               } 
               
               // Indicates whether the designated column is definitely not writable. 
               public boolean isReadOnly(int column) 
               throws SQLException {
                  return true;
               } 
         
               // Indicates whether the designated column can be used in a where clause. 
               public boolean isSearchable(int column) 
               throws SQLException {
                  return true;
               } 
               
               // Indicates whether values in the designated column are signed numbers. 
               public boolean isSigned(int column) 
               throws SQLException {
                  String type = (String)_columnTypes.elementAt(column);
                  if(type.equalsIgnoreCase("INT") || type.equalsIgnoreCase("FLOAT"))
                     return true;
                  return false;
               } 

               // Indicates whether it is possible for a write on the designated column to succeed.
               public boolean isWritable(int column)  
               throws SQLException {
                  return false;
               } 
            }
            
            private boolean _readRec() throws IOException {
               String rec = _br.readLine();
               if(rec == null)
                  return false;
               _line = new Vector();
               StringBuffer field;
               boolean gotQ, gotC = false;
               int i = 0, j = 0;
               while(i < rec.length()) {
                  gotC = gotQ = false;
                  field = new StringBuffer();
                  if(rec.charAt(i) == '\"') {
                     gotQ = true;
                     i++;
                  }
                  while(i < rec.length()) {
                     if(rec.charAt(i) == '\"' && gotQ) {
                        if(i+1 < rec.length()) {
                           if(rec.charAt(i+1) == '\"') {
                              field.append('\"'); 
                              i++;
                           }
                           else {
                              gotQ = false;
                              break;
                           }
                        }
                        else
                           break;
                     }
                     else {
                        if(!gotQ && rec.charAt(i) == ',')
                           break;
                        field.append(rec.charAt(i));
                     }
                     while((i+1) == rec.length() && gotQ) {
                        String temp = _br.readLine();
                        if(temp != null) {
                           rec += "\n";
                           rec += temp;
                        }
                        else
                           break;
                     }
                     i++;
                  }
                  if(i < rec.length())
                     if(rec.charAt(i) == '\"')
                        i++;
                  if(i < rec.length())
                     if(rec.charAt(i) == ',') {
                        i++; 
                        gotC = true;
                     }
                  _line.addElement(field.toString());
               }
               if(gotC)
                  _line.addElement("");         
               return true;
            }
            
            SQLDResultSet(String id, Statement s)
            throws IOException, SQLException {
               try {
                  _s = s;
                  _id = id;
                  _sock = new Socket(_host, _port);
                  _br = new BufferedReader(new InputStreamReader(_sock.getInputStream()));
                  _ps = new PrintStream(new BufferedOutputStream(_sock.getOutputStream()));
                  String res = _br.readLine();
                  if(res == null)
                     throw new SQLException("No Authentication!");
                  if(res.compareTo("Authentication") != 0)
                     throw new SQLException("No Authentication!");
                  _ps.println(_username + ";" + _password + ";");
                  _ps.flush();
                  res = _br.readLine();
                  if(res == null)
                     throw new SQLException("Unable to get results!");
                  _ps.println("get results " + _id + ";");
                  _ps.flush();
                  _getResponse(_br);
                  if(!_readRec())
                     throw new SQLException("Unable to read column names!");
                  _map = new Hashtable();
                  for(int i = 0; i < _line.size(); i++) {
                     _map.put(_line.elementAt(i).toString().toLowerCase(), new Integer(i));
                     _columnNames.addElement(_line.elementAt(i));
                  }
                  if(!_readRec())
                     throw new SQLException("Unable to read column types!");
                  for(int i = 0; i < _line.size(); i++)
                     _columnTypes.addElement(_line.elementAt(i));
                  _line = null;
               }
               catch(SQLException sqle) {
                  if(_sock != null)
                     _sock.close();
                  throw sqle;
               }
               catch(IOException ioe) {
                  if(_sock != null)
                     _sock.close();
                  throw ioe;
               }
            }
          
            // Moves the cursor to the given row number in this ResultSet object. 
            public boolean absolute(int row)
            throws SQLException {
               throw new SQLException("TYPE_FORWARD_ONLY");
            }
          
            // Moves the cursor to the end of this ResultSet object, just after the last row. 
            public void afterLast()
            throws SQLException {
            }
          
            // Moves the cursor to the front of this ResultSet object, just before the first row. 
            public void beforeFirst()
            throws SQLException {
               try {
                  _line = null;
                  _ps.println("reset;");
                  _ps.flush();
                  _getResponse(_br);
               }
               catch(IOException ioe) {
                  throw new SQLException(ioe.getMessage());
               }
            }

            // Cancels the updates made to the current row in this ResultSet object. 
            public void cancelRowUpdates()
            throws SQLException {
            }
         
            // Clears all warnings reported on this ResultSet object. 
            public void clearWarnings()
            throws SQLException {
            }
          
            // Releases this ResultSet object's database and JDBC resources immediately instead of waiting for this to happen when it is automatically closed. 
            public void close()
            throws SQLException {
               try {
                  _ps.println("close;");
                  _ps.flush();
                  _ps.println("exit;");
                  _ps.flush();
                  _sock.close();
               }
               catch(IOException ioe) {
                  throw new SQLException(ioe.getMessage());
               }
            }
          
            // Deletes the current row from this ResultSet object and from the underlying database. 
            public void deleteRow()
            throws SQLException {
            }
          
            // Maps the given ResultSet column name to its ResultSet column index. 
            public int findColumn(String columnName)
            throws SQLException {
               Integer i = (Integer)_map.get(columnName);
               if(i == null)
                  return -1;
               return i.intValue();
            }
          
            // Moves the cursor to the first row in this ResultSet object. 
            public boolean first()
            throws SQLException {
               this.beforeFirst();
               return next();
            }
          
            // Returns the value of the designated column in the current row of this ResultSet object as an Array object in the Java programming language. 
            public Array getArray(int i)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as an Array object in the Java programming language. 
            public Array getArray(String colName)
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a stream of ASCII characters. 
            public InputStream getAsciiStream(int columnIndex)
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a stream of ASCII characters. 
            public InputStream getAsciiStream(String columnName)
            throws SQLException {
               return null;
            }
         
            //  Gets the value of the designated column in the current row of this ResultSet object as a java.math.BigDecimal with full precision. 
            public BigDecimal getBigDecimal(int columnIndex)
            throws SQLException {
               String value = getString(columnIndex);
               if(value == null)
                  return null;
               return new BigDecimal(value);
            }
         
            // Deprecated.   
            public BigDecimal getBigDecimal(int columnIndex, int scale)
            throws SQLException {
               String value = getString(columnIndex);
               if(value == null)
                  return null;
               return new BigDecimal(value);
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.math.BigDecimal with full precision. 
            public BigDecimal getBigDecimal(String columnName)
            throws SQLException {
               String value = getString(columnName);
               if(value == null)
                  return null;
               return new BigDecimal(value);
            }
         
            // Deprecated.   
            public BigDecimal getBigDecimal(String columnName, int scale)
            throws SQLException {
               String value = getString(columnName);
               if(value == null)
                  return null;
               return new BigDecimal(value);
            }
         
            // Gets the value of a column in the current row as a stream of Gets the value of the designated column in the current row of this ResultSet object as a binary stream of uninterpreted bytes. 
            public InputStream getBinaryStream(int columnIndex)
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a stream of uninterpreted bytes. 
            public InputStream getBinaryStream(String columnName)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a Blob object in the Java programming language. 
            public Blob getBlob(int i)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a Blob object in the Java programming language. 
            public Blob getBlob(String colName)
            throws SQLException {
               return null;
            }
            
            // Gets the value of the designated column in the current row of this ResultSet object as a boolean in the Java programming language. 
            public boolean getBoolean(int columnIndex)
            throws SQLException {
               columnIndex--;
               String type = _columnTypes.elementAt(columnIndex).toString();
               String data = getString(columnIndex);
               if(data == null)
                  return false;
               if(type.equalsIgnoreCase("INT")) {
                  int i = Integer.parseInt(data);
                  if(i == 0)
                     return false;
                  return true;
               }
               else if(type.equalsIgnoreCase("BOOLEAN"))
                  return new Boolean(data).booleanValue();
               throw new SQLException("Can not convert " + type + " to boolean!");
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a boolean in the Java programming language. 
            public boolean getBoolean(String columnName)
            throws SQLException {
               Integer index = (Integer)_map.get(columnName);
               if(index == null)
                  throw new SQLException("Column name "+ columnName + " not found!");
               String type = _columnTypes.elementAt(index.intValue()).toString();
               String data = getString(columnName);
               if(data == null)
                  return false;
               if(type.equalsIgnoreCase("INT")) {
                  int i = Integer.parseInt(data);
                  if(i == 0)
                     return false;
                  return true;
               }
               else if(type.equalsIgnoreCase("BOOLEAN"))
                  return new Boolean(data).booleanValue();
               throw new SQLException("Can not convert " + type + " to boolean!");
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a byte in the Java programming language. 
            public byte getByte(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0;
               return new Byte(data).byteValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a byte in the Java programming language. 
            public byte getByte(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0;
               return new Byte(data).byteValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a byte array in the Java programming language. 
            public byte[] getBytes(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return data.getBytes();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a byte array in the Java programming language. 
            public byte[] getBytes(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return data.getBytes();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.io.Reader object. 
            public Reader getCharacterStream(int columnIndex)
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.io.Reader object. 
            public Reader getCharacterStream(String columnName)
            throws SQLException {
               return null;
            }
        
            //  Returns the value of the designated column in the current row of this ResultSet object as a Clob object in the Java programming language. 
            public Clob getClob(int i)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a Clob object in the Java programming language. 
            public Clob getClob(String colName)
            throws SQLException {
               return null;
            }
         
            // Returns the concurrency mode of this ResultSet object. 
            public int getConcurrency()
            throws SQLException {
               return ResultSet.CONCUR_READ_ONLY;
            }
         
            // Gets the name of the SQL cursor used by this ResultSet object. 
            public String getCursorName()
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Date object in the Java programming language. 
            public java.sql.Date getDate(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Date(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Date object in the Java programming language. 
            public java.sql.Date getDate(int columnIndex, Calendar cal)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Date(new java.util.Date(data).getTime());
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Date object in the Java programming language. 
            public java.sql.Date getDate(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Date(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Date object in the Java programming language. 
            public java.sql.Date getDate(String columnName, Calendar cal)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Date(new java.util.Date(data).getTime());
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a double in the Java programming language. 
            public double getDouble(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0.0;
               return new Double(data).doubleValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a double in the Java programming language. 
            public double getDouble(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0.0;
               return new Double(data).doubleValue();
            }
         
            // Returns the fetch direction for this ResultSet object. 
            public int getFetchDirection()
            throws SQLException {
               return ResultSet.TYPE_FORWARD_ONLY;
            }
         
            // Returns the fetch size for this ResultSet object. 
            public int getFetchSize()
            throws SQLException {
               return 1;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a float in the Java programming language. 
            public float getFloat(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0.0f;
               return new Float(data).floatValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a float in the Java programming language. 
            public float getFloat(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0.0f;
               return new Float(data).floatValue();
            }

            // Gets the value of the designated column in the current row of this ResultSet object as an int in the Java programming language. 
            public int getInt(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0;
               return Integer.parseInt(data);
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as an int in the Java programming language. 
            public int getInt(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0;
               return Integer.parseInt(data);
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a long in the Java programming language. 
            public long getLong(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0L;
               return new Long(data).longValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a long in the Java programming language. 
            public long getLong(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0L;
               return new Long(data).longValue();
            }
         
            // Retrieves the number, types and properties of this ResultSet object's columns. 
            public ResultSetMetaData getMetaData()
            throws SQLException {
               return new SQLDResultSetMetaData();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as an Object in the Java programming language. 
            public Object getObject(int columnIndex)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as an Object in the Java programming language. 
            public Object getObject(int i, Map map)
            throws SQLException {
               return null;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as an Object in the Java programming language. 
            public Object getObject(String columnName)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as an Object in the Java programming language. 
            public Object getObject(String colName, Map map)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a Ref object in the Java programming language. 
            public Ref getRef(int i)
            throws SQLException {
               return null;
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a Ref object in the Java programming language. 
            public Ref getRef(String colName)
            throws SQLException {
               return null;
            }
         
            // Retrieves the current row number. 
            public int getRow()
            throws SQLException {
               return 0;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a short in the Java programming language. 
            public short getShort(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return 0;
               return new Short(data).shortValue();
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a short in the Java programming language. 
            public short getShort(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return 0;
               return new Short(data).shortValue();
            }
         
            // Returns the Statement object that produced this ResultSet object. 
            public Statement getStatement()
            throws SQLException {
               return _s;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a String in the Java programming language. 
            public String getString(int columnIndex)
            throws SQLException {
               columnIndex--;
               if(_line == null) 
                  throw new SQLException("No current row!");
               Object o = _line.elementAt(columnIndex);
               String s = (String)o;
               if(s.compareTo("") == 0) {
                  _wasNull = true;
                  return null;
               }
               else 
                  _wasNull = false;
               return s;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a String in the Java programming language. 
            public String getString(String columnName)
            throws SQLException {
               if(_line == null) 
                  throw new SQLException("No current row!");
               Object o = _map.get(columnName.toLowerCase().trim());
               if(o == null)
                  throw new SQLException("Column name: \"" + columnName + "\" not found!");
               Integer i = (Integer)o;
               o = _line.elementAt(i.intValue());
               String s = (String)o;
               if(s.compareTo("") == 0) {
                  _wasNull = true;
                  return null;
               }
               else
                  _wasNull = false;
               return s;
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Time object in the Java programming language. 
            public Time getTime(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Time(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Time object in the Java programming language. 
            public Time getTime(int columnIndex, Calendar cal)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Time(new java.util.Date(data).getTime());
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Time object in the Java programming language. 
            public Time getTime(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Time(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Time object in the Java programming language. 
            public Time getTime(String columnName, Calendar cal)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Time(new java.util.Date(data).getTime());
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Timestamp object in the Java programming language. 
            public Timestamp getTimestamp(int columnIndex)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Timestamp(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Timestamp object in the Java programming language. 
            public Timestamp getTimestamp(int columnIndex, Calendar cal)
            throws SQLException {
               String data = getString(columnIndex);
               if(data == null)
                  return null;
               return new java.sql.Timestamp(new java.util.Date(data).getTime());
            }
         
            // Gets the value of the designated column in the current row of this ResultSet object as a java.sql.Timestamp object. 
            public Timestamp getTimestamp(String columnName)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Timestamp(new java.util.Date(data).getTime());
            }
         
            // Returns the value of the designated column in the current row of this ResultSet object as a java.sql.Timestamp object in the Java programming language. 
            public Timestamp getTimestamp(String columnName, Calendar cal)
            throws SQLException {
               String data = getString(columnName);
               if(data == null)
                  return null;
               return new java.sql.Timestamp(new java.util.Date(data).getTime());
            }
         
            // Returns the type of this ResultSet object. 
            public int getType()
            throws SQLException {
               return ResultSet.TYPE_FORWARD_ONLY;
            }
         
            // Deprecated. use getCharacterStream in place of getUnicodeStream 
            public InputStream getUnicodeStream(int columnIndex)
            throws SQLException {
               return null;
            }
         
            // Deprecated.   
            public InputStream getUnicodeStream(String columnName)
            throws SQLException {
               return null;
            }
         
            // Returns the first warning reported by calls on this ResultSet object. 
            public SQLWarning getWarnings()
            throws SQLException {
               return null;
            }
         
            // Inserts the contents of the insert row into this ResultSet objaect and into the database. 
            public void insertRow()
            throws SQLException {
            }
         
            // Indicates whether the cursor is after the last row in this ResultSet object. 
            public boolean isAfterLast()
            throws SQLException {
               return false;
            }
         
            // Indicates whether the cursor is before the first row in this ResultSet object. 
            public boolean isBeforeFirst()
            throws SQLException {
               return false;
            }
         
            // Indicates whether the cursor is on the first row of this ResultSet object. 
            public boolean isFirst()
            throws SQLException {
               return false;
            }
         
            // Indicates whether the cursor is on the last row of this ResultSet object. 
            public boolean isLast()
            throws SQLException {
               return false;
            }
         
            // Moves the cursor to the last row in this ResultSet object. 
            public boolean last()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Moves the cursor to the remembered cursor position, usually the current row. 
            public void moveToCurrentRow()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Moves the cursor to the insert row. 
            public void moveToInsertRow()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }

            // Moves the cursor down one row from its current position. 
            public boolean next()
            throws SQLException {
               try {
                  _ps.println("next;");
                  _ps.flush();
                  String res = _getResponse(_br);
                  if(res.compareTo("END") == 0)
                     return false;
                  return _readRec();
               }
               catch(IOException ioe) {
                  throw new SQLException(ioe.getMessage());
               }
            }
         
            // Moves the cursor to the previous row in this ResultSet object. 
            public boolean previous()
            throws SQLException {
               throw new SQLException("Only forward traversals of the result set can be made!");
            }
         
            // Refreshes the current row with its most recent value in the database. 
            public void refreshRow()
            throws SQLException {
            }
         
            // Moves the cursor a relative number of rows, either positive or negative. 
            public boolean relative(int rows)
            throws SQLException {
               if(rows < 0)
                  throw new SQLException("Only forward traversals of the result set can be made!");
               for(int i = 0; i < rows; i++) {
                  if(!next())
                     return false;
               }
               return true;
            }
         
            // Indicates whether a row has been deleted. 
            public boolean rowDeleted()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Indicates whether the current row has had an insertion. 
            public boolean rowInserted()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Indicates whether the current row has been updated. 
            public boolean rowUpdated()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Gives a hint as to the direction in which the rows in this ResultSet object will be processed. 
            public void setFetchDirection(int direction)
            throws SQLException {
            }
         
            // Gives the JDBC driver a hint as to the number of rows that should be fetched from the database when more rows are needed for this ResultSet object. 
            public void setFetchSize(int rows)
            throws SQLException {
            }
         
            // Updates the designated column with an ascii stream value. 
            public void updateAsciiStream(int columnIndex, InputStream x, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an ascii stream value. 
            public void updateAsciiStream(String columnName, InputStream x, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a java.math.BigDecimal value. 
            public void updateBigDecimal(int columnIndex, BigDecimal x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }

            // Updates the designated column with a java.sql.BigDecimal value. 
            public void updateBigDecimal(String columnName, BigDecimal x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a binary stream value. 
            public void updateBinaryStream(int columnIndex, InputStream x, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a binary stream value. 
            public void updateBinaryStream(String columnName, InputStream x, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a boolean value. 
            public void updateBoolean(int columnIndex, boolean x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a boolean value. 
            public void updateBoolean(String columnName, boolean x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a byte value. 
            public void updateByte(int columnIndex, byte x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a byte value. 
            public void updateByte(String columnName, byte x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a byte array value. 
            public void updateBytes(int columnIndex, byte[] x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a boolean value. 
            public void updateBytes(String columnName, byte[] x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a character stream value. 
            public void updateCharacterStream(int columnIndex, Reader x, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a character stream value. 
            public void updateCharacterStream(String columnName, Reader reader, int length)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a java.sql.Date value. 
            public void updateDate(int columnIndex, java.sql.Date x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a java.sql.Date value. 
            public void updateDate(String columnName, java.sql.Date x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a double value. 
            public void updateDouble(int columnIndex, double x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a double value. 
            public void updateDouble(String columnName, double x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a float value. 
            public void updateFloat(int columnIndex, float x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a float value. 
            public void updateFloat(String columnName, float x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an int value. 
            public void updateInt(int columnIndex, int x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an int value. 
            public void updateInt(String columnName, int x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a long value. 
            public void updateLong(int columnIndex, long x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a long value. 
            public void updateLong(String columnName, long x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Gives a nullable column a null value. 
            public void updateNull(int columnIndex)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a null value. 
            public void updateNull(String columnName)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an Object value. 
            public void updateObject(int columnIndex, Object x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an Object value. 
            public void updateObject(int columnIndex, Object x, int scale)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an Object value. 
            public void updateObject(String columnName, Object x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with an Object value. 
            public void updateObject(String columnName, Object x, int scale)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the underlying database with the new contents of the current row of this ResultSet object. 
            public void updateRow()
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a short value. 
            public void updateShort(int columnIndex, short x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
            
            // Updates the designated column with a short value. 
            public void updateShort(String columnName, short x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
            
            // Updates the designated column with a String value. 
            public void updateString(int columnIndex, String x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
  
            // Updates the designated column with a String value. 
            public void updateString(String columnName, String x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
               
            // Updates the designated column with a java.sql.Time value. 
            public void updateTime(int columnIndex, Time x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
             
            // Updates the designated column with a java.sql.Time value.   
            public void updateTime(String columnName, Time x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a java.sql.Timestamp value. 
            public void updateTimestamp(int columnIndex, Timestamp x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Updates the designated column with a java.sql.Timestamp value. 
            public void updateTimestamp(String columnName, Timestamp x)
            throws SQLException {
               throw new SQLException("Not implemented!");
            }
         
            // Reports whether the last column read had a value of SQL NULL. 
            public boolean wasNull()
            throws SQLException {
               return _wasNull;
            }
         }
         
         // Executes an SQL statement that returns a single ResultSet object. 
         public ResultSet executeQuery(String sql)
         throws SQLException {
            try {
               String rsID;
               synchronized(_out) {
                  _out.print(sql+";");
                  _out.flush();
                  _getResponse();
                  rsID = _br.readLine();
               }
               if(rsID == null)
                  throw new SQLException("Can't read result set ID!");
               _currRS = new SQLDResultSet(rsID, this);
               return _currRS;
            }
            catch(IOException ioe) {
               throw new SQLException(ioe.getMessage());
            }
         }
          
         // Executes an SQL INSERT, UPDATE or DELETE statement. 
         public int executeUpdate(String sql)
         throws SQLException {
            try {
               synchronized(_out) {
                  _out.print(sql+";");
                  _out.flush();
                  _getResponse();
               }
               return 1;
            }
            catch(IOException ioe) {
               return -1;
            }
         }
         
         // Returns the Connection object that produced this Statement object. 
         public Connection getConnection()
         throws SQLException {
            return _con;
         }
         
         //  Retrieves the direction for fetching rows from database tables that is the default for result sets generated from this Statement object. 
         public int getFetchDirection()
         throws SQLException {
            return 0;
         }
         
         // Retrieves the number of result set rows that is the default fetch size for result sets generated from this Statement object. 
         public int getFetchSize()
         throws SQLException {
            return 0;
         }
         
         // Returns the maximum number of bytes allowed for any column value. 
         public int getMaxFieldSize()
         throws SQLException {
            return 0;
         }
         
         // Retrieves the maximum number of rows that a ResultSet object can contain. 
         public int getMaxRows()
         throws SQLException {
            return 0;
         }
         
         // Moves to a Statement object's next result. 
         public boolean getMoreResults()
         throws SQLException {
            return false;
         }
         
         // Retrieves the number of seconds the driver will wait for a Statement object to execute. 
         public int getQueryTimeout()
         throws SQLException {
            return 0;
         } 
         
         // Returns the current result as a ResultSet object. 
         public ResultSet getResultSet()
         throws SQLException {
            return _currRS;
         }
         
         // Retrieves the result set concurrency for ResultSet objects generated by this Statement object. 
         public int getResultSetConcurrency()
         throws SQLException {
            return 0;
         }
         
         // Retrieves the result set type for ResultSet objects generated by this Statement object. 
         public int getResultSetType()
         throws SQLException {
            return 0;
         }
         
         // Returns the current result as an update count; if the result is a ResultSet object or there are no more results, -1 is returned. 
         public int getUpdateCount()
         throws SQLException {
            return 0;
         }
         
         // Retrieves the first warning reported by calls on this Statement object. 
         public SQLWarning getWarnings()
         throws SQLException {
            return null;            
         }
         
         // Defines the SQL cursor name that will be used by subsequent Statement object execute methods. 
         public void setCursorName(String name)
         throws SQLException {
         }
         
         // Sets escape processing on or off. 
         public void setEscapeProcessing(boolean enable)
         throws SQLException {
         }
         
         // Gives the driver a hint as to the direction in which the rows in a result set will be processed. 
         public void setFetchDirection(int direction)
         throws SQLException {
         }
         
         // Gives the JDBC driver a hint as to the number of rows that should be fetched from the database when more rows are needed. 
         public void setFetchSize(int rows)
         throws SQLException {
         }
         
         // Sets the limit for the maximum number of bytes in a column to the given number of bytes. 
         public void setMaxFieldSize(int max)
         throws SQLException {
         }
         
         // Sets the limit for the maximum number of rows that any ResultSet object can contain to the given number. 
         public void setMaxRows(int max)
         throws SQLException {
         }
         
         // Sets the number of seconds the driver will wait for a Statement object to execute to the given number of seconds. 
         public void setQueryTimeout(int seconds)
         throws SQLException {
         }
      }
      
      // Creates a Statement object for sending SQL statements to the database. 
      public Statement createStatement()
      throws SQLException {
         return new SQLDStatement(this);
      }
      
      // Creates a Statement object that will generate ResultSet objects with the given type and concurrency. 
      public Statement createStatement(int resultSetType, int resultSetConcurrency)
      throws SQLException {
         return createStatement();
      }
      
      // Gets the current auto-commit state. 
      public boolean getAutoCommit()
      throws SQLException {
         return true;
      }
      
      // Returns the Connection's current catalog name. 
      public String getCatalog()
      throws SQLException {
         return _currCat;
      }
      
      // Gets the metadata regarding this connection's database. 
      public DatabaseMetaData getMetaData()
      throws SQLException {
         return new SQLDDatabaseMetaData(this);
      }
      
      // Gets this Connection's current transaction isolation level. 
      public int getTransactionIsolation()
      throws SQLException {
         return 0;
      }
      
      // Gets the type map object associated with this connection. 
      public Map getTypeMap()
      throws SQLException {
         return null;
      }
      

      // Returns the first warning reported by calls on this Connection. 
      public SQLWarning getWarnings()
      throws SQLException {
         return null;
      } 
      
      // Tests to see if a Connection is closed. 
      public boolean isClosed()
      throws SQLException { 
         return false;
      }
      
      // Tests to see if the connection is in read-only mode. 
      public boolean isReadOnly()
      throws SQLException {   
         return false;
      }
      
      // Converts the given SQL statement into the system's native SQL grammar. 
      public String nativeSQL(String sql)
      throws SQLException {
         return sql;
      }
      
      // Creates a CallableStatement object for calling database stored procedures. 
      public CallableStatement prepareCall(String sql)
      throws SQLException {
         return null;
      }
      
      // Creates a CallableStatement object that will generate ResultSet objects with the given type and concurrency. 
      public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency)
      throws SQLException {
         return null;
      }
      
      // Creates a PreparedStatement object for sending parameterized SQL statements to the database. 
      public PreparedStatement prepareStatement(String sql)
      throws SQLException {
         return null;
      }
      
      // Creates a PreparedStatement object that will generate ResultSet objects with the given type and concurrency. 
      public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency)
      throws SQLException {
         return null;
      }
      
      // Drops all changes made since the previous commit/rollback and releases any database locks currently held by this Connection. 
      public void rollback()
      throws SQLException {
      }
          
      // Sets this connection's auto-commit mode. 
      public void setAutoCommit(boolean autoCommit)
      throws SQLException {
      }
          
      // Sets a catalog name in order to select a subspace of this Connection's database in which to work. 
      public void setCatalog(String catalog)
      throws SQLException {
         try {
            _currCat = catalog;
            synchronized(_out) {
               _out.print("SET CURRENT DATABASE " + _currCat + ";");
               _out.flush();
               _getResponse();
            }
         }
         catch(IOException ioe) {
            throw new SQLException(ioe.getMessage());
         }
      }
      
      // Puts this connection in read-only mode as a hint to enable database optimizations. 
      public void setReadOnly(boolean readOnly)
      throws SQLException {
      }
      
      // Attempts to change the transaction isolation level to the one given. 
      public void setTransactionIsolation(int level)
      throws SQLException {
      }
      
      // Installs the given type map as the type map for this connection.
      public void setTypeMap(Map map)
      throws SQLException {
      }
   }
   
   // Attempts to make a database connection to the given URL. 
   public Connection connect(String url, Properties info)
   throws SQLException {
      return new SQLDConnection(url, info);
   }

   // Gets the driver's major version number. 
   public int getMajorVersion() {
      return 1;
   }
   
   // Gets the driver's minor version number. 
   public int getMinorVersion() {
      return 0;
   }
   
   // Gets information about the possible properties for this driver. 
   public DriverPropertyInfo[] getPropertyInfo(String url, Properties info)
   throws SQLException {
      return null;
   }
    
   public boolean jdbcCompliant() {
      return false; 
   }
}
