package com.mwc.sqld.tools;

import java.io.*;
import java.util.*;
import java.sql.*;

import com.mwc.util.*;

public class sqlcmd implements Runnable {
   private String _url;
   private String _username;
   private String _password;
   private String _tempDirectory;
   private boolean _keepGoing = true;
   
   public sqlcmd(String url,
                 String username,
                 String password,
                 String tempDirectory) {
      _url = url;
      _username = username;
      _password = password;
      _tempDirectory = tempDirectory;
   }

   private String _readLine() {
      StringBuffer buffer = new StringBuffer();
      int ch;
      try {
         while((ch = System.in.read()) != '\n') {
            buffer.append((char)ch);
         }
         return buffer.toString().trim();
      }
      catch(IOException ioe) {
         return null;
      }
   }
   
   private String _readCommand() {
      StringBuffer buffer = new StringBuffer();
      int ch;
      try {
         while((ch = System.in.read()) != ';') {
            buffer.append((char)ch);
         }
         return buffer.toString().trim();
      }
      catch(IOException ioe) {
         return null;
      }
   }
   
   private void _onListCatalogs(Connection connection)
   throws SQLException {
      DatabaseMetaData dbmd = connection.getMetaData();
      ResultSet rs = dbmd.getCatalogs();
      System.out.println("TABLE_CAT");
      while(rs.next()) {
         System.out.println(rs.getString("TABLE_CAT"));
         System.out.flush();
      }
      rs.close();
      System.out.println("[ENTER FOR MAIN MENU]");
      _readLine();
   }

   private void _onListTables(Connection connection)
   throws SQLException {
      System.out.print("Please enter the table name pattern> ");
      String pat = _readLine();
      DatabaseMetaData dbmd = connection.getMetaData();
      ResultSet rs = dbmd.getTables(connection.getCatalog(),
                                    null,
                                    pat,
                                    null);
      /*
TABLE_CAT String => table catalog (may be null) 
TABLE_SCHEM String => table schema (may be null) 
TABLE_NAME String => table name 
TABLE_TYPE String => table type. Typical types are "TABLE", "VIEW", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM". 
REMARKS String => explanatory comment on the table 
      */
      System.out.println("\"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"TABLE_TYPE\",\"REMARKS\"");
      while(rs.next()) {
         System.out.print("\""+rs.getString("TABLE_CAT")+"\",");
         System.out.print("\""+rs.getString("TABLE_SCHEM")+"\",");
         System.out.print("\""+rs.getString("TABLE_NAME")+"\",");
         System.out.print("\""+rs.getString("TABLE_TYPE")+"\",");
         System.out.print("\""+rs.getString("REMARKS")+"\"");
         System.out.println();
         System.out.flush();
      }
      rs.close();
      System.out.println("[ENTER FOR MAIN MENU]");
      _readLine();
   }
   
   private void _onSetCurrentCatalog(Connection connection)
   throws SQLException {
      System.out.print("CATALOG NAME> ");
      System.out.flush();
      String catalog = _readLine();
      try {
         connection.setCatalog(catalog);
         System.out.println("Current catalog is now: " + catalog);
         System.out.println();
         System.out.println("[ENTER FOR MAIN MENU]");
         _readLine();
      }
      catch(SQLException sqle) {
         System.out.println("Error!");
         System.out.println(sqle.getMessage());
         System.out.flush();
         System.out.println();
         System.out.println("[ENTER FOR MAIN MENU]");
         _readLine();
      }
   }
   
   private void _onQuery(Connection connection)
   throws SQLException {
      Statement s = connection.createStatement();
      System.out.println("Please enter your query at the prompt and then ");
      System.out.println("type a \";\" followed by the enter key to execute.");
      System.out.println();
      System.out.print("QUERY> ");
      try {
         String query = _readCommand();
         _readLine();
         ResultSet rs = s.executeQuery(query);
         File tempFile = null;
         FileOutputStream fout = null;
         try {
            BufferedOutputStream bout = null;
            PrintWriter out = null;
            if(_tempDirectory != null) {
               tempFile = File.createTempFile("results_", ".csv", new File(_tempDirectory));
               fout = new FileOutputStream(tempFile);
               bout = new BufferedOutputStream(fout);
               out = new PrintWriter(bout);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            StringBuffer buffer = new StringBuffer();
            for(int i = 1; i <= rsmd.getColumnCount(); i++) {
               if(buffer.length() != 0)
                  buffer.append(",");
               buffer.append("\""+CSVEncoder.encode(rsmd.getColumnName(i))+"\"");
            }
            if(_tempDirectory != null) {
               out.println(buffer.toString());
               out.flush();
            }
            else {
               System.out.println(buffer.toString());
               System.out.flush();
            }
            String stemp;
            int itemp;
            double dtemp;
            while(rs.next()) {
               buffer = new StringBuffer();
               for(int i = 1; i <= rsmd.getColumnCount(); i++) {
                  if(buffer.length() != 0)
                     buffer.append(",");               
                  switch(rsmd.getColumnType(i)) {
                     case Types.VARCHAR:
                     stemp = rs.getString(i);
                     if(stemp == null)
                        stemp = "";
                     buffer.append("\""+CSVEncoder.encode(stemp)+"\"");
                     break;
                     
                     case Types.INTEGER:
                     itemp = rs.getInt(i);
                     if(rs.wasNull())
                        buffer.append("\"\"");
                     else
                        buffer.append("\""+itemp+"\"");
                     break;

                     case Types.REAL:
                     dtemp = rs.getDouble(i);
                     if(rs.wasNull()) 
                        buffer.append("\"\"");
                     else 
                        buffer.append("\""+dtemp+"\"");
                     break;
                  }
               }
               if(_tempDirectory != null) {
                  out.println(buffer.toString());
                  out.flush();
               }
               else {
                  System.out.println(buffer.toString());
                  System.out.flush();
               }
            }
            rs.close();
            if(_tempDirectory != null) {
               fout.close();
               fout = null;
            }
            System.out.println();
            System.out.println("[ENTER FOR MAIN MENU]");
            _readLine();
            if(_tempDirectory != null && tempFile != null)
               BrowserControl.displayURL("file://" + tempFile.getAbsolutePath());
         }
         catch(IOException ioe) {
            System.out.println("Local IO error!");
            System.out.println(ioe.getMessage());
            System.out.flush();
         }
         finally {
            if(fout != null) {
               try {
                  fout.close();
               }
               catch(IOException ioe) {
                  System.out.println("Unable to close temp file!");
                  System.out.println(ioe.getMessage());
                  System.out.flush();
               }
            }
         }
      }
      catch(SQLException sqle) {
         System.out.println("Query error!");
         System.out.println(sqle.getMessage());
         System.out.flush();
         System.out.println();
         System.out.println("[ENTER FOR MAIN MENU]");
         _readLine();
      }
      s.close();
   }
   
   private void _onUpdate(Connection connection)
   throws SQLException {
      Statement s = connection.createStatement();
      try {
         System.out.println("Please enter your update at the prompt and then ");
         System.out.println("type a \";\" followed by the enter key to execute.");
         System.out.println();
         System.out.print("UPDATE> ");
         String update = _readCommand();
         _readLine();
         int n = s.executeUpdate(update);
         System.out.println(n + " row(s) updated.");
         System.out.println();
         System.out.println("[ENTER FOR MAIN MENU]");
         _readLine();
      }
      catch(SQLException sqle) {
         System.out.println("Query error!");
         System.out.println(sqle.getMessage());
         System.out.flush();
         System.out.println();
         System.out.println("[ENTER FOR MAIN MENU]");
         _readLine();
      }
      s.close();
   }
   
   private boolean _processChoice(String choice, Connection connection)
   throws SQLException {
      if(choice.compareTo("1") == 0) 
         _onListCatalogs(connection);
      else if(choice.compareTo("2") == 0) 
         _onListTables(connection);
      else if(choice.compareTo("3") == 0) 
         _onSetCurrentCatalog(connection);
      else if(choice.compareTo("4") == 0)
         _onQuery(connection);
      else if(choice.compareTo("5") == 0)
         _onUpdate(connection);
      else if(choice.compareTo("6") == 0)
         _keepGoing = false;
      else
         return false;
      return true;
   }
   
   private void _menu() {
      System.out.println("Main Menu:");
      System.out.println("   1) List catalogs");
      System.out.println("   2) List tables");
      System.out.println("   3) Set current catalog");
      System.out.println("   4) Run a query");
      System.out.println("   5) Do an update");
      System.out.println("   6) Quit");
      System.out.println();
      System.out.print("YOUR CHOICE> ");
      System.out.flush();
   }
   
   public void run() {
      Connection connection = null;
      try {
         connection = DriverManager.getConnection(_url, _username, _password);
         connection.setAutoCommit(true);
         String choice;
         
         do {
            _menu();
            choice = _readLine();
            if(choice == null)
               return;
            try {
               if(!_processChoice(choice, connection)) {
                  System.out.println("Bad choice!");
                  System.out.flush();
               }
            }
            catch(SQLException sqle) {
               System.out.println("SQL-EXCEPTION!");
               sqle.printStackTrace(System.out);
               System.out.flush();
            }
         }
         while(_keepGoing);
      }
      catch(Throwable th) {
         th.printStackTrace();
      }
      finally {
         if(connection != null) { 
            try {
               connection.close();
            }
            catch(Throwable th2) {
               th2.printStackTrace();
            }
         }
      }
   }
   
   public static void main(String args[]) {
      String tempDir = null;
      if(args.length < 4 || args.length > 5) {
         System.err.println("Usage: com.mwc.sqld.tools.sqlcmd <jdbc-dirver-class> <url> <username> <password> [<temp-directory>]");
         System.exit(1);
      }
      if(args.length == 5)
         tempDir = args[4];
      try {
         Class.forName(args[0]).newInstance();
      }
      catch(Throwable th) {
         th.printStackTrace();
         System.exit(1);
      }
      Runnable cmdRunner = new sqlcmd(args[1], args[2], args[3], tempDir);
      cmdRunner.run();
   }
}