#ifndef _STATE_TOOLS_H
#define _STATE_TOOLS_H


/*

SAVE AND RELOAD PROGRAM STATE...

Author: Matthew W. Coan
Date: Sun Jul 30 21:55:09 EDT 2017

*/

#include <fstream> 
#include <iostream>
#include <cstdlib>
#include <unistd.h>

extern "C" {
extern char * stk_ptr;
extern size_t stk_size;
extern char * stk_alloc(size_t size);
extern void set_eax(size_t value);
extern size_t get_eax();
extern const char * program_name;
extern void * malloc(size_t size);
extern void free(void * ptr);
}

using namespace std;
char * ptr = 0;
char * end = 0;
fstream stream;
int word = 0;

#define SIZE 16

class Node {
public:
   void * ptr;
   size_t size;
   Node * next;
   Node() {
      ptr = 0;
      size = 0U;
      next = 0;
   }
};

Node * p_head = 0;
Node * node = 0;
size_t the_temp = 0U;
char * buffer = 0;

inline
void * __malloc(size_t size) 
{
   Node * n = (Node*)malloc(sizeof(Node));
   n->ptr = malloc(size);
   n->size = size;
   n->next = p_head;
   p_head = n;
}

inline
void __free(void * ptr)
{
   for(Node * n = p_head; n; n = n->next) {
      if(n->ptr == ptr) {
         free(ptr);
         break;
      }
   }
}

inline 
void * operator new(const size_t size) throw(bad_alloc)
{
   return __malloc(size);
}

inline 
void * operator new[](const size_t size) throw(bad_alloc)
{
   return __malloc(size);
}

inline 
void operator delete(void * ptr) throw(bad_alloc)
{
   __free(ptr);
}

inline 
void operator delete[](void * ptr) throw(bad_alloc)
{
   __free(ptr);
}

inline
char * get_stack_pointer() 
{
   __asm("movl %esp,%eax");
   __asm("addl $8,%eax");
   __asm("leave");
   __asm("ret");
   return 0;
}

#define state_init()\
   stk_ptr = get_stack_pointer()

#define state_save()\
   end = get_stack_pointer();\
   stream.open("state.dat", ios::ate | ios::binary | ios::out | ios::trunc);\
   if(stream) {\
      stk_size = (size_t)stk_ptr - (size_t)end;\
      stk_size -= 16;\
      stream.write(reinterpret_cast< char* >(&stk_size), sizeof(size_t));\
      stream.write(end, stk_size);\
      __asm("pushl $START_ADDRESS");\
      __asm("popl %eax");\
      word = get_eax();\
      printf("STK=%d\n", word);\
      stream.write((char*)&word, sizeof(size_t));\
      stream.flush();\
      stream.close();\
   }\
   __asm("START_ADDRESS:")

#define state_load()\
   stream.open("state.dat", ios::in | ios::binary);\
   stk_size = 0;\
   if(stream) {\
      stream.read(reinterpret_cast< char* >(&stk_size), sizeof(size_t));\
      set_eax((size_t)stk_ptr-stk_size);\
      __asm("movl %eax,%esp");\
      ptr = (char*)get_eax();\
      stream.read(ptr, stk_size);\
      stream.read((char*)&word, sizeof(size_t));\
      stream.close();\
      printf("STK=%d\n", word);\
      set_eax(word);\
      __asm("movl %eax,%ecx");\
      __asm("jmp *%ecx");\
   }

#endif
