// 
// THE SERVER:
// You must link in the ws2_32.lib library (MVC++ 6.0).
// Matthew W. Coan
//

#include "stdafx.h"
#include <winsock2.h>
#include <stdio.h>
#include <assert.h>

WSADATA stWSAData;  // WinSock DLL Info.

#define WSA_MAJOR_VERSION 1
#define WSA_MINOR_VERSION 1
#define WSA_VERSION MAKEWORD(WSA_MAJOR_VERSION, WSA_MINOR_VERSION)


//
// Echo lines of text back and forth between 
// the client and the server.  
//
void
Echo(SOCKET sock)
{
   const size_t BUFFER_SIZE = 1024;
   char buffer[BUFFER_SIZE];
   int n = 0;

   // Read a line of text form the client.
   memset(buffer, 0, BUFFER_SIZE);
   n = recv(sock, buffer, BUFFER_SIZE, 0);

   while(n > 0) {
      // Print the line on the consold.
      fprintf(stdout, "%s", buffer);
	   fflush(stdout);

	   // Send the line of text back to the client.
	   send(sock, buffer, n, 0);
      
	   // Read the next line of text from the client.
	   memset(buffer, 0, BUFFER_SIZE);
      n = recv(sock, buffer, BUFFER_SIZE, 0);
   }
}

//
// Main entry point.
//
int
main()
{
   sockaddr_in svr;         // Server socket addresss info.
   SOCKET svrSock, cliSock; // Server and client socket descriptors.
   int n;

   // Load the winsock DLL into our address space.
   WSAStartup(WSA_VERSION, &stWSAData); 

   // Create the server socket.
   svrSock = socket(AF_INET, SOCK_STREAM, 0); 

   // Check for an error.
   assert(svrSock >= 0);

   // Set all the server sockets address into to zero.
   memset(reinterpret_cast< char* >(&svr), 0, sizeof(svr));

   svr.sin_family = AF_INET;                 // Set the protocol family to TCP/IP.
   svr.sin_port = htons(8080);               // Set tbe port number the server will listen
                                             // for connections on.
   svr.sin_addr.s_addr = htonl(INADDR_ANY);  // Accept connections for all the addresses for
                                             // this machine.

   // Bind the server socket to the specified address.
   bind(svrSock, (LPSOCKADDR)&svr, sizeof(svr));
   
   // Check for an error.
   assert(svrSock != SOCKET_ERROR);

   // Let the socket API know that this is a listening socket
   // with a backlog specified socket API constant SOMAXCONN.
   n = listen(svrSock, SOMAXCONN);
   
   // Check for an error.
   assert(n >= 0);

   // Forever:
   while(true) {
      // Whate for a client to connect to the server.
      cliSock = accept(svrSock, (LPSOCKADDR)NULL, NULL);

	  // Check for an error.
      assert(cliSock > 0);

	  // Process the request.
      Echo(cliSock);
      
	  // Close the connection to the client.
	  closesocket(cliSock);
   }

   return 0;
}
