#ifndef _FILE_H
#define _FILE_H

#include <fstream>
#include <string>
#include <cstdlib>
#include <sys/stat.h>

namespace io_tools {

using namespace std;

class File {
   string _name;
   struct stat st;
   int rc;
public:
   File(const string & name) : _name(name) { rc = stat(_name.c_str(), &st); }
   File(const File & f) : _name(f._name) { rc = f.rc; st = f.st; }
   File() {
   }
   File & operator=(const File & right) {
      _name = right._name;
      st = right.st;
      rc = right.rc;
      return *this;
   }
   bool is_directory() {
      bool ret = false;
      if(st.st_mode & S_IFDIR) {
         ret = true;
      }
      return ret;
   }
   bool is_file() {
      bool ret = false;
      if(st.st_mode & S_IFREG) {
         ret = true;
      }
      return ret;
   }
   bool is_exe() {
      bool ret = false;
      if(st.st_mode & S_IXUSR || st.st_mode & S_IXGRP || st.st_mode & S_IXOTH) {
         ret = true;
      }
      return ret;
   }
   long length() {
      long off = -1L;
      ifstream fin(_name.c_str(), ios::in | ios::binary);
      if(fin) {
         fin.seekg(0L, ios::end);
         off = fin.tellg();
         fin.close();
      }
      return off;
   }
};

}

#endif /* _FILE_H */
