/*

SACAN A FILE FOR SECURITY HOLES...

Author: Matthew W. Coan
Date: Thu Jan 18 15:44:01 EST 2018

*/

#include <iostream>
#include <fstream>
#include <string>
#include <map>
#include <cstdlib>
#include <ctime>
#include <unistd.h>
#include <sys/stat.h>
#include <signal.h>

#include "md5.h"
#include "csv.h"
#include "str.h"
#include "shell.h"
#include "file.h"

#define ROOT_UID 0

using namespace std;
using namespace security_tools;
using namespace csv_reader;
using namespace shell_tools;
using namespace str_tools;
using namespace io_tools;

void
on_SIGCHLD(int)
{
}

void
on_SIGNAL(int)
{
   exit(1);
}

class FileScan {
public:
   typedef map< string, string > md5_map_type;
   typedef map< string, time_t > last_mod_map_type;

private:
   string file_name;
   md5_map_type md5_map;
	last_mod_map_type lm_map;

public:
   bool is_core() {
      bool ret = false;
      if(ends_with(file_name, ".core")) {
         cout << "core: " << file_name << endl;
         ret = true;
      }
      else if(ends_with(file_name, "/core")) {
         cout << "core: " << file_name << endl;
         ret = true;
      }
      return ret;
   }

   bool is_buffer_overflow() {
      bool ret = false;
      File file(file_name);
      if(file.is_exe() && !file.is_directory()) {
         if(System("strings \"" + shell_escape(file_name) + "\" > strings.txt") == 0) {
            ifstream fin("strings.txt");
            if(fin) {
               string token;
               while(fin >> token) {
                  if(token == "gets") {
                     cout << "bad libc calls: " << file_name << endl;
                     ret = true;
                     break;
                  }
               }
               fin.close();
	    }
         }
      }
      return ret;
   }

   bool is_exe(const string & file) {
      bool ret = false;
      struct stat st;
      if(stat(file.c_str(), &st) == 0) {
         if(st.st_mode & S_IXUSR
            || st.st_mode & S_IXOTH
            || st.st_mode & S_IXGRP) {
            ret = true;
         }
      }
      return ret;
   }

   bool is_root_writeable() {
      bool ret = false;
      struct stat st;
      if(stat(file_name.c_str(), &st) == 0) {
         if((st.st_uid == ROOT_UID)
            && (st.st_mode & S_IWOTH) 
            && (st.st_mode & S_IFREG) 
            && (st.st_mode & S_IXUSR)) {
            ret = true;
            cout << "root writeable: " << file_name << endl;
         }
      }
      return ret;
   }

   bool is_shell_script() {
      string str;
      bool ret = false;
      ifstream fin(file_name.c_str());
      char ch;
      if(fin) {
         if(fin.peek() == '#') { 
            while(fin) {
               ch = fin.get(); 
               if(ch == '\n') {
                  break;
               }
               if(fin)
                  str += ch; 
            }
            cout << "shell: " << str << endl;
            if(ends_with(str, "/sh")) {
               ret = true;
            }
            else if(ends_with(str, "/bash")) {
               ret = true;
            }
            else if(ends_with(str, "/csh")) {
               ret = true;
            }
            else if(ends_with(str, "/ksh")) {
               ret = true;
            }
         }
         fin.close();
      }
      return ret;
   }

   string get_data() {
      char ch;
      string ret;
      ifstream fin(file_name.c_str());
      if(fin) {
         ch = fin.get();
         while(fin) {
            ret += ch;
            ch = fin.get();
         }
         fin.close();
      }
      return ret;
   }

   string get_php(const string & d) { 
      string ret,data=d;
      string::size_type index1 = data.find("<?php");
      string::size_type index2 = data.find("?>");
      while(index1 != string::npos && index2 != string::npos) {
         if(ret.size())
            ret += " ";
         ret += data.substr(index1, index2-index1);
         data = data.substr(index2+2);
         index1 = data.find("<?php");
         index2 = data.find("?>");
      } 
      index1 = data.find("<?=");
      index2 = data.find("?>");
      while(index1 != string::npos && index2 != string::npos) {
         if(ret.size())
            ret += " ";
         ret += data.substr(index1, index2-index1);
         data = data.substr(index2+2);
         index1 = data.find("<?=");
         index2 = data.find("?>");
      }
      return ret;
   }

	bool is_bad_php_file() {
		bool ret = false;
	   string php = get_php(get_data());
      string::size_type index;
      if(php.find("`") != string::npos) {
         ret = true;
         cout << "shell code in php: " << file_name << endl;
      }
      else if((index = php.find("system")) != string::npos) {
         bool flag = false;
         if(index > 0) {
            if(isalnum(php[index-1]) || php[index-1] != '_') {

            }
            else {
               flag = true;
            }
         }
         string temp = php.substr(index + 6);
         while(isspace(temp[index])) {
            index++;
            if(index >= temp.size()) {
               break;
            }
         }
         if(index < temp.size()) {
            if(temp[index] == '(') {
               if(flag) {
                  cout << "shell code in PHP: " << file_name << endl;
                  ret = true;
               }
            }
         }
      }
		return ret;
	}

   bool is_bad_file(const string & data) {
      bool ret = false;
      if(data.find("shell script") != string::npos 
         && ends_with(file_name, ".cgi")) {
         cout << "shell script CGI: " << file_name << endl;
         ret = true;
      }
      else if(ends_with(file_name, "/cgi-bin/php")) {
         cout << "PHP back door: " << file_name << endl;
         ret = true;
      }
      else if(ends_with(file_name, "/cgi-bin/php.cgi")) {
         cout << "PHP back door: " << file_name << endl;
         ret = true;
      }
      else if(data.find("PHP") != string::npos) {
			if(is_bad_php_file()) {
            ret = true;
         }
      }
      else if(data.find("HTML") != string::npos) {
      }
      return ret;
   }

   bool is_bad_file() {
      bool ret = false;
      if(System("file \"" + shell_escape(file_name) + "\" > file.txt") == 0) {
         ifstream fin("file.txt");
         if(fin) { 
            string data;
            char ch;
            while(fin) {
               ch = fin.get();
               if(ch == '\n') 
                  break;
               if(fin) {
                  data += ch;
               }
            }
            fin.close();
            if(is_bad_file(data)) {
               ret = true;
            }
         }
      }
      return ret;
   }

   bool is_change() {
      bool ret = false;
		struct stat st;
		stat(file_name.c_str(), &st);
		if(st.st_mtime == lm_map[file_name]) {

		}
		else {
         string code;
         compute_md5(file_name, code);
         md5_map_type::iterator ptr = md5_map.find(file_name);
         if(ptr != md5_map.end()) {
            if(ptr->second != code) {
               cout << "file change: " << file_name << endl;
               ret = true; 
            }
         }
         else {
            md5_map[file_name] = code;
			   lm_map[file_name] = st.st_mtime;
         }
		}
      return ret;
   }

   FileScan(const string & fn) : file_name(fn) { load(); }
   ~FileScan() { save(); }

   int run() {
      int rc = 0;
		if(is_core()) {
         rc = 1;
      }
		else if(is_buffer_overflow()) {
         rc = 1;
      }
		else if(is_root_writeable()) {
         rc = 1;
      }
		else if(is_bad_file()) {
         rc = 1;
      }
		else if(is_change()) {
         rc = 1;
      }
      return rc;
   }

   void save() {
      ofstream out("md5_file.csv", ios::out | ios::ate);
      if(out) {
			struct stat st;
         for(md5_map_type::iterator ptr = md5_map.begin(); 
             ptr != md5_map.end(); ptr++) {
				stat(ptr->first.c_str(), &st);
            out << "\"" << ptr->first << "\",\"" << ptr->second << "\",\"" << st.st_mtime << "\"" << endl;
         }
         out.close();
      }
   }
  
   void load() {
      csv_row_type row;
      ifstream fin("md5_file.csv", ios::in);
      if(fin) {
         while(fin >> row) {
            md5_map[row[0]] = row[1];
            lm_map[row[0]] = atol(row[2].c_str());
         }
         fin.close();
      }
   }
};

int
main(int argc, char ** argv)
{
   if(argc != 2) {
      cerr << "usage: " << argv[0] << " <file-to-security-scan>" << endl;
      exit(0);
   }

   signal(SIGCHLD, on_SIGCHLD);
   signal(SIGINT, on_SIGNAL);
   signal(SIGTERM, on_SIGNAL);
   signal(SIGHUP, on_SIGNAL);

   FileScan scan(argv[1]);

   int rc = scan.run();

   return rc;
}
