#ifndef _SHELL_H
#define _SHELL_H

#include <string>
#include <cstdlib>

namespace shell_tools {

using namespace std;

inline
int System(const string & cmd) 
{
   int rc = system(cmd.c_str());
   return rc;
}

class shell_stream {
   FILE * cmd;
public:
   shell_stream(const string & program) {
      cmd = popen(program.c_str(), "r");
   }

   shell_stream & operator<<(const string & str) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%s", str.c_str());
      return *this;
   }

   shell_stream & operator<<(const char val) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%c", val);
      return *this;
   }

   shell_stream & operator<<(const int val) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%d", val);
      return *this;
   }

   shell_stream & operator<<(const float val) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%f", val);
      return *this;
   }

   shell_stream & operator<<(const double val) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%lf", val);
      return *this;
   }

   shell_stream & operator<<(const long val) {
      if(cmd == 0) return *this;
      fprintf(cmd, "%ld", val);
      return *this;
   }

   char get() {
      if(cmd == 0) 
         return 0; 
      return fgetc(cmd);
   }

   shell_stream & operator>>(string & str) {
      if(cmd == 0) return *this;
      char ch;
      str = "";
      while((ch = fgetc(cmd)) != -1) {
         if(isspace(ch) && str.size()) {
            ungetc(ch, cmd);
            break;
         }
         str += ch;
      }
      return *this;
   }

   shell_stream & operator>>(char & val) {
      if(cmd == 0) return *this;
      fscanf(cmd, "%c", &val);
      return *this;
   }

   shell_stream & operator>>(int & val) {
      if(cmd == 0) return *this;
      fscanf(cmd, "%d", &val);
      return *this;
   }

   shell_stream & operator>>(float & val) {
      if(cmd == 0) return *this;
      fscanf(cmd, "%f", &val);
      return *this;
   }

   shell_stream & operator>>(double & val) {
      if(cmd == 0) return *this;
      fscanf(cmd, "%lf", &val);
      return *this;
   }

   shell_stream & operator>>(long & val) {
      if(cmd == 0) return *this;
      fscanf(cmd, "%ld", &val);
      return *this;
   }

   operator void* () {
      if(cmd == 0) return 0;
      long ret = feof(cmd);
      return (void*)(!ret);
   }
};


}

#endif /* _SHELL_H */
