#ifndef _STR_H
#define _STR_H

#include <string>
#include <sstream>
#include <cctype>

namespace str_tools {

using namespace std;

inline
string replace(const string & buffer, const string & str, const string & rep)
{
   string ret = buffer;
   string::size_type p;

   while((p=ret.find(str)) != string::npos) {
      ret = ret.substr(0, p) + rep + ret.substr(p+str.size());
   }

   return ret;
}


template< class T >
inline
string to_string(const T & t)
{
   stringstream ss;
   ss << t;
   string temp;
   ss >> temp;
   return temp;
}

inline
bool ends_with(const string & str, const string & end) {
   bool ret = false;
   string::size_type ptr = str.rfind(end);
   if(ptr != string::npos) {
      string temp = str.substr(ptr);
      if(temp == end) {
         ret = true;
      }
   }
   return ret;
}

inline
bool starts_with(const string & str, const string & end) {
   bool ret = false;
   if(str.find(end) == 0) {
      ret = true;
   }
   return ret;
}

inline
string trim(const string & str)
{
   string ret;
	string::size_type index = 0;
	while(index < str.size()) {
		if(isspace(str[index])) {
			index++;
			continue;
	   }
		else
			break;
	}
	ret = str.substr(index);
	if(ret.size()) {
		index = ret.size()-1;
		string::size_type size = ret.size();
		while(size > 0) {
			if(isspace(ret[index])) {
				size--;
				if(index)
					index--;
				else
					break;
				continue;
			}
			else {
				break;
			}
		}
		ret = ret.substr(0, size);
	}
   return ret;
}

template< class T >
inline
string to_hex(const T & val)
{
   stringstream s;
   s << hex << val;
   string ret;
   s >> ret;
   return ret;
}

inline
string url_escape(const string & str)
{
   string ret;
   stringstream s;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == ' ') 
         s <<  "+";
      else
         s << "%" << hex << str[i];
   }
   return ret;
}

inline
string strip_html(const string & html) {
   string ret;
   bool in = false;
   for(size_t i = 0; i < html.size(); i++) {
      if(html[i] == '<') 
         in = true;
      else if(html[i] == '>') {
         in = false;
         ret += ' ';
         continue;
      }
      if(!in) {
         ret += html[i];
      }
   }
   return ret;
}

inline
string to_lower(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
     ret += tolower(str[i]);
   }
   return ret;
}

inline
string csv_escape(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\"') {
         ret += "\"\"";
      }
      else {
         ret += str[i];
      }
   }
   return ret;
}

inline
string shell_escape(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\"') {
         ret += "\\\"";
      }
      else if(str[i] == '\r') {
         ret += "\\r";
      }
      else if(str[i] == '\n') {
         ret += "\\n";
      }
      else if(str[i] == '$') {
         ret += "\\$";
      }
      else {
         ret += str[i];
      }
   }
   return ret;
}

inline
string clean_text(const string & str) {
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(ispunct(str[i]) || isalnum(str[i]) || isspace(str[i])) {
         ret += str[i];
      }
   }
   return ret;
}

}


#endif /* _STR_H */
