/*
    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

System scan program...

Author: Matthew W. Coan
Date: Wed Jun 16 20:47:09 EDT 2010

*/

//#define DEBUG_SYSTEM_SCAN

#include <iostream>
#include <fstream>
#include <string>

#include <cstdlib>

#include <sys/types.h>
#include <sys/wait.h>

#include <unistd.h>
#include <signal.h>

#include "str.h"
#include "shell.h"

using namespace std;
using namespace shell_tools;
using namespace str_tools;

const char VERSION[] = "1.0.0";

void
on_SIGCHLD(int)
{
}

void
on_SIGNAL(int)
{
   exit(1);
}

string
clean_dir(const string & str)
{
   string ret;

   for(size_t i = 0; i < str.size(); i++) {
      if(i != str.size()-1 && str[i] != ':') {
         ret += str[i];
      }
   }

   return ret;
}

class SystemScan {
public:

   bool read_line(istream & in, string & str) {
	   bool ret = false;
	   char ch;
	   ch = in.get();
	   str = "";
	   while(in) {
		   if(ch == '\n') {
			break;
		   }
		   str += ch;
		   ret = true;
		   ch = in.get();
	   }
	   return ret;
   }
int
run(int argc, 
    char ** argv,
    char ** envp)
{
   int ret = 0;
   int status, pid;

   signal(SIGCHLD, on_SIGCHLD);
   signal(SIGINT, on_SIGNAL);
   signal(SIGTERM, on_SIGNAL);
   signal(SIGHUP, on_SIGNAL);

	cout << "System Scan..." << endl;
	cout << "Version: " << VERSION << endl;
	cout << "Author: Matthew W. Coan (matthewcoan1976@hotmail.com)" << endl;
	cout << "Compilation date: " << __DATE__ << " " << __TIME__ << endl << endl;

   for(int i = 0; i < argc; i++) {
      if(strcmp(argv[i], "-init") == 0) {
		   string password = getpass("password: ");
			System("echo -n \"\" > md5_file.csv");
         System("zip -P \"" +password+ "\" md5_file.zip md5_file.csv > /dev/zero");
			exit(0);
      }
   }

   if(argc != 3) {
      cerr << "usage: " << argv[0] << " -init | <start-directory> <scan-file-command>" << endl;
      ret = 1;
   }
   else {
	   unlink("md5_file.csv");
		string password = getpass("password: ");
	   if(System("7z -p"+password+" e md5_file.zip > /dev/zero") == 0) {
		   if(System("ls -1R \"" + shell_escape(argv[1]) + "\" > ls.txt") == 0) {
            ifstream fin("./ls.txt");

            if(fin) {
               unlink("./filelist.txt");

               ofstream fout("./filelist.txt", ios::ate);
 
               if(fout) {
                  string dir, file, cmd;

                  read_line(fin, dir);

                  if(dir.find(":") != string::npos)
                     dir = clean_dir(dir);
                  else
                     dir = argv[1];

                  while(fin) {
                     read_line(fin, file);

                     while(fin) { 
                        if(file == "") {
                           break; 
                        }

                        if(file.size()) {
                           if(file[file.size()-1] == ':') {
                              break;
                           }
                        }

                        if((pid = fork()) == 0) {
                           string temp = dir + "/" + file;
                           const char * argv2[] = { argv[2], temp.c_str(), 0 };
                           execv(argv[2], (char * const *)argv2);
                        }

		                  if(pid > 0) {
		                     //waitpid(pid, &status, WNOHANG|WUNTRACED);
                           status = 0;
		                     waitpid(pid, &status, 0);
		                  }
                        else {
                           cerr << "error: unable to fork()..." << endl;
                           fin.close();
                           continue;
                        }

                        read_line(fin, file);

                        if(file == "") {
                           break;
                        }
                     }

                     dir = file;

                     file = "";

                     dir = clean_dir(dir);
                  }

                  fout.close();
               }

              fin.close();
		      }
         }

	      System("zip -P \"" +password+ "\" md5_file.zip md5_file.csv > /dev/zero");
	      unlink("md5_file.csv");
		}
   }

   return ret;
}
};

int
main(int argc,
     char ** argv,
     char ** envp)
{
   SystemScan system_scan;
   int rc = system_scan.run(argc, argv, envp);
   return rc;
}
