#ifndef __BTREE2_H
#define __BTREE2_H

#include <iostream>
#include <string>
#include <sys/types.h>
#include <limits.h>
#include <db.h>
#include <fcntl.h>
#include <sys/stat.h>


namespace db_tools {

using namespace std;

class btree;

struct btree_exception { };

class btree_assign {
   btree * tree;
   string key;

public:
   btree_assign(btree * tree, const string & k) {
      this->key = k;
      this->tree = tree;
   }

   btree_assign & operator=(const int arg);

   operator int();
};

class btree {
   DB * db;
   string file_name;

public:
   btree(const string & name) {
      file_name = name;
      db = dbopen(file_name.c_str(), O_RDWR | O_CREAT | O_EXCL, S_IWRITE | S_IREAD, DB_BTREE, NULL);
      if(db == NULL) {
         db = dbopen(file_name.c_str(), O_RDWR | O_EXCL, S_IWRITE | S_IREAD, DB_BTREE, NULL);
      }
      if(db == NULL) {
         throw btree_exception();
      }
   }

   ~btree() {
      db->close(db);
   }

   void put(string str, int i) {
      DBT key, data;
      key.data = (char*)str.c_str();
      key.size = str.size()+1;
      data.data = (char*)&i;
      data.size = sizeof(int);
      db->put(db, &key, &data, 0);
      db->sync(db, 0);
   }

   bool get(const string & k, int & d) {
      DBT key, data;
      key.data = (char*)k.c_str();
      key.size = k.size()+1;
      data.data = (char*)&key;
      data.size = sizeof(int);
      int rc = db->get(db, &key, &data, 0);
      bool ret = false;
      if(rc == 0) {
         d = *(int*)data.data;
         ret = true;
      }
      else {
         ret = false;
      } 
      return ret;
   }

   btree_assign  operator[](const string & key) {
      return btree_assign(this, key);
   }
};


btree_assign & btree_assign::operator=(const int arg) {
   tree->put(key, arg);
   return *this;
}

btree_assign::operator int() {
   int data;
   if(!tree->get(key, data)) {
      data = 0;
   }
   return data;
}

}


#endif /* __BTREE2_H */
