#ifndef _D_ALLOC_H
#define _D_ALLOC_H

#include "bfstream.h"
#include "d_common.h"

namespace db_tools {

using namespace std;

class d_alloc_node {
public:
   offset_type size;
   offset_type address;
   offset_type next;
   bool is_free;

   d_alloc_node() {
      size = -1LL;
      address = -1LL;
      next = -1LL;
      is_free = true;
   }

   d_alloc_node(const offset_type & size,
                const offset_type & address,
                const offset_type & next,
                const bool is_free) {
      this->size = size;
      this->address = address;
      this->is_free = is_free;
      this->next = next;
   }

   void write(bfstream & fout) {
      fout.write((char*)&size, sizeof(offset_type));
      fout.write((char*)&address, sizeof(offset_type));
      fout.write((char*)&next, sizeof(offset_type));
      fout.write((char*)&is_free, sizeof(bool));
      fout.flush();
   }

   void read(bfstream & fin) {
      fin.read((char*)&size, sizeof(offset_type));
      fin.read((char*)&address, sizeof(offset_type));
      fin.read((char*)&next, sizeof(offset_type));
      fin.read((char*)&is_free, sizeof(bool));
      fin.clear();
   }
};

class d_alloc {
   bfstream * fptr;
   offset_type head;

   void append(offset_type & address, 
               const offset_type & size) {
      fptr->seekg(0UL, ios::end);
      address = fptr->tellg();
      char ch = '\0';
      for(offset_type i = 0; i < size; i++) {
         fptr->write((char*)&ch, sizeof(char));
      }
      d_alloc_node n(size, address, head, false);
      fptr->seekg(0UL, ios::end);
      offset_type a = fptr->tellg();
      d_alloc_node n2;
      if(head == -1L) {
         n.next = head;
         n.write(*fptr);
         head = a;
         fptr->seekg(0UL, ios::beg);
         fptr->write((char*)&head, sizeof(offset_type));
      }
      else {
         d_alloc_node n2,n3;
         offset_type addr = head;
         offset_type addr2 = head;
         offset_type addr3 = -1L;
         fptr->seek_current(addr);
         n2.read(*fptr);
         while(n2.next != -1L) {
            if(n2.size >= size) {
               fptr->seekg(0L, ios::end);
               addr3 = fptr->tellg();
               fptr->seek_current(addr2);
               n3.read(*fptr);
               n3.next = addr3;
               fptr->seek_current(addr3);
               n3.write(*fptr);
               n.next = address; 
               fptr->seek_current(addr);
               n.write(*fptr);
               break;
            }
            addr2 = addr;
            addr = n2.next;
            fptr->seekg(addr, ios::beg);
            n2.read(*fptr);
         }
      }
   }

public:
   d_alloc(bfstream & file) {
      fptr = &file;
      fptr->seekg(0UL, ios::beg);
      fptr->read((char*)&head, sizeof(offset_type));
      if(!*fptr) {
         fptr->clear();
         fptr->seekg(0UL, ios::beg);
         head = -1LL;
         fptr->write((char*)&head, sizeof(offset_type));
         fptr->flush();
      }
   }

   ~d_alloc() {

   }

   offset_type allocate(const offset_type & size) {
      offset_type address;
      if(head == -1) {
         append(address, size);
      }
      else {
         bool found = false;
         offset_type a = head;
         d_alloc_node n;
         do {
            fptr->seek_current(a);
            n.read(*fptr);
            if(n.is_free && n.size >= size) {
               n.is_free = false;
               address = n.address;
               if(n.size > size)
                  n.size -= size;
               fptr->seek_current(a);
               n.write(*fptr);
               found = true;
               if(n.size > size) {
                  offset_type ptr = a + size;
                  offset_type sz = n.size - size;
                  append(ptr, sz);
               }
               break; 
            }
            a = n.next;
         }
         while(a != -1LL);

         if(!found) {
            append(address, size);
         }
      }
      return address;
   }

   void deallocate(const offset_type & ptr) {
      d_alloc_node n;
      offset_type a = head;
      do {
         fptr->seek_current(a);
         n.read(*fptr);
         if(n.address == ptr) {
            n.is_free = true;
            fptr->seek_current(a);
            n.write(*fptr);
            break;
         }
         a = n.next;
      }
      while(a != -1LL);
   }
};

}

#endif /* _D_ALLOC_H */
