#ifndef _D_DB_H
#define _D_DB_H

#include "bfstream.h"
#include <iostream>
#include <string>
#include "d_alloc.h"

namespace db_tools {

using namespace std;

struct io_exception { };

class d_database {
   string file_name;
   bfstream stream;
   d_alloc * allocator;

public:
   d_database(const string & file_name) {
      this->file_name = file_name;

      stream.open(file_name.c_str(), ios::in | ios::out | ios::binary | ios::ate);
       
      if(!stream) {
         cerr << "unable to open file: " << file_name << endl;
         throw io_exception();
      }

      allocator = new d_alloc(stream);
   }

   d_alloc * get_allocator() {
      return allocator;
   }

   ~d_database() {
      if(stream) stream.close();
      delete allocator;
   }

   const string & name() const { return file_name; } 

   template< class T >
   void add_object(const string & key, const T & obj) {

   }

   void remove_object(const string & key) {

   }

   template< class T >
   void get_object(const string & key, const T & obj) {

   }

   operator void*() {
      return (void*)stream;
   }

   bfstream & get_stream() { return stream; }

   offset_type allocate(const offset_type & off) {
      stream.seekg(sizeof(offset_type), ios::end);
      offset_type ret = stream.tellg();

      char ch = '\0';
      for(offset_type i = 0; i < off; i++) 
          stream.write((char*)&ch, sizeof(char));
      stream.flush();

/*
      offset_type ret = stream.tellg();
      offset_type temp;
      temp = 0L;
      stream.write((char*)&temp, sizeof(offset_type));
      temp = -1L;
      stream.write((char*)&temp, sizeof(offset_type)); 
      stream.write((char*)&temp, sizeof(offset_type)); 
      temp = 0L;
      stream.write((char*)&temp, sizeof(offset_type));
      temp = -1L;
      stream.write((char*)&temp, sizeof(offset_type)); 
      stream.write((char*)&temp, sizeof(offset_type)); 
      stream.flush();
*/
      return ret;
   }
};

}

#endif /* _D_DB_H */
