#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>
#include <sys/types.h>
#include <signal.h>

using namespace std;

string
read_line(istream & in)
{
   string ret;
   char ch;
   ch = in.get();
   while(ch != '\n') {
      ret += ch;
      ch = in.get();
   }
   return ret;
}

int
System(const string & cmd) 
{
   cout << cmd << endl;
   return system(cmd.c_str());
}

void
on_signal(int sig)
{
   switch(sig) {
   case SIGHUP:
   case SIGINT:
   case SIGTERM:
   exit(0);
   break;

   case SIGCHLD:
   break;
   }
}


int 
main(int argc, char ** argv)
{
   if(argc != 3) {
      cerr << "usage: killall <signal> <program>" << endl;
      exit(1);
   }
   signal(SIGHUP, on_signal);
   signal(SIGINT, on_signal);
   signal(SIGTERM, on_signal);
   signal(SIGCHLD, on_signal);
   string pid;
   string prog = argv[2];
   string sig = argv[1];
   System("ps | grep " + prog + " > kill.txt");
   ifstream in("kill.txt", ios::in);
   if(in) { 
      while(in >> pid) {
         read_line(in);
         System("/bin/kill " + sig + " " + pid);
      }
      in.close();
   }
   return 0;
}
