#include <iostream>
#include "bfstream.h"

#include "d_alloc.h"
#include "d_db.h"
#include "d_list.h"

using namespace db_tools;
using namespace std;

d_database * db_tools::p_db = 0;

typedef offset_type (*int_size_type)(const int & i);

offset_type int_size(const int & i) {
   return sizeof(int);
}

typedef d_list< int, int_size_type > int_list_type;

typedef offset_type (*int_list_size_type)(const int_list_type & il);

offset_type int_list_size(const int_list_type & il) {
   return sizeof(offset_type) * 3;
}

typedef d_list< int_list_type, int_list_size_type > int_list_list_type;

int
main(int argc, char ** argv)
{
   int rc = 0;

   if(argc != 2) {
      ofstream fout("./data2.dat", ios::out | ios::trunc | ios::ate);
      fout.close();
   }

   d_database db("./data2.dat");

   p_db = &db;

   if(argc != 2) {
      db.allocate(sizeof(offset_type)
                  + sizeof(offset_type)
                  + sizeof(offset_type)
                  + sizeof(offset_type)
                  + sizeof(offset_type)
                  + sizeof(offset_type)
                  + sizeof(offset_type));
   }

   int_list_type temp_list(db, sizeof(offset_type), int_size);

   int_list_list_type list1(db, (sizeof(offset_type)*3)+sizeof(offset_type), int_list_size);

   cout << "---PUSH---" << endl;

   temp_list.push_back(123);
   temp_list.push_back(124);
   temp_list.push_back(125);

cout << "temp_list.size() == " << temp_list.size() << endl;

   list1.push_back(temp_list);

   temp_list.push_back(126);
   list1.push_back(temp_list);

cout << "list1.size() == " << list1.size() << endl;

   cout << "---ITERATE---" << endl;

   for(int_list_list_type::iterator p = list1.begin(); p != list1.end(); p++) {
cout << "LIST..." << endl;
      for(int_list_type::iterator p0 = p->begin(); p0 != p->end(); p0++) {
         cout << (*p0) << endl;
      }
   }

/*

   temp_list.clear();

   temp_list.push_back(4);
   temp_list.push_back(5);
   temp_list.push_back(6);
   
   list1.push_back(temp_list);

   temp_list.clear();

   temp_list.push_back(7);
   temp_list.push_back(8);
   temp_list.push_back(9);

   list1.push_back(temp_list);

   temp_list.clear();

   cout << "---INTEGER LISTING---" << endl;
   for(int_list_list_type::iterator p = list1.begin(); p != list1.end(); p++) {
      for(int_list_type::iterator p0 = p->begin(); p0 != p->end(); p0++) {
         cout << (*p0) << endl;
      }
   }
*/
   cout << "---DONE---" << endl;

   return rc;
}
