#include "title-bot.h"

using namespace title_bot;

d_database * db_tools::p_db = 0;

int   
main(int argc, char ** argv, char ** envp)
{
   int rc = 0;
   bool init = false;

   if(argc != 2 && argc != 3) {
      cerr << "usage: " << argv[0] << " <URL> [ -init ]" << endl;
      exit(1);
   }     

   for(int i = 0; i < argc; i++) {
      if(strcmp(argv[i], "-init") == 0)  {
         init = true;
         break;
      }
   }

   try { 
      Robot robot(argv[1], init);

      robot.run();
   }     
   catch(io_exception) {
      cerr << "io_exception..." << endl;
      exit(1);
   }     
   catch(btree_exception) {
      cerr << "btree_exception..." << endl;
      exit(1);
   }     
   catch(...) {
      cerr << "exception..." << endl;
      exit(1);
   }

   return rc;
}

