#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <cctype>
#include <cstdlib>
#include "cgi.h"

using namespace std;

char api_key[1024];
const char * TRANSLATE_HTML = "/home/mcoan/public_html/translate2.html";
const char * TRANSLATION_TXT = "/home/mcoan/public_html/cgi-bin/translation.txt";
const char * CGI_URL = "/~mcoan/cgi-bin/translate.cgi";
const char * API_KEY_TXT = "/home/mcoan/api_key.txt";
const char * WGET_CMD = "/usr/local/bin/wget";

int
System(const string & cmd) 
{
   return system(cmd.c_str());
}

string
escape(const string & str)
{
	string ret;

	for(size_t i = 0; i < str.size(); i++) {
		switch(str[i]) {
			case '&':
			ret += "%26";
			break;

			case '=':
			ret += "%3D";
			break;

			case '\"':
			ret += "%22";
			break;

			case '\'':
			ret += "%27";
			break;

			case '\\':
			ret += "%5C";
			break;

			case '(':
			ret += "%28";
			break;

			case ')':
			ret += "%29";
			break;

			case '{':
			ret += "%7B";
			break;

			case '}':
			ret += "%7D";
			break;

			case '[':
			ret += "%5B";
			break;

			case ']':
			ret += "%5D";
			break;

			case '+':
			ret += "%2B";
			break;

			case ':':
			ret += "%3A";
			break;

			case ';':
			ret += "%3B";
			break;

			case '<':
			ret += "%3C";
			break;

			case '>':
			ret += "%3E";
			break;

			case ',':
			ret += "%2C";
			break;

			case '?':
			ret += "%3F";
			break;

			case '/':
			ret += "%2F";
			break;

			case '|':
			ret += "%7C";
			break;

			case '^':
			ret += "%5E";
			break;

			case '%':
			ret += "%25";
			break;

			case '$':
			ret += "%24";
			break;

			case '#':
			ret += "%23";
			break;

			case '!':
			ret += "%21";
			break;

			case '~':
			ret += "%7E";
			break;

			case '`':
			ret += "%60";
			break;

			case ' ':
			case '\r':
			case '\n':
			ret += "+";
			break;

			default:
			ret += str[i];
		}
	}

	return ret;
}

string get_data(const string & data);

string translate(const string & text, 
                 const string & in_lang, 
                 const string & out_lang)
{
   string ret;
   if(System(string(WGET_CMD) + " -q -O " + string(TRANSLATION_TXT) 
             + " \"https://www.googleapis.com/language/translate/v2?key="
             + string(api_key) + "&q=" + escape(text) + "&source=" + in_lang
             + "&target=" + out_lang + "\"") == 0) {
      ifstream fin(TRANSLATION_TXT);
      if(fin) {
         char ch;
         ch = fin.get();
         while(fin) {
            ret += ch;
            ch = fin.get();
         }
         fin.close();
         ret = get_data(ret);
      }
   }
   return ret;
}

string 
get_data(const string & data)
{
   string ret;
   string::size_type ptr = data.find("\"translatedText\": ");
   if(ptr != string::npos) {
      ret = data.substr(ptr+17);
      ptr = ret.find("\"");
      if(ptr != string::npos) {
         ret = ret.substr(ptr+1, ret.size()-ptr-1);
         ptr = ret.find("\"");
         if(ptr != string::npos) {
            ret = ret.substr(0, ptr);
         }
      }
   }
   return ret;
}

string
set_language(const string & data, const string & lang, const string & text, bool first)
{
   string ret;
   string value = "value=\"" + lang + "\"";
   string::size_type index = data.find(value);
   if(first == false && index != string::npos) {
      index = data.find(value, index + 1);
   }
   if(index != string::npos) {
      ret = data.substr(0, index) + " selected=\"1\" " + data.substr(index);
   }
   index = ret.find("#text#");
   if(index != string::npos) {
      ret = ret.substr(0, index) + text + ret.substr(index+6);
   }
   return ret;
}

void
read_api_key() throw(const char *)
{
   ifstream fin(API_KEY_TXT);
   if(fin) {
      string temp;
      fin >> temp;
      if(temp.size() < 1024)
         strcpy(api_key, temp.c_str());
      fin.close();
   }
   else {
      throw "Unable to open the file with the api key...";
   }
}

void
output_file(const char * file, 
            const string & in_lang, 
            const string & out_lang, 
            const string & text) throw(const char *)
{
   ifstream fin(file);
   if(fin) {
      char ch;
      string temp;
      ch = fin.get();
      while(fin) {
         temp += ch;
         ch = fin.get();
      }
      fin.close();
      temp = set_language(temp, in_lang, text, true);
      temp = set_language(temp, out_lang, text, false);
      cout << temp << flush;
   }
   else {
      throw "Unable to open the fillout form flle...";
   }
}

int
main(int argc, char ** argv)
{
   try {
      bool running  = true;
      const char * in_lang = "en";
      const char * out_lang = "fr";
      const char * text;
      cgi< > form_data;
      in_lang = form_data["in_lang"];
      if(in_lang == 0) 
         in_lang = "en";
      out_lang = form_data["out_lang"];
      if(out_lang == 0)
         out_lang = "es";
      read_api_key();
      text = form_data["text"];
      if(text == 0)
         text = "";
      cout << "Content-language: " << out_lang << "\r\n" << flush;
      cout << "Content-type: text/html\r\n\r\n" << flush;
      string translation = translate(text, in_lang, out_lang);
      cout << "<HTML>" << endl;
      cout << "<HEAD>" << endl;
      cout << "<TITLE>Translation Tool</TITLE>" << endl;
      cout << "<META http-equiv=\"Content-Language\" content=\"" << out_lang << "\" />" << endl;
      cout << "<META CHARSET=\"utf-8\">" << endl;
      cout << "</HEAD>" << endl;
      cout << "<BODY BGCOLOR=\"WHITE\">" << endl;
      cout << "<H1>Translation:</H1>" << endl;
      cout << "<H1>" << endl;
      cout << translation << endl;
      cout << "</H1>" << endl;
      cout << "<HR ALLCLEAR>" << endl;
      output_file(TRANSLATE_HTML, in_lang, out_lang, text);
      cout << "</BODY>" << endl;
      cout << "</HTML>" << endl;
   }
   catch(const char * message) {
      cout << "Content-type: text/html\r\n\r\n" << flush;
      cout << "<HTML>" << endl
           << "<HEAD>" << endl
           << "</HEAD>" << endl
           << "<BODY BGCOLOR=\"WHTIE\">" << endl
           << "<H1>" << message << "</H1>" << endl
           << "</BODY>" << endl
           << "</HTML>" << endl;
      exit(0);
   }
   return 0;
}
