/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.security.util.SecurityConstants;

public class SecurityManagerHelper {
    private static final String PRINT_DIALOG_KEY = "sun.plugin.security.printDialog";
    private static final ThreadLocal inThreadGroupCheck = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    static void resetHelper(final HashSet hashSet) {
        hashSet.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    hashSet.add(string3);
                }
                return null;
            }
        });
    }

    static void checkAccessHelper(Thread thread, SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (!SecurityManagerHelper.isThreadTerminated(thread) && !SecurityManagerHelper.inThreadGroup(securityManager, thread, classLoader, classArray, field, field2)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAccessHelper(ThreadGroup threadGroup, SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (inThreadGroupCheck.get().equals(Boolean.TRUE)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                inThreadGroupCheck.set(Boolean.TRUE);
                if (!SecurityManagerHelper.inThreadGroup(securityManager, threadGroup, classLoader, classArray, field, field2)) {
                    securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
                Object var7_6 = null;
                inThreadGroupCheck.set(Boolean.FALSE);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                inThreadGroupCheck.set(Boolean.FALSE);
                throw throwable;
            }
        }
    }

    private static boolean isThreadTerminated(Thread thread) {
        try {
            return thread.getState() == Thread.State.TERMINATED;
        }
        catch (Throwable throwable) {
            return !thread.isAlive();
        }
    }

    private static Plugin2ClassLoader currentAppletClassLoader(ClassLoader classLoader, Class[] classArray, final Field field, final Field field2) {
        int n;
        if (classLoader == null || classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof Plugin2ClassLoader)) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            final ClassLoader classLoader2 = classArray[n].getClassLoader();
            if (!(classLoader2 instanceof URLClassLoader) || (classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext accessControlContext = null;
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        accessControlContext = (AccessControlContext)field.get(classLoader2);
                        if (accessControlContext == null) {
                            return null;
                        }
                        protectionDomainArray = (ProtectionDomain[])field2.get(accessControlContext);
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                    for (int i = 0; i < protectionDomainArray.length; ++i) {
                        ClassLoader classLoader = protectionDomainArray[i].getClassLoader();
                        if (!(classLoader instanceof Plugin2ClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        return null;
    }

    private static boolean inThreadGroup(SecurityManager securityManager, ThreadGroup threadGroup, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2) == null) {
            return false;
        }
        ThreadGroup threadGroup2 = SecurityManagerHelper.getThreadGroupHelper(securityManager, classLoader, classArray, field, field2);
        if (threadGroup2 == null) {
            return false;
        }
        return threadGroup2.parentOf(threadGroup);
    }

    private static boolean inThreadGroup(SecurityManager securityManager, Thread thread, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        return SecurityManagerHelper.inThreadGroup(securityManager, thread.getThreadGroup(), classLoader, classArray, field, field2);
    }

    static void checkPackageAccessHelper(SecurityManager securityManager, String string, HashSet hashSet) {
        securityManager.checkPackageAccess(string);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            securityManager.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    static void checkConnectHelper(SecurityManager securityManager, String string, int n, Object object, boolean bl, Class[] classArray) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (CrossDomainXML.quickCheck((String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                securityManager.checkConnect(string, n, object);
            } else {
                securityManager.checkConnect(string, n);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (n2 == -2 ? 1 : 0) != 0)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkURLPermissionHelper(SecurityManager securityManager, Permission permission, Object object, boolean bl, Class[] classArray) {
        URL uRL = null;
        String string = null;
        int n = -1;
        try {
            uRL = new URL(permission.getName());
            string = uRL.getHost();
            n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null || string == null || n < 0) {
            if (bl) {
                securityManager.checkPermission(permission, object);
            } else {
                securityManager.checkPermission(permission);
            }
            return;
        }
        if (CrossDomainXML.quickCheck((String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                securityManager.checkPermission(permission, object);
            } else {
                securityManager.checkPermission(permission);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (boolean)false)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkPermissionHelper(Permission permission) {
        Applet2ExecutionContext applet2ExecutionContext;
        if (permission.getName().equals("setSecurityManager") && !(applet2ExecutionContext = Plugin2Manager.getCurrentAppletExecutionContext()).requestCustomSecurityManager()) {
            throw new SecurityException("JVM Shared, not allowed to set security manager");
        }
    }

    static void checkAwtEventQueueAccessHelper(SecurityManager securityManager, AppContext appContext, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        try {
            AppContext appContext2 = ToolkitStore.get().getAppContext();
            Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
            if (plugin2ClassLoader != null && appContext2 != null && appContext2.equals(plugin2ClassLoader.getAppContext())) {
                return;
            }
            securityManager.checkAwtEventQueueAccess();
            return;
        }
        catch (SecurityException securityException) {
            securityManager.checkSecurityAccess("accessEventQueue");
            return;
        }
    }

    static void checkPrintJobAccessHelper(SecurityManager securityManager) {
        try {
            securityManager.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityManagerHelper.showPrintDialog();
                    return null;
                }
            });
            return;
        }
    }

    private static void showPrintDialog() {
        int n;
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)ToolkitStore.get().getAppContext().get((Object)PRINT_DIALOG_KEY);
        LocalApplicationProperties localApplicationProperties = null;
        if (string4 == null && (localApplicationProperties = SecurityManagerHelper.getLap()) != null) {
            string4 = localApplicationProperties.get(PRINT_DIALOG_KEY);
        }
        if (!Trace.isAutomationEnabled() && string4 == null) {
            n = ToolkitStore.getUI().showMessageDialog(null, null, 7, string, null, string2, null, null, string3, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            n = 0;
        }
        if (n != 0 && n != 2) {
            throw new SecurityException("checkPrintJobAccess");
        }
        ToolkitStore.get().getAppContext().put((Object)PRINT_DIALOG_KEY, (Object)"skip");
        if (n == 2 && localApplicationProperties != null) {
            localApplicationProperties.put(PRINT_DIALOG_KEY, "skip");
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
    }

    private static LocalApplicationProperties getLap() {
        AppInfo appInfo = Plugin2Manager.getCurrentManager().getAppInfo();
        return ResourceProvider.get().getLocalApplicationProperties(appInfo.getLapURL(), null, true);
    }

    static void checkSecurityAccessHelper(SecurityManager securityManager, String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        securityManager.checkSecurityAccess(string);
    }

    static AppContext getAppContextHelper(ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
        if (plugin2ClassLoader == null) {
            return null;
        }
        AppContext appContext = plugin2ClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    static ThreadGroup getThreadGroupHelper(SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        ThreadGroup threadGroup;
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
        ThreadGroup threadGroup2 = threadGroup = plugin2ClassLoader == null ? null : plugin2ClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return securityManager.getThreadGroup();
    }
}

