/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.DocumentHandler;
import com.sun.beans.decoder.ValueObject;

public abstract class ElementHandler {
    private DocumentHandler owner;
    private ElementHandler parent;
    private String id;

    public final DocumentHandler getOwner() {
        return this.owner;
    }

    final void setOwner(DocumentHandler documentHandler) {
        if (documentHandler == null) {
            throw new IllegalArgumentException("Every element should have owner");
        }
        this.owner = documentHandler;
    }

    public final ElementHandler getParent() {
        return this.parent;
    }

    final void setParent(ElementHandler elementHandler) {
        this.parent = elementHandler;
    }

    protected final Object getVariable(String string) {
        if (string.equals(this.id)) {
            ValueObject valueObject = this.getValueObject();
            if (valueObject.isVoid()) {
                throw new IllegalStateException("The element does not return value");
            }
            return valueObject.getValue();
        }
        return this.parent != null ? this.parent.getVariable(string) : this.owner.getVariable(string);
    }

    protected Object getContextBean() {
        if (this.parent != null) {
            ValueObject valueObject = this.parent.getValueObject();
            if (!valueObject.isVoid()) {
                return valueObject.getValue();
            }
            throw new IllegalStateException("The outer element does not return value");
        }
        Object object = this.owner.getOwner();
        if (object != null) {
            return object;
        }
        throw new IllegalStateException("The topmost element does not have context");
    }

    public void addAttribute(String string, String string2) {
        if (!string.equals("id")) {
            throw new IllegalArgumentException("Unsupported attribute: " + string);
        }
        this.id = string2;
    }

    public void startElement() {
    }

    public void endElement() {
        ValueObject valueObject = this.getValueObject();
        if (!valueObject.isVoid()) {
            if (this.id != null) {
                this.owner.setVariable(this.id, valueObject.getValue());
            }
            if (this.isArgument()) {
                if (this.parent != null) {
                    this.parent.addArgument(valueObject.getValue());
                } else {
                    this.owner.addObject(valueObject.getValue());
                }
            }
        }
    }

    public void addCharacter(char c) {
        if (c != ' ' && c != '\n' && c != '\t' && c != '\r') {
            throw new IllegalStateException("Illegal character with code " + c);
        }
    }

    protected void addArgument(Object object) {
        throw new IllegalStateException("Could not add argument to simple element");
    }

    protected boolean isArgument() {
        return this.id == null;
    }

    protected abstract ValueObject getValueObject();
}

