/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import sun.misc.FloatingDecimal;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private char[] data;
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private boolean isNegative = false;
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();
    private StringBuffer tempBuffer;

    DigitList() {
    }

    boolean isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == '0') continue;
            return false;
        }
        return true;
    }

    void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(char c) {
        if (this.count == this.digits.length) {
            char[] cArray = new char[this.count + 100];
            System.arraycopy(this.digits, 0, cArray, 0, this.count);
            this.digits = cArray;
        }
        this.digits[this.count++] = c;
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append('.');
        stringBuffer.append(this.digits, 0, this.count);
        stringBuffer.append('E');
        stringBuffer.append(this.decimalAt);
        return Double.parseDouble(stringBuffer.toString());
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append(this.digits, 0, this.count);
        for (int i = this.count; i < this.decimalAt; ++i) {
            stringBuffer.append('0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    public final BigDecimal getBigDecimal() {
        if (this.count == 0) {
            if (this.decimalAt == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal("0E" + this.decimalAt);
        }
        if (this.decimalAt == this.count) {
            return new BigDecimal(this.digits, 0, this.count);
        }
        return new BigDecimal(this.digits, 0, this.count).scaleByPowerOfTen(this.decimalAt - this.count);
    }

    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (this.count > 0 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        if (this.count == 0) {
            return bl || bl2;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            char c = this.digits[i];
            char c2 = LONG_MIN_REP[i];
            if (c > c2) {
                return false;
            }
            if (c >= c2) continue;
            return true;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    final void set(boolean bl, double d, int n) {
        this.set(bl, d, n, true);
    }

    final void set(boolean bl, double d, int n, boolean bl2) {
        FloatingDecimal.BinaryToASCIIConverter binaryToASCIIConverter = FloatingDecimal.getBinaryToASCIIConverter(d);
        boolean bl3 = binaryToASCIIConverter.digitsRoundedUp();
        boolean bl4 = binaryToASCIIConverter.decimalDigitsExact();
        assert (!binaryToASCIIConverter.isExceptional());
        String string = binaryToASCIIConverter.toJavaFormatString();
        this.set(bl, string, bl3, bl4, n, bl2);
    }

    private void set(boolean bl, String string, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.isNegative = bl;
        int n2 = string.length();
        char[] cArray = this.getDataChars(n2);
        string.getChars(0, n2, cArray, 0);
        this.decimalAt = -1;
        this.count = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl5 = false;
        int n5 = 0;
        while (n5 < n2) {
            char c;
            if ((c = cArray[n5++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c == 'e' || c == 'E') {
                n3 = DigitList.parseInt(cArray, n5, n2);
                break;
            }
            if (!bl5) {
                boolean bl6 = bl5 = c != '0';
                if (!bl5 && this.decimalAt != -1) {
                    ++n4;
                }
            }
            if (!bl5) continue;
            this.digits[this.count++] = c;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (bl5) {
            this.decimalAt += n3 - n4;
        }
        if (bl4) {
            if (-this.decimalAt > n) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == n) {
                if (this.shouldRoundUp(0, bl2, bl3)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        this.round(bl4 ? n + this.decimalAt : n, bl2, bl3);
    }

    private final void round(int n, boolean bl, boolean bl2) {
        if (n >= 0 && n < this.count) {
            if (this.shouldRoundUp(n, bl, bl2)) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n2 = n;
                    this.digits[n2] = (char)(this.digits[n2] + '\u0001');
                } while (this.digits[n] > '9');
                ++n;
            }
            this.count = n;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n, boolean bl, boolean bl2) {
        if (n < this.count) {
            switch (this.roundingMode) {
                case UP: {
                    for (int i = n; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    break;
                }
                case DOWN: {
                    break;
                }
                case CEILING: {
                    for (int i = n; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return !this.isNegative;
                    }
                    break;
                }
                case FLOOR: {
                    for (int i = n; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return this.isNegative;
                    }
                    break;
                }
                case HALF_UP: {
                    if (this.digits[n] < '5') break;
                    return n != this.count - 1 || !bl;
                }
                case HALF_DOWN: {
                    if (this.digits[n] > '5') {
                        return true;
                    }
                    if (this.digits[n] != '5') break;
                    if (n == this.count - 1) {
                        return !bl2 && !bl;
                    }
                    for (int i = n + 1; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    break;
                }
                case HALF_EVEN: {
                    if (this.digits[n] > '5') {
                        return true;
                    }
                    if (this.digits[n] != '5') break;
                    if (n == this.count - 1) {
                        if (bl) {
                            return false;
                        }
                        if (!bl2) {
                            return true;
                        }
                        return n > 0 && this.digits[n - 1] % 2 != 0;
                    }
                    for (int i = n + 1; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        return true;
                    }
                    break;
                }
                case UNNECESSARY: {
                    for (int i = n; i < this.count; ++i) {
                        if (this.digits[i] == '0') continue;
                        throw new ArithmeticException("Rounding needed with the rounding mode being set to RoundingMode.UNNECESSARY");
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return false;
    }

    final void set(boolean bl, long l) {
        this.set(bl, l, 0);
    }

    final void set(boolean bl, long l, int n) {
        this.isNegative = bl;
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n2 = 19;
            while (l > 0L) {
                this.digits[--n2] = (char)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (this.digits[n3] == '0') {
                --n3;
            }
            this.count = n3 - n2 + 1;
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        if (n > 0) {
            this.round(n, false, true);
        }
    }

    final void set(boolean bl, BigDecimal bigDecimal, int n, boolean bl2) {
        String string = bigDecimal.toString();
        this.extendDigits(string.length());
        this.set(bl, string, false, true, n, bl2);
    }

    final void set(boolean bl, BigInteger bigInteger, int n) {
        int n2;
        this.isNegative = bl;
        String string = bigInteger.toString();
        int n3 = string.length();
        this.extendDigits(n3);
        string.getChars(0, n3, this.digits, 0);
        this.decimalAt = n3;
        for (n2 = n3 - 1; n2 >= 0 && this.digits[n2] == '0'; --n2) {
        }
        this.count = n2 + 1;
        if (n > 0) {
            this.round(n, false, true);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == digitList.digits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        for (int i = 0; i < this.count; ++i) {
            n = n * 37 + this.digits[i];
        }
        return n;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.digits.length];
            System.arraycopy(this.digits, 0, cArray, 0, this.digits.length);
            digitList.digits = cArray;
            digitList.tempBuffer = null;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    private static final int parseInt(char[] cArray, int n, int n2) {
        boolean bl = true;
        char c = cArray[n];
        if (c == '-') {
            bl = false;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        int n3 = 0;
        while (n < n2 && (c = cArray[n++]) >= '0' && c <= '9') {
            n3 = n3 * 10 + (c - 48);
        }
        return bl ? n3 : -n3;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append("0.");
        stringBuffer.append(this.digits, 0, this.count);
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new StringBuffer(19);
        } else {
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }

    private void extendDigits(int n) {
        if (n > this.digits.length) {
            this.digits = new char[n];
        }
    }

    private final char[] getDataChars(int n) {
        if (this.data == null || this.data.length < n) {
            this.data = new char[n];
        }
        return this.data;
    }
}

