/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

abstract class XRPaints {
    static XRCompositeManager xrCompMan;
    static final XRGradient xrGradient;
    static final XRLinearGradient xrLinearGradient;
    static final XRRadialGradient xrRadialGradient;
    static final XRTexture xrTexture;

    XRPaints() {
    }

    public static void register(XRCompositeManager xRCompositeManager) {
        xrCompMan = xRCompositeManager;
    }

    private static XRPaints getXRPaint(SunGraphics2D sunGraphics2D) {
        switch (sunGraphics2D.paintState) {
            case 2: {
                return xrGradient;
            }
            case 3: {
                return xrLinearGradient;
            }
            case 4: {
                return xrRadialGradient;
            }
            case 5: {
                return xrTexture;
            }
        }
        return null;
    }

    static boolean isValid(SunGraphics2D sunGraphics2D) {
        XRPaints xRPaints = XRPaints.getXRPaint(sunGraphics2D);
        return xRPaints != null && xRPaints.isPaintValid(sunGraphics2D);
    }

    static void setPaint(SunGraphics2D sunGraphics2D, Paint paint) {
        XRPaints xRPaints = XRPaints.getXRPaint(sunGraphics2D);
        if (xRPaints != null) {
            xRPaints.setXRPaint(sunGraphics2D, paint);
        }
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    abstract void setXRPaint(SunGraphics2D var1, Paint var2);

    public int getGradientLength(Point2D point2D, Point2D point2D2) {
        double d = Math.max(point2D.getX(), point2D2.getX()) - Math.min(point2D.getX(), point2D2.getX());
        double d2 = Math.max(point2D.getY(), point2D2.getY()) - Math.min(point2D.getY(), point2D2.getY());
        return (int)Math.ceil(Math.sqrt(d * d + d2 * d2));
    }

    public int[] convertToIntArgbPixels(Color[] colorArray) {
        int[] nArray = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = this.colorToIntArgbPixel(colorArray[i]);
        }
        return nArray;
    }

    public int colorToIntArgbPixel(Color color) {
        int n = color.getRGB();
        int n2 = Math.round(xrCompMan.getExtraAlpha() * (float)(n >>> 24));
        return n2 << 24 | n & 0xFFFFFF;
    }

    static {
        xrGradient = new XRGradient();
        xrLinearGradient = new XRLinearGradient();
        xrRadialGradient = new XRRadialGradient();
        xrTexture = new XRTexture();
    }

    private static class XRGradient
    extends XRPaints {
        private XRGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            return true;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            int n = gradientPaint.isCyclic() ? 3 : 2;
            float[] fArray = new float[]{0.0f, 1.0f};
            int[] nArray = this.convertToIntArgbPixels(new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()});
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createLinearGradient(point2D, point2D2, fArray, nArray, n);
            xrCompMan.setGradientPaint(new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2));
        }
    }

    private static class XRLinearGradient
    extends XRPaints {
        private XRLinearGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            return ((LinearGradientPaint)sunGraphics2D.getPaint()).getColorSpace() == MultipleGradientPaint.ColorSpaceType.SRGB;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)paint;
            Color[] colorArray = linearGradientPaint.getColors();
            Point2D point2D = linearGradientPaint.getStartPoint();
            Point2D point2D2 = linearGradientPaint.getEndPoint();
            int n = XRUtils.getRepeatForCycleMethod(linearGradientPaint.getCycleMethod());
            float[] fArray = linearGradientPaint.getFractions();
            int[] nArray = this.convertToIntArgbPixels(colorArray);
            AffineTransform affineTransform = linearGradientPaint.getTransform();
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createLinearGradient(point2D, point2D2, fArray, nArray, n);
            XRSurfaceData.XRInternalSurfaceData xRInternalSurfaceData = new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2);
            xRInternalSurfaceData.setStaticSrcTx(affineTransform);
            xrCompMan.setGradientPaint(xRInternalSurfaceData);
        }
    }

    private static class XRRadialGradient
    extends XRPaints {
        private XRRadialGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)sunGraphics2D.paint;
            return radialGradientPaint.getFocusPoint().equals(radialGradientPaint.getCenterPoint()) && radialGradientPaint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.SRGB;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)paint;
            Color[] colorArray = radialGradientPaint.getColors();
            Point2D point2D = radialGradientPaint.getCenterPoint();
            int n = XRUtils.getRepeatForCycleMethod(radialGradientPaint.getCycleMethod());
            float[] fArray = radialGradientPaint.getFractions();
            int[] nArray = this.convertToIntArgbPixels(colorArray);
            float f = radialGradientPaint.getRadius();
            float f2 = (float)point2D.getX();
            float f3 = (float)point2D.getY();
            AffineTransform affineTransform = radialGradientPaint.getTransform();
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createRadialGradient(f2, f3, 0.0f, f, fArray, nArray, n);
            XRSurfaceData.XRInternalSurfaceData xRInternalSurfaceData = new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2);
            xRInternalSurfaceData.setStaticSrcTx(affineTransform);
            xrCompMan.setGradientPaint(xRInternalSurfaceData);
        }
    }

    private static class XRTexture
    extends XRPaints {
        private XRTexture() {
        }

        private XRSurfaceData getAccSrcSurface(XRSurfaceData xRSurfaceData, BufferedImage bufferedImage) {
            SurfaceData surfaceData = xRSurfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null);
            if (!(surfaceData instanceof XRSurfaceData) && !((surfaceData = xRSurfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null)) instanceof XRSurfaceData)) {
                throw new InternalError("Surface not cachable");
            }
            return (XRSurfaceData)surfaceData;
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.getDestSurface();
            return this.getAccSrcSurface(xRSurfaceData, bufferedImage) != null;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            TexturePaint texturePaint = (TexturePaint)paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
            XRSurfaceData xRSurfaceData2 = this.getAccSrcSurface(xRSurfaceData, bufferedImage);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform.scale(rectangle2D.getWidth() / (double)bufferedImage.getWidth(), rectangle2D.getHeight() / (double)bufferedImage.getHeight());
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform.setToIdentity();
            }
            xRSurfaceData2.setStaticSrcTx(affineTransform);
            xRSurfaceData2.validateAsSource(affineTransform, 1, XRUtils.ATransOpToXRQuality(sunGraphics2D.interpolationType));
            xrCompMan.setTexturePaint(xRSurfaceData2);
        }
    }
}

