/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.ThreadPool;

abstract class Port
extends AsynchronousChannelGroupImpl {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    protected final ReadWriteLock fdToChannelLock = new ReentrantReadWriteLock();
    protected final Map<Integer, PollableChannel> fdToChannel = new HashMap<Integer, PollableChannel>();

    Port(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) {
        super(asynchronousChannelProvider, threadPool);
    }

    final void register(int n, PollableChannel pollableChannel) {
        this.fdToChannelLock.writeLock().lock();
        try {
            if (this.isShutdown()) {
                throw new ShutdownChannelGroupException();
            }
            this.fdToChannel.put(n, pollableChannel);
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
    }

    final void unregister(int n) {
        boolean bl = false;
        this.fdToChannelLock.writeLock().lock();
        try {
            this.fdToChannel.remove(n);
            if (this.fdToChannel.isEmpty()) {
                bl = true;
            }
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
        if (bl && this.isShutdown()) {
            try {
                this.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    abstract void startPoll(int var1, int var2);

    @Override
    final boolean isEmpty() {
        this.fdToChannelLock.writeLock().lock();
        try {
            boolean bl = this.fdToChannel.isEmpty();
            return bl;
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
    }

    @Override
    final Object attachForeignChannel(final Channel channel, FileDescriptor fileDescriptor) {
        int n = IOUtil.fdVal(fileDescriptor);
        this.register(n, new PollableChannel(){

            @Override
            public void onEvent(int n, boolean bl) {
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        });
        return n;
    }

    @Override
    final void detachForeignChannel(Object object) {
        this.unregister((Integer)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void closeAllChannels() {
        int n;
        PollableChannel[] pollableChannelArray = new PollableChannel[128];
        do {
            this.fdToChannelLock.writeLock().lock();
            n = 0;
            try {
                for (Integer n2 : this.fdToChannel.keySet()) {
                    pollableChannelArray[n++] = this.fdToChannel.get(n2);
                    if (n < 128) continue;
                    break;
                }
            }
            finally {
                this.fdToChannelLock.writeLock().unlock();
            }
            for (int i = 0; i < n; ++i) {
                try {
                    pollableChannelArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } while (n > 0);
    }

    static interface PollableChannel
    extends Closeable {
        public void onEvent(int var1, boolean var2);
    }
}

