/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.util.locale.provider.LocaleDataMetaInfo;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.resources.OpenListResourceBundle;
import sun.util.resources.ParallelListResourceBundle;
import sun.util.resources.TimeZoneNamesBundle;

public class LocaleData {
    private final LocaleProviderAdapter.Type type;

    public LocaleData(LocaleProviderAdapter.Type type) {
        this.type = type;
    }

    public ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".CalendarData", locale);
    }

    public OpenListResourceBundle getCurrencyNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".CurrencyNames", locale);
    }

    public OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".LocaleNames", locale);
    }

    public TimeZoneNamesBundle getTimeZoneNames(Locale locale) {
        return (TimeZoneNamesBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".TimeZoneNames", locale);
    }

    public ResourceBundle getBreakIteratorInfo(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".BreakIteratorInfo", locale);
    }

    public ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".CollationData", locale);
    }

    public ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".FormatData", locale);
    }

    public void setSupplementary(ParallelListResourceBundle parallelListResourceBundle) {
        if (!parallelListResourceBundle.areParallelContentsComplete()) {
            String string = this.type.getTextResourcesPackage() + ".JavaTimeSupplementary";
            this.setSupplementary(string, parallelListResourceBundle);
        }
    }

    private boolean setSupplementary(String string, ParallelListResourceBundle parallelListResourceBundle) {
        ParallelListResourceBundle parallelListResourceBundle2 = (ParallelListResourceBundle)parallelListResourceBundle.getParent();
        boolean bl = false;
        if (parallelListResourceBundle2 != null) {
            bl = this.setSupplementary(string, parallelListResourceBundle2);
        }
        OpenListResourceBundle openListResourceBundle = LocaleData.getSupplementary(string, parallelListResourceBundle.getLocale());
        parallelListResourceBundle.setParallelContents(openListResourceBundle);
        if (bl |= openListResourceBundle != null) {
            parallelListResourceBundle.resetKeySet();
        }
        return bl;
    }

    public ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".FormatData", locale);
    }

    public static ResourceBundle getBundle(final String string, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                return ResourceBundle.getBundle(string, locale, LocaleDataResourceBundleControl.INSTANCE);
            }
        });
    }

    private static OpenListResourceBundle getSupplementary(final String string, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<OpenListResourceBundle>(){

            @Override
            public OpenListResourceBundle run() {
                OpenListResourceBundle openListResourceBundle = null;
                try {
                    openListResourceBundle = (OpenListResourceBundle)ResourceBundle.getBundle(string, locale, SupplementaryResourceBundleControl.INSTANCE);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                return openListResourceBundle;
            }
        });
    }

    private static class LocaleDataResourceBundleControl
    extends ResourceBundle.Control {
        private static final LocaleDataResourceBundleControl INSTANCE = new LocaleDataResourceBundleControl();
        private static final String CLDR = ".cldr";

        private LocaleDataResourceBundleControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String string, Locale locale) {
            List<Locale> list = super.getCandidateLocales(string, locale);
            String string2 = LocaleDataMetaInfo.getSupportedLocaleString(string);
            if (string2 != null && string2.length() != 0) {
                Iterator<Locale> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Locale locale2 = iterator.next();
                    if (locale2.getScript().length() > 0) {
                        string3 = locale2.toLanguageTag().replace('-', '_');
                    } else {
                        string3 = locale2.toString();
                        int n = string3.indexOf("_#");
                        if (n >= 0) {
                            string3 = string3.substring(0, n);
                        }
                    }
                    if (string3.length() == 0 || string2.indexOf(" " + string3 + " ") != -1) continue;
                    iterator.remove();
                }
            }
            if (locale.getLanguage() != "en" && string.contains(CLDR) && string.endsWith("TimeZoneNames")) {
                list.add(list.size() - 1, Locale.ENGLISH);
            }
            return list;
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public String toBundleName(String string, Locale locale) {
            String string2 = string;
            String string3 = locale.getLanguage();
            if (string3.length() > 0 && (string.startsWith(LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage()) || string.startsWith(LocaleProviderAdapter.Type.JRE.getTextResourcesPackage()))) {
                assert (LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage().length() == LocaleProviderAdapter.Type.JRE.getTextResourcesPackage().length());
                int n = LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage().length();
                if (string.indexOf(CLDR, n) > 0) {
                    n += CLDR.length();
                }
                string2 = string.substring(0, n + 1) + string3 + string.substring(n);
            }
            return super.toBundleName(string2, locale);
        }
    }

    private static class SupplementaryResourceBundleControl
    extends LocaleDataResourceBundleControl {
        private static final SupplementaryResourceBundleControl INSTANCE = new SupplementaryResourceBundleControl();

        private SupplementaryResourceBundleControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String string, Locale locale) {
            return Arrays.asList(locale);
        }

        @Override
        public long getTimeToLive(String string, Locale locale) {
            assert (string.contains("JavaTimeSupplementary"));
            return -1L;
        }
    }
}

