/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import java.util.HashMap;
import java.util.Map;

public class TouchInputSupport {
    private int touchCount = 0;
    private boolean filterTouchCoordinates;
    private Map<Long, Integer> touchX;
    private Map<Long, Integer> touchY;
    private TouchCountListener listener;
    private int curTouchCount;
    private View curView;
    private int curModifiers;
    private boolean curIsDirect;

    public TouchInputSupport(TouchCountListener touchCountListener, boolean bl) {
        Application.checkEventThread();
        this.listener = touchCountListener;
        this.filterTouchCoordinates = bl;
        if (bl) {
            this.touchX = new HashMap<Long, Integer>();
            this.touchY = new HashMap<Long, Integer>();
        }
    }

    public int getTouchCount() {
        Application.checkEventThread();
        return this.touchCount;
    }

    public void notifyBeginTouchEvent(View view, int n, boolean bl, int n2) {
        this.curTouchCount = this.touchCount;
        this.curView = view;
        this.curModifiers = n;
        this.curIsDirect = bl;
        if (view != null) {
            view.notifyBeginTouchEvent(n, bl, n2);
        }
    }

    public void notifyEndTouchEvent(View view) {
        if (view == null) {
            return;
        }
        view.notifyEndTouchEvent();
        if (this.curTouchCount != 0 && this.touchCount != 0 && this.curTouchCount != this.touchCount && this.listener != null) {
            this.listener.touchCountChanged(this, this.curView, this.curModifiers, this.curIsDirect);
        }
    }

    public void notifyNextTouchEvent(View view, int n, long l, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 813: {
                --this.touchCount;
                break;
            }
            case 811: {
                ++this.touchCount;
                break;
            }
            case 812: 
            case 814: {
                break;
            }
            default: {
                System.err.println("Unknown touch state: " + n);
                return;
            }
        }
        if (this.filterTouchCoordinates) {
            n = this.filterTouchInputState(n, l, n2, n3);
        }
        if (view != null) {
            view.notifyNextTouchEvent(n, l, n2, n3, n4, n5);
        }
    }

    private int filterTouchInputState(int n, long l, int n2, int n3) {
        switch (n) {
            case 813: {
                this.touchX.remove(l);
                this.touchY.remove(l);
                break;
            }
            case 812: {
                if (n2 == this.touchX.get(l) && n3 == this.touchY.get(l)) {
                    n = 814;
                    break;
                }
            }
            case 811: {
                this.touchX.put(l, n2);
                this.touchY.put(l, n3);
                break;
            }
            case 814: {
                break;
            }
            default: {
                System.err.println("Unknown touch state: " + n);
            }
        }
        return n;
    }

    public static interface TouchCountListener {
        public void touchCountChanged(TouchInputSupport var1, View var2, int var3, boolean var4);
    }
}

