/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.accessible;

import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.accessible.AccessibleBasePatternProvider;
import com.sun.glass.ui.accessible.AccessibleLogger;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.utils.Rect;
import java.util.ArrayList;
import java.util.List;

public abstract class AccessibleBaseProvider {
    protected List<AccessibleBasePatternProvider> patternProviders;
    protected Object node;

    public static AccessibleBaseProvider createProvider(Object object) {
        AccessibleLogger.getLogger().fine("node: " + object);
        return PlatformFactory.getPlatformFactory().createAccessibleProvider(object);
    }

    public AccessibleBaseProvider(Object object) {
        this.node = object;
        this.patternProviders = new ArrayList<AccessibleBasePatternProvider>();
    }

    public Object getNode() {
        return this.node;
    }

    public void addPatternProviders(AccessibleBasePatternProvider accessibleBasePatternProvider) {
        this.patternProviders.add(accessibleBasePatternProvider);
    }

    public abstract void destroyAccessible();

    public abstract void fireEvent(int var1);

    public abstract void firePropertyChange(int var1, int var2, int var3);

    public abstract void firePropertyChange(int var1, boolean var2, boolean var3);

    protected Object getPropertyValue(int n) {
        AccessibleLogger.getLogger().fine("propertyID: " + n);
        Object object = this.node instanceof AccessibleProvider ? ((AccessibleProvider)this.node).getPropertyValue(n) : null;
        AccessibleLogger.getLogger().fine("returning: " + object);
        return object;
    }

    private Rect boundingRectangle() {
        Rect rect;
        if (this.node instanceof AccessibleProvider) {
            rect = ((AccessibleProvider)this.node).boundingRectangle();
            AccessibleLogger.getLogger().fine("returning: MinX=" + rect.getMinX() + "MinY=" + rect.getMinY() + "MaxX=" + rect.getMaxX() + "MaxY=" + rect.getMaxY());
        } else {
            rect = null;
        }
        return rect;
    }

    private void setFocus() {
        if (this.node instanceof AccessibleProvider) {
            ((AccessibleProvider)this.node).setFocus();
        }
    }
}

