/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.events.ViewEvent;
import com.sun.glass.events.WindowEvent;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.lens.LensCursor;
import com.sun.glass.ui.lens.LensLogger;
import com.sun.glass.ui.lens.LensPixels;
import com.sun.glass.ui.lens.LensRobot;
import com.sun.glass.ui.lens.LensTimer;
import com.sun.glass.ui.lens.LensTouchInputSupport;
import com.sun.glass.ui.lens.LensView;
import com.sun.glass.ui.lens.LensWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import sun.util.logging.PlatformLogger;

final class LensApplication
extends Application {
    private static final int DEVICE_TOUCH = 0;
    private static final int DEVICE_MULTITOUCH = 1;
    private static final int DEVICE_POINTER = 2;
    private static final int DEVICE_5WAY = 3;
    private static final int DEVICE_PC_KEYBOARD = 4;
    private static final int DEVICE_MAX = 4;
    private int[] deviceFlags = new int[5];
    private int previousTouchMoveX = -1;
    private int previousTouchMoveY = -1;
    private int previousTouchMoveScreenX = -1;
    private int previousTouchMoveScreenY = -1;
    private boolean cursorVisible = true;
    Menu windowMenu;
    Menu editMenu;
    Menu fileMenu;
    private static final Object invokeAndWaitLock = new Object();
    private static Runnable waitingFor;
    private static int activeEventLoopThreads;
    private static final Object activeEventLoopLock;
    private static boolean doComposite;
    private static boolean isInitialized;
    private EventLoop dndEventLoop;
    private final LinkedList<Event> eventList = new LinkedList();
    LinkedList<RunLoopControl> activeRunLoops = new LinkedList();
    private static int nativeThreadCounter;
    private int cachedButtonPressed = 211;
    private LensView dragView = null;
    private int dragActionsPreformed = DragActions.NONE.getValue();
    private boolean dragStarted = false;

    private static native void _initIDs();

    private static native boolean _initialize();

    private static native void _notifyRenderingEnd();

    private static void initLibrary() {
        final String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("glass.lens", "");
            }
        });
        doComposite = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("doNativeComposite");
            }
        });
        if (isInitialized) {
            return;
        }
        LensLogger.getLogger().info("LensApplication initialization");
        if (string.equals("")) {
            LensLogger.getLogger().severe("System property glass.lens not defined");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LensApplication.loadNativeLibrary("glass_lens_" + string);
                return null;
            }
        });
        LensApplication._initIDs();
        isInitialized = true;
        LensLogger.getLogger().info("LensApplication initialization done");
    }

    native void registerApplication();

    LensApplication() {
        LensLogger.getLogger().fine("LensApplication ctor called, registering in native layer");
        this.registerApplication();
    }

    @Override
    public boolean hasWindowManager() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvent(Event event) {
        if (Thread.currentThread() == LensApplication.getEventThread()) {
            try {
                event.dispatch();
            }
            catch (Exception exception) {
                LensApplication.reportException(exception);
            }
        } else {
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                this.eventList.addLast(event);
                this.eventList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postMouseEvent(LensView lensView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            if (!(this.eventList.isEmpty() || n != 223 && n != 224)) {
                Iterator<Event> iterator = this.eventList.descendingIterator();
                while (iterator.hasNext()) {
                    LensMouseEvent lensMouseEvent;
                    Event event = iterator.next();
                    if (!(event instanceof LensMouseEvent) || (lensMouseEvent = (LensMouseEvent)event).target != lensView || lensMouseEvent.action != n || lensMouseEvent.button != n6 || lensMouseEvent.modifiers != n7 || lensMouseEvent.isPopupTrigger != bl || lensMouseEvent.isSynthesized != bl2) continue;
                    lensMouseEvent.x = n2;
                    lensMouseEvent.y = n3;
                    lensMouseEvent.absx = n4;
                    lensMouseEvent.absy = n5;
                    return;
                }
            }
            this.postEvent(new LensMouseEvent(lensView, n, n2, n3, n4, n5, n6, n7, bl, bl2));
        }
    }

    @Override
    protected Object _enterNestedEventLoop() {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_enterNestedEventLoop");
        }
        Object object = this._runLoop();
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Resuming event loop");
        }
        return object;
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_leaveNestedEventLoop");
        }
        RunLoopControl runLoopControl = this.activeRunLoops.pop();
        assert (runLoopControl != null);
        runLoopControl.active = false;
        runLoopControl.release = object;
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_leaveNestedEventLoop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _runLoop() {
        RunLoopControl runLoopControl = new RunLoopControl();
        this.activeRunLoops.push(runLoopControl);
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Starting event loop");
        }
        runLoopControl.active = true;
        while (runLoopControl.active) {
            Event event;
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                if (this.eventList.isEmpty()) {
                    try {
                        this.eventList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                if (this.eventList.isEmpty()) {
                    continue;
                }
                event = this.eventList.removeFirst();
            }
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().fine("Processing " + event);
            }
            try {
                event.dispatch();
            }
            catch (Exception exception) {
                LensApplication.reportException(exception);
            }
        }
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Leaving event loop");
        }
        return runLoopControl.release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEventLoop() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            LensLogger.getLogger().info("activeEventLoopThreads := " + ++activeEventLoopThreads);
            activeEventLoopLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterEventLoop() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            LensLogger.getLogger().info("activeEventLoopThreads := " + --activeEventLoopThreads);
            activeEventLoopLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitEventLoopsToFinish() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            try {
                LensLogger.getLogger().info("Waiting for all event loops to finish");
                while (activeEventLoopThreads > 0) {
                    LensLogger.getLogger().info("activeEventLoopThreads = " + activeEventLoopThreads);
                    activeEventLoopLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                LensLogger.getLogger().severe("interrupted");
            }
        }
    }

    @Override
    protected void runLoop(Runnable runnable) {
        this._invokeLater(runnable);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!LensApplication._initialize()) {
                    LensLogger.getLogger().severe("Display failed initialization");
                    throw new RuntimeException("Display failed initialization");
                }
                LensApplication.this._runLoop();
            }
        }, "Lens Event Thread");
        LensApplication.setEventThread(thread);
        thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LensApplication.this.shutdown();
            }
        });
    }

    private native void nativeEventLoop(LensApplication var1, long var2, long var4);

    private static void createNativeEventThread(final long l, final long l2) {
        final LensApplication lensApplication = (LensApplication)Application.GetApplication();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LensApplication.registerEventLoop();
                lensApplication.nativeEventLoop(lensApplication, l, l2);
                LensApplication.unregisterEventLoop();
            }
        }, "Lens Native Event Thread " + nativeThreadCounter++);
        LensLogger.getLogger().info("Starting native event thread");
        thread.setDaemon(true);
        thread.start();
    }

    Object enterDnDEventLoop() {
        this.dndEventLoop = this.createEventLoop();
        return this.dndEventLoop.enter();
    }

    void leaveDndEventLoop(Object object) {
        this.dndEventLoop.leave(object);
    }

    native void shutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTerminating() {
        LensLogger.getLogger().info("Finishing terminating");
        this.shutdown();
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.clear();
            while (!this.activeRunLoops.isEmpty()) {
                RunLoopControl runLoopControl = this.activeRunLoops.pop();
                runLoopControl.active = false;
            }
            this.eventList.notify();
        }
        super.finishTerminating();
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    protected void notifyWindowResize(LensWindow lensWindow, int n, int n2, int n3) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
            LensLogger.getLogger().info("notifyResize with " + WindowEvent.getEventName(n) + " event " + lensWindow + " to " + n2 + "x" + n3);
        }
        if (lensWindow != null) {
            this.postEvent(new LensWindowEvent(LensWindowEvent.EType.RESIZE, lensWindow, n, 0, 0, n2, n3));
        }
    }

    protected void notifyWindowMove(LensWindow lensWindow, int n, int n2) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
            LensLogger.getLogger().info("Move " + lensWindow + " to " + n + "," + n2);
        }
        this.postEvent(new LensWindowEvent(LensWindowEvent.EType.MOVE, lensWindow, 512, n, n2, 0, 0));
    }

    protected void notifyWindowEvent(LensWindow lensWindow, int n) {
        LensWindowEvent.EType eType = null;
        switch (n) {
            case 542: {
                eType = LensWindowEvent.EType.FOCUS;
                break;
            }
            case 541: {
                eType = LensWindowEvent.EType.FOCUS;
                break;
            }
            case 522: {
                eType = LensWindowEvent.EType.DESTROY;
                break;
            }
            case 521: {
                eType = LensWindowEvent.EType.CLOSE;
                break;
            }
            case 546: {
                eType = LensWindowEvent.EType.UNGRAB;
                break;
            }
            case 545: {
                eType = LensWindowEvent.EType.FOCUS_DISABLED;
                break;
            }
            default: {
                LensLogger.getLogger().warning("Unsupported event type (" + WindowEvent.getEventName(n) + ") skipping event");
                return;
            }
        }
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("notifyWindowEvent eventType = " + WindowEvent.getEventName(n));
        }
        if (eType != null) {
            this.postEvent(new LensWindowEvent(eType, lensWindow, n));
        }
    }

    protected void windowExpose(LensWindow lensWindow, int n, int n2, int n3, int n4) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Expose " + lensWindow + " " + n + "," + n2 + "+" + n3 + "x" + n4);
        }
        this.postEvent(new LensWindowEvent(LensWindowEvent.EType.EXPOSE, lensWindow, 511, n, n2, n3, n4));
    }

    private void notifyKeyEvent(LensView lensView, int n, int n2, int n3, char[] cArray) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
                LensLogger.getLogger().finer("Key event on " + lensView);
            }
            this.postEvent(new LensKeyEvent(lensView, n, n2, n3, cArray));
        }
        catch (Exception exception) {
            LensApplication.reportException(exception);
        }
    }

    void notifyMouseEvent(LensView lensView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("Mouse event on " + lensView);
            }
            if (!this.handleDragEvents(lensView, n, n2, n3, n4, n5, n6, n7)) {
                this.postMouseEvent(lensView, n, n2, n3, n4, n5, n6, n7, bl, bl2);
            }
        }
        catch (Exception exception) {
            LensApplication.reportException(exception);
        }
    }

    private native void _notfyPlatformDnDStarted();

    private native void _notfyPlatformDnDEnded();

    void notifyDragStart() {
        this._notfyPlatformDnDStarted();
        this.dragStarted = true;
    }

    private boolean handleDragEvents(LensView lensView, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = false;
        if (n == 221 && this.cachedButtonPressed == 211) {
            this.cachedButtonPressed = n6;
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("Caching mouse button - " + n6);
            }
        } else if (n == 222 && n6 == this.cachedButtonPressed) {
            this.cachedButtonPressed = 211;
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("reset mouse button cache " + n6);
            }
            if (this.dragStarted) {
                if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                    LensLogger.getLogger().finest("notifying drag DROP");
                }
                this.postEvent(new LensDragEvent(lensView, n2, n3, n4, n5, DragActions.DROP));
                this._notfyPlatformDnDEnded();
                this.dragActionsPreformed = DragActions.NONE.getValue();
                this.dragView = null;
                this.dragStarted = false;
            }
        } else if (n == 224 && this.cachedButtonPressed != 211 && ((n7 & 0x20) == 32 || (n7 & 0x80) == 128 || (n7 & 0x40) == 64)) {
            if (this.dragStarted) {
                bl = true;
                if (this.dragView == lensView && this.dragActionsPreformed == DragActions.NONE.getValue()) {
                    this.postEvent(new LensDragEvent(lensView, n2, n3, n4, n5, DragActions.ENTER));
                    this.dragActionsPreformed |= DragActions.ENTER.getValue();
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragEnter");
                    }
                } else if (this.dragView == lensView && (this.dragActionsPreformed & DragActions.ENTER.getValue()) == DragActions.ENTER.getValue()) {
                    this.postEvent(new LensDragEvent(lensView, n2, n3, n4, n5, DragActions.OVER));
                    this.dragActionsPreformed |= DragActions.OVER.getValue();
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragOver");
                    }
                } else if (this.dragView != lensView) {
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragLeave old view");
                    }
                    this.postEvent(new LensDragEvent(this.dragView, n2, n3, n4, n5, DragActions.LEAVE));
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragEnter new view");
                    }
                    this.postEvent(new LensDragEvent(lensView, n2, n3, n4, n5, DragActions.ENTER));
                    this.dragActionsPreformed = DragActions.ENTER.getValue();
                    this.dragView = lensView;
                }
            } else {
                n = 223;
                if (this.dragView == null) {
                    this.dragView = lensView;
                }
                if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                    LensLogger.getLogger().finest("Drag detected - sending DRAG event");
                }
                this.postMouseEvent(lensView, n, n2, n3, n4, n5, n6, n7, false, false);
                bl = true;
            }
        }
        return bl;
    }

    private void notifyScrollEvent(LensView lensView, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, int n7, int n8, int n9, double d3, double d4) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("Scroll event on " + lensView);
            }
            this.postEvent(new LensScrollEvent(lensView, n, n2, n3, n4, d, d2, n5, n6, n7, n8, n9, d3, d4));
        }
        catch (Exception exception) {
            LensApplication.reportException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postTouchMoveEvent(LensView lensView, long l, int n, int n2, int n3, int n4) {
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            boolean bl = false;
            if (!this.eventList.isEmpty()) {
                Iterator<Event> iterator = this.eventList.descendingIterator();
                while (iterator.hasNext()) {
                    Event event = iterator.next();
                    if (event instanceof LensTouchEvent) {
                        LensTouchEvent lensTouchEvent = (LensTouchEvent)event;
                        if (lensTouchEvent.view != lensView || lensTouchEvent.id != l || lensTouchEvent.state != 812 && lensTouchEvent.state != 814) break;
                        lensTouchEvent.x = n;
                        lensTouchEvent.y = n2;
                        lensTouchEvent.absX = n3;
                        lensTouchEvent.absY = n4;
                        bl = true;
                        break;
                    }
                    if (!(event instanceof LensMultiTouchEvent)) continue;
                    break;
                }
            }
            if (!bl) {
                this.postEvent(new LensTouchEvent(lensView, 812, l, n, n2, n3, n4));
            }
        }
    }

    private void notifyTouchEvent(LensView lensView, int n, long l, int n2, int n3, int n4, int n5) {
        try {
            boolean bl;
            boolean bl2 = bl = this.previousTouchMoveScreenX >= 0;
            if (n == 812) {
                this.postTouchMoveEvent(lensView, l, n2, n3, n4, n5);
            } else {
                this.postEvent(new LensTouchEvent(lensView, n, l, n2, n3, n4, n5));
            }
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("Touch event " + n + " at " + n2 + "," + n3 + " on " + lensView);
            }
        }
        catch (Exception exception) {
            LensApplication.reportException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMultiTouchEvent(LensView lensView, int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, int n, int n2) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("MultiTouch event with " + nArray.length + " points " + " on " + lensView);
            }
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                boolean bl = false;
                if (!this.eventList.isEmpty()) {
                    Iterator<Event> iterator = this.eventList.descendingIterator();
                    while (iterator.hasNext()) {
                        Event event = iterator.next();
                        if (event instanceof LensMultiTouchEvent) {
                            LensMultiTouchEvent lensMultiTouchEvent = (LensMultiTouchEvent)event;
                            if (lensMultiTouchEvent.view != lensView || lensMultiTouchEvent.states.length != nArray.length) break;
                            assert (nArray.length == lArray.length);
                            assert (lensMultiTouchEvent.states.length == lensMultiTouchEvent.ids.length);
                            bl = true;
                            for (int i = 0; i < nArray.length && bl; ++i) {
                                if (lensMultiTouchEvent.states[i] != 812 && lensMultiTouchEvent.states[i] != 814 || nArray[i] != 812 && nArray[i] != 814) {
                                    bl = false;
                                }
                                if (lensMultiTouchEvent.ids[i] == lArray[i]) continue;
                                bl = false;
                            }
                            if (!bl) break;
                            LensMultiTouchEvent.access$3202(lensMultiTouchEvent, nArray2);
                            LensMultiTouchEvent.access$3302(lensMultiTouchEvent, nArray3);
                            LensMultiTouchEvent.access$3002(lensMultiTouchEvent, nArray);
                            lensMultiTouchEvent.dx = n;
                            lensMultiTouchEvent.dy = n2;
                            break;
                        }
                        if (!(event instanceof LensTouchEvent)) continue;
                        break;
                    }
                }
                if (!bl) {
                    this.postEvent(new LensMultiTouchEvent(lensView, nArray, lArray, nArray2, nArray3, n, n2));
                }
            }
        }
        catch (Exception exception) {
            LensApplication.reportException(exception);
        }
    }

    private void notifyViewEvent(LensView lensView, int n, int n2, int n3, int n4, int n5) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Notify event type " + ViewEvent.getTypeString(n) + " on " + lensView);
        }
        this.postEvent(new LensViewEvent(lensView, n, n2, n3, n4, n5));
    }

    private void notifyMenuEvent(LensView lensView, int n, int n2, int n3, int n4, boolean bl) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
            LensLogger.getLogger().finer("Notify menu event x=" + n + ", y=" + n2 + ", xAbs=" + n3 + ", yAbs=" + n4 + ", isKeyboardTrigger " + bl + ", on " + lensView);
        }
        if (lensView != null) {
            this.postEvent(new LensMenuEvent(lensView, n, n2, n3, n4, bl));
        } else if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
            LensLogger.getLogger().finer("view is null, skipping event");
        }
    }

    private void notifyDeviceEvent(int n, boolean bl) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Notify device event attach=" + bl + ", flags=0x" + Integer.toHexString(n));
        }
        this.postEvent(new LensDeviceEvent(n, bl));
    }

    public void installWindowMenu(MenuBar menuBar) {
        this.windowMenu = this.createMenu("Window");
    }

    public Menu getWindowMenu() {
        return this.windowMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menuBar) {
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new LensWindow(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new LensWindow(l);
    }

    @Override
    public View createView() {
        return new LensView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new LensCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new LensCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        this.cursorVisible = bl;
        if (this.deviceFlags[2] >= 1) {
            LensCursor.setVisible_impl(bl);
        }
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return LensCursor.getBestSize_impl(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new LensPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new LensPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f) {
        return new LensPixels(n, n2, intBuffer, f);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return LensPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new LensRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new LensTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return LensTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return LensTimer.getMaxPeriod_impl();
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        return null;
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return null;
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return LensView._getMultiClickTime();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return LensView._getMultiClickMaxX();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return LensView._getMultiClickMaxY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
            LensLogger.getLogger().fine("invokeAndWait " + runnable);
        }
        Object object = invokeAndWaitLock;
        synchronized (object) {
            waitingFor = runnable;
        }
        object = this.eventList;
        synchronized (object) {
            this.eventList.addLast(new RunnableEvent(true, runnable));
            this.eventList.notify();
        }
        object = invokeAndWaitLock;
        synchronized (object) {
            while (waitingFor == runnable) {
                try {
                    invokeAndWaitLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _invokeLater(Runnable runnable) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
            LensLogger.getLogger().fine("invokeLater " + runnable);
        }
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.addLast(new RunnableEvent(false, runnable));
            this.eventList.notify();
        }
    }

    @Override
    public boolean hasTwoLevelFocus() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[3] > 0;
    }

    @Override
    public boolean hasVirtualKeyboard() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasTouch() {
        return this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasMultiTouch() {
        return this.deviceFlags[1] > 0;
    }

    @Override
    public boolean hasPointer() {
        return this.deviceFlags[2] > 0;
    }

    static {
        activeEventLoopThreads = 0;
        activeEventLoopLock = new Object();
        doComposite = true;
        isInitialized = false;
        LensApplication.initLibrary();
        nativeThreadCounter = 0;
    }

    private static enum DragActions {
        NONE(0, "NONE"),
        ENTER(2, "ENTER"),
        LEAVE(4, "LEAVE"),
        OVER(8, "OVER"),
        DROP(16, "DROP");

        public int value;
        private String name;

        private DragActions(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    private static abstract class Event {
        private Event() {
        }

        abstract void dispatch();
    }

    private class LensDeviceEvent
    extends Event {
        private int flags;
        private boolean attach;

        LensDeviceEvent(int n, boolean bl) {
            this.flags = n;
            this.attach = bl;
        }

        @Override
        void dispatch() {
            for (int i = 0; i <= 4; ++i) {
                if ((this.flags & 1 << i) == 0) continue;
                if (this.attach) {
                    int[] nArray = LensApplication.this.deviceFlags;
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = LensApplication.this.deviceFlags;
                int n = i;
                nArray[n] = nArray[n] - 1;
            }
            if ((this.flags & 4) != 0) {
                if (this.attach && LensApplication.this.deviceFlags[2] == 1 && LensApplication.this.cursorVisible) {
                    LensCursor.setVisible_impl(true);
                } else if (!this.attach && LensApplication.this.deviceFlags[2] == 0) {
                    LensCursor.setVisible_impl(false);
                }
            }
        }
    }

    private class LensDragEvent
    extends Event {
        int x;
        int y;
        int absx;
        int absy;
        DragActions action;
        LensView view;
        final int ENTER = DragActions.ENTER.getValue();
        final int LEAVE = DragActions.LEAVE.getValue();
        final int OVER = DragActions.OVER.getValue();
        final int DROP = DragActions.DROP.getValue();

        LensDragEvent(LensView lensView, int n, int n2, int n3, int n4, DragActions dragActions) {
            this.absx = n3;
            this.absy = n4;
            this.x = n;
            this.y = n2;
            this.action = dragActions;
            this.view = lensView;
        }

        @Override
        void dispatch() {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("processing drag  " + (Object)((Object)this.action));
            }
            switch (this.action) {
                case ENTER: {
                    this.view._notifyDragEnter(this.x, this.y, this.absx, this.absy, 3);
                    break;
                }
                case LEAVE: {
                    this.view._notifyDragLeave();
                    break;
                }
                case OVER: {
                    this.view._notifyDragOver(this.x, this.y, this.absx, this.absy, 3);
                    break;
                }
                case DROP: {
                    this.view._notifyDragDrop(this.x, this.y, this.absx, this.absy, 3);
                    LensApplication.this.leaveDndEventLoop(null);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public String toString() {
            return "LensDragEvent[x=" + this.x + ", y=" + this.y + ", absx=" + this.absx + ", absy=" + this.absy + ", action " + (Object)((Object)this.action) + ", view " + this.view;
        }
    }

    private static class LensKeyEvent
    extends Event {
        private LensView view;
        private int type;
        private int keyCode;
        private int modifiers;
        private char[] chars;

        LensKeyEvent(LensView lensView, int n, int n2, int n3, char[] cArray) {
            this.view = lensView;
            this.type = n;
            this.keyCode = n2;
            this.modifiers = n3;
            this.chars = cArray;
        }

        @Override
        void dispatch() {
            this.view._notifyKey(this.type, this.keyCode, this.chars, this.modifiers);
        }

        public String toString() {
            return "LensKeyEvent[view=" + this.view + ",type=" + this.type + ",keyCode=" + this.keyCode + ",modifiers=" + this.modifiers + ",chars=" + String.valueOf(this.chars) + "]";
        }
    }

    private class LensMenuEvent
    extends Event {
        LensView view;
        int x;
        int y;
        int xAbs;
        int yAbs;
        boolean isKeyboardTrigger;

        LensMenuEvent(LensView lensView, int n, int n2, int n3, int n4, boolean bl) {
            this.view = lensView;
            this.x = n;
            this.y = n2;
            this.xAbs = n3;
            this.yAbs = n4;
            this.isKeyboardTrigger = bl;
        }

        @Override
        void dispatch() {
            this.view._notifyMenu(this.x, this.y, this.xAbs, this.yAbs, this.isKeyboardTrigger);
        }

        public String toString() {
            return "LensMenuEvent[view=" + this.view + ", x=" + this.x + ", y=" + this.y + ", absx=" + this.xAbs + ", absy=" + this.yAbs + ", isKeyboardTrigger=" + this.isKeyboardTrigger + "]";
        }
    }

    private static class LensMouseEvent
    extends Event {
        private LensView target;
        private int action;
        private int x;
        private int y;
        private int absx;
        private int absy;
        private int button;
        private int modifiers;
        private boolean isPopupTrigger;
        private boolean isSynthesized;

        LensMouseEvent(LensView lensView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
            this.target = lensView;
            this.action = n;
            this.x = n2;
            this.y = n3;
            this.absx = n4;
            this.absy = n5;
            this.button = n6;
            this.modifiers = n7;
            this.isPopupTrigger = bl;
            this.isSynthesized = bl2;
        }

        @Override
        void dispatch() {
            this.target._notifyMouse(this.action, this.button, this.x, this.y, this.absx, this.absy, this.modifiers, this.isPopupTrigger, this.isSynthesized);
        }

        public String toString() {
            return "LensMouseEvent[target=" + this.target + ",action=" + this.action + ",x=" + this.x + ",y=" + this.y + ",absx=" + this.absx + ",absy=" + this.absy + ",button=" + this.button + ",modifiers=" + this.modifiers + ",isPopupTrigger=" + this.isPopupTrigger + ",isSynthesized=" + this.isSynthesized + "]";
        }
    }

    private static class LensMultiTouchEvent
    extends Event {
        private LensView view;
        private int[] states;
        private long[] ids;
        private int[] xs;
        private int[] ys;
        private int dx;
        private int dy;

        LensMultiTouchEvent(LensView lensView, int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, int n, int n2) {
            this.view = lensView;
            this.states = nArray;
            this.ids = lArray;
            this.xs = nArray2;
            this.ys = nArray3;
            this.dx = n;
            this.dy = n2;
        }

        @Override
        void dispatch() {
            LensTouchInputSupport.postMultiTouchEvent(this.view, this.states, this.ids, this.xs, this.ys, this.dx, this.dy);
        }

        public String toString() {
            return "LensMultiTouchEvent[view=" + this.view + ", ids " + Arrays.toString(this.ids) + ", states " + Arrays.toString(this.states) + ", xs " + Arrays.toString(this.xs) + ", ys " + Arrays.toString(this.ys) + "]";
        }

        static /* synthetic */ int[] access$3202(LensMultiTouchEvent lensMultiTouchEvent, int[] nArray) {
            lensMultiTouchEvent.xs = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$3302(LensMultiTouchEvent lensMultiTouchEvent, int[] nArray) {
            lensMultiTouchEvent.ys = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$3002(LensMultiTouchEvent lensMultiTouchEvent, int[] nArray) {
            lensMultiTouchEvent.states = nArray;
            return nArray;
        }
    }

    private static class LensScrollEvent
    extends Event {
        private LensView target;
        private int x;
        private int y;
        private int absx;
        private int absy;
        private double deltaX;
        private double deltaY;
        private int modifiers;
        private int lines;
        private int chars;
        private int defaultLines;
        private int defaultChars;
        private double xMultiplier;
        private double yMultiplier;

        LensScrollEvent(LensView lensView, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, int n7, int n8, int n9, double d3, double d4) {
            this.target = lensView;
            this.x = n;
            this.y = n2;
            this.absx = n3;
            this.absy = n4;
            this.deltaX = d;
            this.deltaY = d2;
            this.modifiers = n5;
            this.lines = n6;
            this.chars = n7;
            this.defaultLines = n8;
            this.defaultChars = n9;
            this.xMultiplier = d3;
            this.yMultiplier = d4;
        }

        @Override
        void dispatch() {
            this.target._notifyScroll(this.x, this.y, this.absx, this.absy, this.deltaX, this.deltaY, this.modifiers, this.lines, this.chars, this.defaultLines, this.defaultChars, this.xMultiplier, this.yMultiplier);
        }

        public String toString() {
            return "LensScrollEvent[target=" + this.target + ",x=" + this.x + ",y=" + this.y + ",absx=" + this.absx + ",absy=" + this.absy + ",deltaX=" + this.deltaX + ",deltaY=" + this.deltaY + ",modifiers=" + this.modifiers + ",lines=" + this.lines + ",chars=" + this.chars + ",defaultLines=" + this.defaultLines + ",defaultChars=" + this.defaultChars + ",xMultiplier=" + this.xMultiplier + ",yMultiplier=" + this.yMultiplier + "]";
        }
    }

    private static class LensTouchEvent
    extends Event {
        private LensView view;
        private int state;
        private long id;
        private int x;
        private int y;
        private int absX;
        private int absY;

        LensTouchEvent(LensView lensView, int n, long l, int n2, int n3, int n4, int n5) {
            this.view = lensView;
            this.state = n;
            this.id = l;
            this.x = n2;
            this.y = n3;
            this.absX = n4;
            this.absY = n5;
        }

        @Override
        void dispatch() {
            LensTouchInputSupport.postTouchEvent(this.view, this.state, this.id, this.x, this.y, this.absX, this.absY);
        }

        public String toString() {
            return "LensTouchEvent[view=" + this.view + ",state=" + this.state + ",id=" + this.id + ",x=" + this.x + ",y=" + this.y + ",absX=" + this.absX + ",absY=" + this.absY + "]";
        }
    }

    private static class LensViewEvent
    extends Event {
        private LensView target;
        private int x;
        private int y;
        private int width;
        private int height;
        private int viewEventType;

        LensViewEvent(LensView lensView, int n, int n2, int n3, int n4, int n5) {
            this.target = lensView;
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.height = n5;
            this.viewEventType = n;
        }

        @Override
        void dispatch() {
            this.target._notifyViewEvent(this.viewEventType);
        }

        public String toString() {
            return "LensViewEvent[target=" + this.target + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", event type code " + this.viewEventType + ", event type name " + ViewEvent.getTypeString(this.viewEventType);
        }
    }

    private static class LensWindowEvent
    extends Event {
        private EType type;
        private LensWindow window;
        private int windowEvent;
        private int x;
        private int y;
        private int width;
        private int height;

        LensWindowEvent(EType eType, LensWindow lensWindow, int n) {
            this.type = eType;
            this.window = lensWindow;
            this.windowEvent = n;
        }

        LensWindowEvent(EType eType, LensWindow lensWindow, int n, int n2, int n3, int n4, int n5) {
            this.type = eType;
            this.window = lensWindow;
            this.windowEvent = n;
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.height = n5;
        }

        @Override
        void dispatch() {
            switch (this.type) {
                case FOCUS: {
                    this.window._notifyFocus(this.windowEvent);
                    break;
                }
                case MOVE: {
                    this.window._notifyMove(this.x, this.y);
                    break;
                }
                case RESIZE: {
                    this.window._notifyResize(this.windowEvent, this.width, this.height);
                    break;
                }
                case UNGRAB: {
                    this.window._notifyFocusUngrab();
                    break;
                }
                case DESTROY: {
                    this.window._notifyDestroy();
                    break;
                }
                case CLOSE: {
                    this.window._notifyClose();
                    break;
                }
                case EXPOSE: {
                    this.window._notifyExpose(this.x, this.y, this.width, this.height);
                    break;
                }
                case FOCUS_DISABLED: {
                    this.window._notifyFocusDisabled();
                    break;
                }
                default: {
                    LensLogger.getLogger().severe("Unrecognized window event type");
                }
            }
        }

        public String toString() {
            return super.toString() + "[window=" + this.window + ",type=" + (Object)((Object)this.type) + ",windowEvent=" + this.windowEvent + ",x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }

        static enum EType {
            CLOSE,
            DESTROY,
            EXPOSE,
            FOCUS,
            MOVE,
            RESIZE,
            UNGRAB,
            FOCUS_DISABLED;

        }
    }

    private static class RunLoopControl {
        boolean active;
        Object release;

        private RunLoopControl() {
        }
    }

    private static class RunnableEvent
    extends Event {
        private boolean wait;
        private Runnable runnable;

        RunnableEvent(boolean bl, Runnable runnable) {
            this.wait = bl;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch() {
            this.runnable.run();
            if (this.wait) {
                Object object = invokeAndWaitLock;
                synchronized (object) {
                    waitingFor = null;
                    invokeAndWaitLock.notify();
                }
            }
        }

        public String toString() {
            return "RunnableEvent[runnable=" + this.runnable + ",wait=" + this.wait + "]";
        }
    }
}

