/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.lens.LensApplication;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

final class LensCursor
extends Cursor {
    private long ptr = 0L;

    protected LensCursor(int n) {
        super(n);
        if (n != -1) {
            this.ptr = this._createNativeCursorByType(n);
        }
    }

    protected LensCursor(int n, int n2, Pixels pixels) {
        super(n, n2, pixels);
        this.ptr = this.getNativeCursor();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.ptr != 0L) {
                this._releaseNativeCursor(this.ptr);
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected long _createCursor(int n, int n2, Pixels pixels) {
        long l = 0L;
        Buffer buffer = pixels.getPixels();
        int n3 = pixels.getWidth();
        int n4 = pixels.getHeight();
        if (buffer != null) {
            if (!buffer.isDirect()) {
                if (pixels.getBytesPerComponent() == 4) {
                    IntBuffer intBuffer = (IntBuffer)buffer.rewind();
                    int[] nArray = intBuffer.array();
                    l = this._createNativeCursorInts(n, n2, nArray, n3, n4);
                } else if (pixels.getBytesPerComponent() == 1) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer.rewind();
                    byte[] byArray = byteBuffer.array();
                    l = this._createNativeCursorBytes(n, n2, byArray, n3, n4);
                }
            } else {
                buffer.rewind();
                l = this._createNativeCursorDirect(n, n2, buffer, buffer.capacity(), n3, n4);
            }
        }
        return l;
    }

    void set() {
        int n;
        if (this.ptr != 0L) {
            this._setNativeCursor(this.ptr);
        }
        if ((n = this.getType()) == -1) {
            ((LensApplication)Application.GetApplication()).staticCursor_setVisible(false);
        } else {
            ((LensApplication)Application.GetApplication()).staticCursor_setVisible(true);
        }
    }

    static void setVisible_impl(boolean bl) {
        LensCursor._setVisible(bl);
    }

    static Size getBestSize_impl(int n, int n2) {
        return new Size(16, 16);
    }

    private native void _setNativeCursor(long var1);

    private native void _releaseNativeCursor(long var1);

    private native long _createNativeCursorByType(int var1);

    private native long _createNativeCursorInts(int var1, int var2, int[] var3, int var4, int var5);

    private native long _createNativeCursorBytes(int var1, int var2, byte[] var3, int var4, int var5);

    private native long _createNativeCursorDirect(int var1, int var2, Buffer var3, int var4, int var5, int var6);

    private static native void _setVisible(boolean var0);
}

