/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.lens.LensView;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class LensTouchInputSupport {
    private static final int touchTapRadius = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("lens.input.touch.TapRadius", 20);
        }
    });
    private static final int touchMoveSensitivity = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("lens.input.touch.MoveSensitivity", 20);
        }
    });
    private static final boolean pruneInputDevices = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("lens.input.pruneDevices");
        }
    });
    private static final boolean useMultiTouch = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.javafx.experimental.embedded.multiTouch");
        }
    });
    private static final boolean enableDeviceTrace = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("lens.input.trace");
        }
    });
    private static final GestureSupport gestures = new GestureSupport(false);
    private static final TouchInputSupport touches = new TouchInputSupport(gestures.createTouchCountListener(), false);

    LensTouchInputSupport() {
    }

    static void postTouchEvent(LensView lensView, int n, long l, int n2, int n3, int n4, int n5) {
        touches.notifyBeginTouchEvent(lensView, 0, true, 1);
        touches.notifyNextTouchEvent(lensView, n, l, n2, n3, n4, n5);
        touches.notifyEndTouchEvent(lensView);
    }

    static void postMultiTouchEvent(LensView lensView, int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, int n, int n2) {
        touches.notifyBeginTouchEvent(lensView, 0, true, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            touches.notifyNextTouchEvent(lensView, nArray[i], lArray[i], nArray2[i] + n, nArray3[i] + n2, nArray2[i], nArray3[i]);
        }
        touches.notifyEndTouchEvent(lensView);
    }
}

