/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.lens.LensApplication;
import com.sun.glass.ui.lens.LensCursor;
import com.sun.glass.ui.lens.LensLogger;
import com.sun.glass.ui.lens.LensView;
import java.util.List;

final class LensWindow
extends Window {
    protected LensWindow(Window window, Screen screen, int n) {
        super(window, screen, n);
    }

    protected LensWindow(long l) {
        super(l);
    }

    @Override
    protected void _toFront(long l) {
        List<Window> list = LensWindow.getWindowsClone();
        this.raiseOwnedWindows(list);
    }

    @Override
    protected void _toBack(long l) {
        LensWindow.remove(this);
        LensWindow.addFirst(this);
        this._toBackImpl(l);
    }

    private void raiseOwnedWindows(List<Window> list) {
        LensWindow.remove(this);
        LensWindow.add(this);
        this._toFrontImpl(this.getRawHandle());
        for (Window window : list) {
            if (!this.equals(window.getOwner())) continue;
            ((LensWindow)window).raiseOwnedWindows(list);
        }
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
        int n7;
        int n8;
        boolean bl3 = false;
        boolean bl4 = bl || bl2;
        boolean bl5 = false;
        if (!bl && !bl2 && n3 < 0 && n4 < 0 && n5 < 0 && n6 < 0) {
            return;
        }
        LensLogger.getLogger().fine("_setBounds x=" + n + " y=" + n2 + " xSet=" + bl + " ySet=" + bl2 + " w=" + n3 + " h=" + n4 + " cw=" + n5 + " ch=" + n6 + " xGravity=" + f + " yGravity=" + f2);
        if (bl4) {
            if (!bl) {
                n = this.getX();
            }
            if (!bl2) {
                n2 = this.getY();
            }
        }
        if (n3 > 0) {
            n8 = n3;
            bl5 = true;
        } else if (n5 > 0) {
            n8 = n5;
            bl3 = true;
            bl5 = true;
        } else {
            n8 = this.getWidth();
        }
        if (n4 > 0) {
            n7 = n4;
            bl5 = true;
        } else if (n5 > 0) {
            n7 = n6;
            bl3 = true;
            bl5 = true;
        } else {
            n7 = this.getHeight();
        }
        this.setBoundsImpl(l, n, n2, n8, n7, bl4, bl5, bl3);
    }

    @Override
    protected native long _createWindow(long var1, long var3, int var5);

    @Override
    protected native long _createChildWindow(long var1);

    @Override
    protected native boolean _close(long var1);

    private native boolean attachViewToWindow(long var1, long var3);

    @Override
    protected boolean _setView(long l, View view) {
        boolean bl = false;
        LensLogger.getLogger().info("set view " + view + ", visible=" + this.isVisible());
        long l2 = view == null ? 0L : view.getNativeView();
        bl = this.attachViewToWindow(l, l2);
        if (view != null && bl) {
            ((LensView)view)._notifyResize(this.getWidth(), this.getHeight());
        }
        return bl;
    }

    @Override
    public long getNativeWindow() {
        return this._getNativeWindowImpl(super.getNativeWindow());
    }

    private native long _getNativeWindowImpl(long var1);

    @Override
    protected boolean _setMenubar(long l, long l2) {
        return true;
    }

    @Override
    protected native boolean _minimize(long var1, boolean var3);

    @Override
    protected native boolean _maximize(long var1, boolean var3, boolean var4);

    private native void setBoundsImpl(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, boolean var9);

    @Override
    protected native boolean _setVisible(long var1, boolean var3);

    @Override
    protected native boolean _setResizable(long var1, boolean var3);

    @Override
    protected native boolean _requestFocus(long var1, int var3);

    @Override
    protected native void _setFocusable(long var1, boolean var3);

    @Override
    protected native boolean _setTitle(long var1, String var3);

    @Override
    protected native void _setLevel(long var1, int var3);

    @Override
    protected native void _setAlpha(long var1, float var3);

    @Override
    protected native boolean _setBackground(long var1, float var3, float var4, float var5);

    @Override
    protected native void _setEnabled(long var1, boolean var3);

    @Override
    protected native boolean _setMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMaximumSize(long var1, int var3, int var4);

    @Override
    protected native void _setIcon(long var1, Pixels var3);

    private native void _toFrontImpl(long var1);

    private native void _toBackImpl(long var1);

    @Override
    protected native boolean _grabFocus(long var1);

    @Override
    protected native void _ungrabFocus(long var1);

    @Override
    protected void _enterModal(long l) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    @Override
    protected void _enterModalWithWindow(long l, long l2) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    @Override
    protected void _exitModal(long l) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    protected void _notifyClose() {
        this.notifyClose();
        this.close();
    }

    protected void _notifyDestroy() {
        this.notifyDestroy();
    }

    protected void _notifyFocus(int n) {
        this.notifyFocus(n);
    }

    protected void _notifyMove(int n, int n2) {
        this.notifyMove(n, n2);
    }

    protected void _notifyResize(int n, int n2, int n3) {
        this.notifyResize(n, n2, n3);
        LensView lensView = (LensView)this.getView();
        if (lensView != null) {
            lensView._notifyResize(n2, n3);
        }
    }

    protected void _notifyExpose(int n, int n2, int n3, int n4) {
        LensView lensView = (LensView)this.getView();
        if (lensView != null) {
            lensView._notifyRepaint(n, n2, n3, n4);
        }
    }

    protected void _notifyFocusUngrab() {
        this.notifyFocusUngrab();
    }

    protected void _notifyFocusDisabled() {
        this.notifyFocusDisabled();
    }

    protected void nativeExpose(int n, int n2, int n3, int n4) {
        if (Application.isEventThread()) {
            this._notifyExpose(n, n2, n3, n4);
        } else {
            ((LensApplication)Application.GetApplication()).windowExpose(this, n, n2, n3, n4);
        }
    }

    protected void nativeConfigure(int n, int n2, int n3, int n4, int n5) {
        LensApplication lensApplication = (LensApplication)Application.GetApplication();
        if (Application.isEventThread()) {
            if (n2 != this.getX() || n3 != this.getY()) {
                this._notifyMove(n2, n3);
            }
            if (n4 != this.getWidth() || n5 != this.getHeight()) {
                this._notifyResize(n, n4, n5);
            }
        } else {
            if (n2 != this.getX() || n3 != this.getY()) {
                lensApplication.notifyWindowMove(this, n2, n3);
            }
            if (n4 != this.getWidth() || n5 != this.getHeight()) {
                lensApplication.notifyWindowResize(this, n, n4, n5);
            }
        }
    }

    protected void nativeClose() {
        LensApplication lensApplication = (LensApplication)Application.GetApplication();
        lensApplication.notifyWindowEvent(this, 521);
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
        ((LensCursor)cursor).set();
    }

    @Override
    protected int _getEmbeddedX(long l) {
        return 0;
    }

    @Override
    protected int _getEmbeddedY(long l) {
        return 0;
    }

    @Override
    protected void _requestInput(long l, String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

