/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.accessible;

import com.sun.javafx.Logging;
import com.sun.javafx.accessible.AccessibleNode;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.providers.AccessibleStageProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import com.sun.javafx.accessible.utils.Rect;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import sun.util.logging.PlatformLogger;

public class AccessibleStage
implements AccessibleProvider,
AccessibleStageProvider {
    Stage stage;
    Scene scene;
    Object accRoot;
    List<AccessibleNode> accChildren;

    public AccessibleStage(Stage stage) {
        this.stage = stage;
        this.scene = stage.getScene();
        this.initialize();
    }

    private void initialize() {
        Parent parent = this.scene.getRoot();
        this.accRoot = this.stage.impl_getPeer().accessibleCreateStageProvider(this);
        AccessibleNode accessibleNode = new AccessibleNode((Node)parent.getChildrenUnmodifiable().get(0));
        try {
            this.initAccessibleHierarchy(parent, accessibleNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.accChildren = accessibleNode.children;
        for (int i = 0; i < this.accChildren.size(); ++i) {
            this.accChildren.get((int)i).parent = null;
        }
        this.scene.getRoot().getChildrenUnmodifiable().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> change) {
            }
        });
    }

    void destroyHierarchy(List<AccessibleNode> list) {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        for (int i = 0; i < list.size(); ++i) {
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "destroyHierarchy: idx=" + i + list.get(i));
            }
            if (list.get((int)i).children.size() > 0) {
                if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                    platformLogger.finer(this.toString() + "destroyHierarchy: Has Children" + list.get((int)i).children);
                }
                this.destroyHierarchy(list.get((int)i).children);
            }
            this.stage.impl_getPeer().accessibleDestroyBasicProvider(list.get((int)i).accElement);
        }
    }

    void printAccHierarchy(List<AccessibleNode> list) {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        for (int i = 0; i < list.size(); ++i) {
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "printAccHierarchy: idx=" + i + list.get(i));
            }
            if (list.get((int)i).children.size() <= 0) continue;
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "printAccHierarchy: Has Children" + list.get((int)i).children);
            }
            this.printAccHierarchy(list.get((int)i).children);
        }
    }

    private void initAccessibleHierarchy(Parent parent, AccessibleNode accessibleNode) throws ClassNotFoundException {
        int n;
        ArrayList<AccessibleNode> arrayList = new ArrayList<AccessibleNode>();
        AccessibleNode accessibleNode2 = null;
        ObservableList<Node> observableList = parent.getChildrenUnmodifiable();
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer(this.toString() + "initAccessibleHierarchy1: pRoot=" + parent + " parent=" + accessibleNode);
        }
        if (observableList.isEmpty()) {
            if (platformLogger.isLoggable(PlatformLogger.Level.FINEST)) {
                platformLogger.finer(this.toString() + "initAccessibleHierarchy: no child, pRoot=" + parent);
            }
            return;
        }
        for (n = 0; n < observableList.size(); ++n) {
            Node node = (Node)observableList.get(n);
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "initAccessibleHierarchy: idx=" + n + " node= " + node);
            }
            try {
                accessibleNode2 = (AccessibleNode)node.impl_getAccessible();
                if (accessibleNode2 != null) {
                    if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                        platformLogger.finer(this.toString() + "initAccessibleHierarchy: Found Accessible.");
                        platformLogger.finer(this.toString() + "  node= " + node + " curaccNode=" + accessibleNode2);
                        platformLogger.finer(this.toString() + "  control type=" + accessibleNode2.getPropertyValue(30003));
                    }
                    accessibleNode2.accElement = this.stage.impl_getPeer().accessibleCreateBasicProvider(accessibleNode2);
                    accessibleNode2.accController = this;
                    arrayList.add(accessibleNode2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(node instanceof Parent)) continue;
            if (accessibleNode2 == null) {
                accessibleNode2 = accessibleNode;
            }
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "initAccessibleHierarchy: idx=" + n + " accNode.children= " + accessibleNode2);
            }
            try {
                this.initAccessibleHierarchy((Parent)node, accessibleNode2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!arrayList.isEmpty()) {
            if (!accessibleNode.children.isEmpty()) {
                accessibleNode.children.addAll(arrayList);
            } else {
                accessibleNode.children = arrayList;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ((AccessibleNode)arrayList.get((int)n)).parent = accessibleNode;
            }
        }
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer(this.toString() + "initAccessibleHierarchy: parent.children= " + accessibleNode.children);
        }
    }

    private void setParent(List<AccessibleNode> list) {
        if (list.size() <= 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).children.size() <= 0) continue;
            list.get((int)i).parent = list.get(i);
            this.setParent(list.get((int)i).children);
        }
    }

    @Override
    public AccessibleProvider hostRawElementProvider() {
        return this;
    }

    @Override
    public Object getPatternProvider(int n) {
        return this;
    }

    @Override
    public Object getPropertyValue(int n) {
        if (n == 30005) {
            return this.stage.getTitle();
        }
        return null;
    }

    @Override
    public Rect boundingRectangle() {
        double d = Screen.getPrimary().getBounds().getMinX() + this.stage.getX() + this.scene.getX();
        double d2 = Screen.getPrimary().getBounds().getMinY() + this.stage.getY() + this.scene.getY();
        return new Rect(d, d2, this.scene.getWidth(), this.scene.getHeight());
    }

    @Override
    public Object fragmentRoot() {
        return this.accRoot;
    }

    @Override
    public AccessibleProvider[] getEmbeddedFragmentRoots() {
        return null;
    }

    @Override
    public int[] getRuntimeId() {
        return null;
    }

    @Override
    public Object navigate(NavigateDirection navigateDirection) {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer("this: " + this.toString());
            platformLogger.finer("navigate direction: " + (Object)((Object)navigateDirection));
        }
        AccessibleNode accessibleNode = null;
        switch (navigateDirection) {
            case Parent: 
            case NextSibling: 
            case PreviousSibling: {
                return accessibleNode;
            }
            case FirstChild: {
                if (this.accChildren.size() <= 0) break;
                accessibleNode = this.accChildren.get(0);
                break;
            }
            case LastChild: {
                if (this.accChildren.size() <= 0) break;
                accessibleNode = this.accChildren.get(this.accChildren.size() - 1);
            }
        }
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer("returning: " + accessibleNode.accElement);
        }
        return accessibleNode.accElement;
    }

    @Override
    public void setFocus() {
        this.stage.getScene().getRoot().requestFocus();
    }

    private AccessibleNode getProviderFromPoint(List<AccessibleNode> list, double d, double d2) {
        double d3;
        if (list.get((int)0).children.size() == 0) {
            d3 = d2 - list.get(0).boundingRectangle().getMaxY();
            if (list.get(0).contains(d, d3)) {
                return list.get(0);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            d3 = d2 - list.get(i).boundingRectangle().getMaxY();
            if (list.get(i).contains(d, d3)) {
                return list.get(i);
            }
            if (list.get((int)i).children.size() <= 0) continue;
            this.getProviderFromPoint(list.get((int)i).children, d, d2);
        }
        return null;
    }

    @Override
    public Object elementProviderFromPoint(double d, double d2) {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        AccessibleNode accessibleNode = this.getProviderFromPoint(this.accChildren, d, d2);
        if (accessibleNode != null) {
            if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                platformLogger.finer(this.toString() + "Accessible Stage: elementProviderFromPoint x=" + d + " y=" + d2 + "Node" + accessibleNode.accElement);
            }
            Object object = accessibleNode.getAccessibleElement();
            return object;
        }
        return null;
    }

    @Override
    public Object getFocus() {
        Node node = this.stage.getScene().getFocusOwner();
        try {
            Method method = node.getClass().getMethod("impl_getAccessible", new Class[0]);
            AccessibleProvider accessibleProvider = (AccessibleProvider)method.invoke((Object)node, new Object[0]);
            if (accessibleProvider instanceof AccessibleNode) {
                return ((AccessibleNode)accessibleProvider).accElement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object getStageAccessible() {
        return this.accRoot;
    }
}

