/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.FontFace;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SelectorPartitioning;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import sun.util.logging.PlatformLogger;

public final class StyleManager {
    private static PlatformLogger LOGGER;
    private static final Map<Scene, CacheContainer> cacheContainerMap;
    private final List<StylesheetContainer> userAgentStylesheets = new ArrayList<StylesheetContainer>();
    private final Map<String, StylesheetContainer> stylesheetContainerMap = new HashMap<String, StylesheetContainer>();
    Map<String, Image> imageCache = new HashMap<String, Image>();
    private Key key = null;
    private static ObservableList<CssError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Deprecated
    public static List<CssMetaData<? extends Styleable, ?>> getStyleables(Styleable styleable) {
        return styleable != null ? styleable.getCssMetaData() : Collections.emptyList();
    }

    @Deprecated
    public static List<CssMetaData<? extends Styleable, ?>> getStyleables(Node node) {
        return node != null ? node.getCssMetaData() : Collections.emptyList();
    }

    private StyleManager() {
    }

    private CacheContainer getCacheContainer(Styleable styleable) {
        Object object;
        if (styleable == null) {
            return null;
        }
        Scene scene = null;
        if (styleable instanceof Node) {
            object = (Node)styleable;
            scene = ((Node)object).getScene();
        } else if (styleable instanceof Window) {
            scene = ((Window)((Object)styleable)).getScene();
        }
        object = cacheContainerMap.get(scene);
        if (object == null) {
            object = new CacheContainer();
            cacheContainerMap.put(scene, (CacheContainer)object);
        }
        return object;
    }

    public StyleCache getSharedCache(Styleable styleable, StyleCache.Key key) {
        CacheContainer cacheContainer = this.getCacheContainer(styleable);
        if (cacheContainer == null) {
            return null;
        }
        Map map = cacheContainer.getStyleCache();
        if (map == null) {
            return null;
        }
        StyleCache styleCache = (StyleCache)map.get(key);
        if (styleCache == null) {
            styleCache = new StyleCache();
            map.put(new StyleCache.Key(key), styleCache);
        }
        return styleCache;
    }

    public StyleMap getStyleMap(Styleable styleable, int n) {
        if (n == -1) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(styleable);
        if (cacheContainer == null) {
            return StyleMap.EMPTY_MAP;
        }
        return cacheContainer.getStyleMap(n);
    }

    public void forget(Scene scene) {
        CacheContainer cacheContainer = cacheContainerMap.remove(scene);
        if (cacheContainer != null) {
            cacheContainer.clearCache();
        }
        Set<Map.Entry<String, StylesheetContainer>> set = this.stylesheetContainerMap.entrySet();
        Iterator<Map.Entry<String, StylesheetContainer>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Reference reference;
            Map.Entry<String, StylesheetContainer> entry = iterator.next();
            StylesheetContainer stylesheetContainer = entry.getValue();
            Iterator iterator2 = stylesheetContainer.sceneUsers.list.iterator();
            while (iterator2.hasNext()) {
                reference = iterator2.next();
                object = (Scene)reference.get();
                if (object != scene && object != null) continue;
                iterator2.remove();
            }
            reference = stylesheetContainer.parentUsers.list.iterator();
            while (reference.hasNext()) {
                object = (Reference)reference.next();
                Parent parent = (Parent)((Reference)object).get();
                if (parent != null && parent.getScene() != scene && parent.getScene() != null) continue;
                reference.remove();
            }
            if (!stylesheetContainer.sceneUsers.list.isEmpty() || !stylesheetContainer.parentUsers.list.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void stylesheetsChanged(Scene scene, ListChangeListener.Change<String> change) {
        List<String> list;
        boolean bl = false;
        boolean bl2 = scene.getWindow() instanceof PopupWindow;
        change.reset();
        block0: while (change.next()) {
            Object object;
            Object object2;
            StylesheetContainer stylesheetContainer;
            String string;
            int n;
            int n2;
            if (!bl2 && change.wasAdded()) {
                list = change.getAddedSubList();
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    string = list.get(n);
                    bl = true;
                    stylesheetContainer = this.stylesheetContainerMap.get(string);
                    if (stylesheetContainer != null && stylesheetContainer.sceneUsers != null && stylesheetContainer.sceneUsers.list != null) {
                        object2 = stylesheetContainer.sceneUsers.list.iterator();
                        while (object2.hasNext()) {
                            Reference reference = (Reference)object2.next();
                            object = (Scene)reference.get();
                            if (object == scene) {
                                bl = false;
                                break;
                            }
                            if (object != null) continue;
                            object2.remove();
                        }
                    }
                    if (bl) continue block0;
                }
                continue;
            }
            if (!change.wasRemoved()) continue;
            if (!bl2) {
                bl = true;
                break;
            }
            list = change.getRemoved();
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                string = list.get(n);
                stylesheetContainer = this.stylesheetContainerMap.get(string);
                if (stylesheetContainer == null) continue;
                object2 = stylesheetContainer.sceneUsers.list;
                for (int i = object2.size() - 1; 0 <= i; --i) {
                    Scene scene2;
                    object = (Reference)object2.get(i);
                    Scene scene3 = scene2 = object != null ? (Scene)((Reference)object).get() : null;
                    if (scene2 != scene) continue;
                    object2.remove(i);
                    break;
                }
                if (!object2.isEmpty()) continue;
                this.stylesheetContainerMap.remove(string);
            }
        }
        if (!bl2) {
            if (bl && (list = cacheContainerMap.get(scene)) != null) {
                ((CacheContainer)list).clearCache();
            }
            this.processChange(change);
        }
    }

    public void stylesheetsChanged(Parent parent, ListChangeListener.Change<String> change) {
        this.processChange(change);
    }

    private void processChange(ListChangeListener.Change<String> change) {
        change.reset();
        while (change.next()) {
            if (!change.wasRemoved()) continue;
            List<String> list = change.getRemoved();
            int n = list != null ? list.size() : 0;
            for (int i = 0; i < n; ++i) {
                String string = list.get(i);
                StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.remove(string);
                if (stylesheetContainer == null) continue;
                this.clearCache(stylesheetContainer);
                if (stylesheetContainer.selectorPartitioning == null) continue;
                stylesheetContainer.selectorPartitioning.reset();
            }
        }
    }

    private void clearCache(StylesheetContainer stylesheetContainer) {
        EventTarget eventTarget;
        Reference reference;
        int n;
        if (stylesheetContainer == null) {
            return;
        }
        this.cleanUpImageCache(stylesheetContainer.fname);
        List list = stylesheetContainer.sceneUsers.list;
        List list2 = stylesheetContainer.parentUsers.list;
        for (n = list.size() - 1; 0 <= n; --n) {
            reference = list.remove(n);
            eventTarget = (Scene)reference.get();
            reference.clear();
            if (eventTarget == null) continue;
            ((Scene)eventTarget).getRoot().impl_reapplyCSS();
        }
        for (n = list2.size() - 1; 0 <= n; --n) {
            reference = list2.remove(n);
            eventTarget = (Parent)reference.get();
            reference.clear();
            if (eventTarget == null || ((Node)eventTarget).getScene() == null) continue;
            ((Node)eventTarget).impl_reapplyCSS();
        }
    }

    public Image getCachedImage(String string) {
        Image image;
        block8: {
            image = null;
            if (this.imageCache.containsKey(string)) {
                image = this.imageCache.get(string);
            } else {
                try {
                    image = new Image(string);
                    if (image.isError()) {
                        PlatformLogger platformLogger = StyleManager.getLogger();
                        if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                            platformLogger.warning("Error loading image: " + string);
                        }
                        image = null;
                    }
                    this.imageCache.put(string, image);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PlatformLogger platformLogger = StyleManager.getLogger();
                    if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                        platformLogger.warning(illegalArgumentException.getLocalizedMessage());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    PlatformLogger platformLogger = StyleManager.getLogger();
                    if (platformLogger == null || !platformLogger.isLoggable(PlatformLogger.Level.WARNING)) break block8;
                    platformLogger.warning(nullPointerException.getLocalizedMessage());
                }
            }
        }
        return image;
    }

    private void cleanUpImageCache(String string) {
        if (string == null && this.imageCache.isEmpty()) {
            return;
        }
        if (string.trim().isEmpty()) {
            return;
        }
        int n = string.lastIndexOf(47);
        String string2 = n > 0 ? string.substring(0, n) : string;
        int n2 = string2.length();
        String[] stringArray = new String[this.imageCache.size()];
        int n3 = 0;
        Set<Map.Entry<String, Image>> set = this.imageCache.entrySet();
        for (Map.Entry<String, Image> entry : set) {
            String string3 = entry.getKey();
            n = string3.lastIndexOf(47);
            String string4 = n > 0 ? string3.substring(0, n) : string3;
            int n4 = string4.length();
            boolean bl = n4 > n2 ? string4.startsWith(string2) : string2.startsWith(string4);
            if (!bl) continue;
            stringArray[n3++] = string3;
        }
        for (int i = 0; i < n3; ++i) {
            Map.Entry<String, Image> entry;
            entry = this.imageCache.remove(stringArray[i]);
        }
    }

    private static URL getURL(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            URI uRI = new URI(string.trim());
            if (!uRI.isAbsolute()) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string2 = uRI.getPath();
                URL uRL = null;
                uRL = string2.startsWith("/") ? classLoader.getResource(string2.substring(1)) : classLoader.getResource(string2);
                return uRL;
            }
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static Stylesheet loadStylesheet(final String string) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(string);
        }
        catch (AccessControlException accessControlException) {
            if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                StyleManager.getLogger().info("Could not load the stylesheet, trying with FilePermissions : " + string);
            }
            if (string.length() < 7 && string.indexOf("!/") < string.length() - 7) {
                return null;
            }
            try {
                String string2;
                String string3;
                URI uRI;
                String string4;
                URI uRI2 = new URI(string);
                if ("jar".equals(uRI2.getScheme()) && (string4 = (uRI = AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){

                    @Override
                    public URI run() throws URISyntaxException, PrivilegedActionException {
                        return StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                    }
                })).getSchemeSpecificPart()).equals(string3 = (string2 = uRI2.getSchemeSpecificPart()).substring(string2.indexOf(47), string2.indexOf("!/")))) {
                    String string5 = string.substring(string.indexOf("!/") + 2);
                    if (string.endsWith(".css") || string.endsWith(".bss")) {
                        JarEntry jarEntry;
                        FilePermission filePermission = new FilePermission(string4, "read");
                        PermissionCollection permissionCollection = filePermission.newPermissionCollection();
                        permissionCollection.add(filePermission);
                        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                        JarFile jarFile = null;
                        try {
                            jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                                @Override
                                public JarFile run() throws FileNotFoundException, IOException {
                                    return new JarFile(string4);
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            return null;
                        }
                        if (jarFile != null && (jarEntry = jarFile.getJarEntry(string5)) != null) {
                            return AccessController.doPrivileged(new PrivilegedAction<Stylesheet>(){

                                @Override
                                public Stylesheet run() {
                                    return StyleManager.loadStylesheetUnPrivileged(string);
                                }
                            }, accessControlContext);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    private static Stylesheet loadStylesheetUnPrivileged(final String string) {
        block18: {
            Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String string2 = System.getProperty("binary.css");
                    return !string.endsWith(".bss") && string2 != null ? !Boolean.valueOf(string2).booleanValue() : Boolean.FALSE;
                }
            });
            try {
                Object object;
                String string2 = bl != false ? ".css" : ".bss";
                URL uRL = null;
                Stylesheet stylesheet = null;
                if (!string.endsWith(".css") && !string.endsWith(".bss")) {
                    uRL = StyleManager.getURL(string);
                    bl = true;
                } else {
                    object = string.substring(0, string.length() - 4);
                    uRL = StyleManager.getURL((String)object + string2);
                    if (uRL == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                        uRL = StyleManager.getURL((String)object + ".css");
                    }
                    if (uRL != null && !bl.booleanValue() && (stylesheet = Stylesheet.loadBinary(uRL)) == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                        uRL = StyleManager.getURL(string);
                    }
                }
                if (uRL != null && bl.booleanValue()) {
                    stylesheet = CSSParser.getInstance().parse(uRL);
                }
                if (stylesheet == null) {
                    if (errors != null) {
                        object = new CssError("Resource \"" + string + "\" not found.");
                        errors.add((CssError)object);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                        StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", string));
                    }
                }
                if (stylesheet != null) {
                    block3: for (FontFace fontFace : stylesheet.getFontFaces()) {
                        for (FontFace.FontFaceSrc fontFaceSrc : fontFace.getSources()) {
                            if (fontFaceSrc.getType() != FontFace.FontFaceSrcType.URL) continue;
                            Font font = Font.loadFont(fontFaceSrc.getSrc(), 10.0);
                            if (font != null) {
                                StyleManager.getLogger().info("Loaded @font-face font [" + font.getName() + "]");
                                continue block3;
                            }
                            StyleManager.getLogger().info("Could not load @font-face font [" + fontFaceSrc.getSrc() + "]");
                            continue block3;
                        }
                    }
                }
                return stylesheet;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (errors != null) {
                    CssError cssError = new CssError("Stylesheet \"" + string + "\" not found.");
                    errors.add(cssError);
                }
                if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                    StyleManager.getLogger().info("Could not find stylesheet: " + string);
                }
            }
            catch (IOException iOException) {
                if (errors != null) {
                    CssError cssError = new CssError("Could not load stylesheet: " + string);
                    errors.add(cssError);
                }
                if (!StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) break block18;
                StyleManager.getLogger().info("Could not load stylesheet: " + string);
            }
        }
        return null;
    }

    private int getIndex(String string) {
        int n = this.userAgentStylesheets.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            StylesheetContainer stylesheetContainer = this.userAgentStylesheets.get(i);
            if (stylesheetContainer == null || !((string2 = stylesheetContainer.fname) == null ? string == null : string2.equals(string))) continue;
            return i;
        }
        return -1;
    }

    public void addUserAgentStylesheet(String string) {
        this.addUserAgentStylesheet(null, string);
    }

    public void addUserAgentStylesheet(Scene scene, String string) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        int n = this.getIndex(string);
        if (n > -1) {
            return;
        }
        CssError.setCurrentScene(scene);
        if (this.userAgentStylesheets.isEmpty()) {
            this.userAgentStylesheets.add(null);
        }
        Stylesheet stylesheet = StyleManager.loadStylesheet(string);
        this.userAgentStylesheets.add(new StylesheetContainer(string, stylesheet));
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
        }
        CssError.setCurrentScene(null);
    }

    public void addUserAgentStylesheet(Scene scene, Stylesheet stylesheet) {
        CssError.setCurrentScene(scene);
        if (this.userAgentStylesheets.isEmpty()) {
            this.userAgentStylesheets.add(null);
        }
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            String string = stylesheet.getUrl();
            this.userAgentStylesheets.add(new StylesheetContainer(string != null ? string : "", stylesheet));
            this.userAgentStylesheetsChanged();
        }
        CssError.setCurrentScene(null);
    }

    public void setDefaultUserAgentStylesheet(String string) {
        this.setDefaultUserAgentStylesheet(null, string);
    }

    public void setDefaultUserAgentStylesheet(Scene scene, String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("null arg fname");
        }
        int n = this.getIndex(string);
        if (n != -1) {
            if (n > 0) {
                StylesheetContainer stylesheetContainer = this.userAgentStylesheets.get(n);
                this.userAgentStylesheets.remove(n);
                this.userAgentStylesheets.set(0, stylesheetContainer);
            }
            return;
        }
        CssError.setCurrentScene(scene);
        Stylesheet stylesheet = StyleManager.loadStylesheet(string);
        StylesheetContainer stylesheetContainer = new StylesheetContainer(string, stylesheet);
        if (this.userAgentStylesheets.isEmpty()) {
            this.userAgentStylesheets.add(stylesheetContainer);
        } else {
            this.userAgentStylesheets.set(0, stylesheetContainer);
        }
        if (stylesheet != null) {
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
        }
        CssError.setCurrentScene(null);
    }

    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String string = stylesheet.getUrl();
        String string2 = string != null ? string : "";
        int n = this.getIndex(string2);
        if (n != -1) {
            if (n > 0) {
                StylesheetContainer stylesheetContainer = this.userAgentStylesheets.get(n);
                this.userAgentStylesheets.remove(n);
                this.userAgentStylesheets.set(0, stylesheetContainer);
            }
            return;
        }
        StylesheetContainer stylesheetContainer = new StylesheetContainer(string2, stylesheet);
        if (this.userAgentStylesheets.isEmpty()) {
            this.userAgentStylesheets.add(stylesheetContainer);
        } else {
            this.userAgentStylesheets.set(0, stylesheetContainer);
        }
        stylesheet.setOrigin(StyleOrigin.USER_AGENT);
        this.userAgentStylesheetsChanged();
    }

    private void userAgentStylesheetsChanged() {
        for (CacheContainer object : cacheContainerMap.values()) {
            object.clearCache();
        }
        StyleConverterImpl.clearCache();
        for (Scene scene : cacheContainerMap.keySet()) {
            if (scene == null) continue;
            scene.getRoot().impl_reapplyCSS();
        }
    }

    private List<StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> list = parent.impl_getAllParentStylesheets();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StylesheetContainer> arrayList = new ArrayList<StylesheetContainer>();
        CssError.setCurrentScene(parent.getScene());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            StylesheetContainer stylesheetContainer = null;
            if (this.stylesheetContainerMap.containsKey(string)) {
                stylesheetContainer = this.stylesheetContainerMap.get(string);
                stylesheetContainer.parentUsers.add(parent);
            } else {
                Stylesheet stylesheet = StyleManager.loadStylesheet(string);
                stylesheetContainer = new StylesheetContainer(string, stylesheet);
                stylesheetContainer.parentUsers.add(parent);
                this.stylesheetContainerMap.put(string, stylesheetContainer);
            }
            if (stylesheetContainer == null) continue;
            arrayList.add(stylesheetContainer);
        }
        CssError.setCurrentScene(null);
        return arrayList;
    }

    private List<StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList<String> observableList = scene.getStylesheets();
        if (observableList == null || observableList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StylesheetContainer> arrayList = new ArrayList<StylesheetContainer>(observableList.size());
        CssError.setCurrentScene(scene);
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)observableList.get(i);
            StylesheetContainer stylesheetContainer = null;
            if (this.stylesheetContainerMap.containsKey(string)) {
                stylesheetContainer = this.stylesheetContainerMap.get(string);
                stylesheetContainer.sceneUsers.add(scene);
            } else {
                Stylesheet stylesheet = StyleManager.loadStylesheet(string);
                stylesheetContainer = new StylesheetContainer(string, stylesheet);
                stylesheetContainer.sceneUsers.add(scene);
                this.stylesheetContainerMap.put(string, stylesheetContainer);
            }
            if (stylesheetContainer == null) continue;
            arrayList.add(stylesheetContainer);
        }
        CssError.setCurrentScene(null);
        return arrayList;
    }

    private static Node nodeWithInlineStyles(Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            String string = node2.getStyle();
            if (string == null || string.isEmpty()) continue;
            return node2;
        }
        return null;
    }

    public StyleMap findMatchingStyles(Node node, Set<PseudoClass>[] setArray) {
        Object object;
        boolean bl;
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(node);
        if (cacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Parent parent = node instanceof Parent ? (Parent)node : node.getParent();
        List<StylesheetContainer> list = this.gatherParentStylesheets(parent);
        boolean bl2 = !list.isEmpty();
        List<StylesheetContainer> list2 = this.gatherSceneStylesheets(scene);
        boolean bl3 = !list2.isEmpty();
        String string = node.getStyle();
        boolean bl4 = bl = string != null && !string.trim().isEmpty();
        if (!bl && !bl2 && !bl3 && this.userAgentStylesheets.isEmpty()) {
            return StyleMap.EMPTY_MAP;
        }
        String string2 = node.getClass().getName();
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(n + 1);
        String string4 = node.getId();
        ObservableList<String> observableList = node.getStyleClass();
        if (this.key == null) {
            this.key = new Key();
        }
        this.key.className = string3;
        this.key.id = string4;
        int n2 = observableList.size();
        for (int i = 0; i < n2; ++i) {
            object = (String)observableList.get(i);
            if (object == null || ((String)object).isEmpty()) continue;
            this.key.styleClasses.add(StyleClassSet.getStyleClass((String)object));
        }
        Map map = cacheContainer.getCacheMap(list);
        Cache cache = (Cache)map.get(this.key);
        if (cache != null) {
            this.key.styleClasses.clear();
        } else {
            List<Selector> list3;
            StylesheetContainer stylesheetContainer;
            int n3;
            int n4;
            object = new ArrayList();
            if (!this.userAgentStylesheets.isEmpty()) {
                n4 = this.userAgentStylesheets.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    stylesheetContainer = this.userAgentStylesheets.get(n3);
                    if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                    list3 = stylesheetContainer.selectorPartitioning.match(string4, string3, this.key.styleClasses);
                    object.addAll(list3);
                }
            }
            if (!list2.isEmpty()) {
                n4 = list2.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    stylesheetContainer = list2.get(n3);
                    if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                    stylesheetContainer.keys.add(this.key);
                    list3 = stylesheetContainer.selectorPartitioning.match(string4, string3, this.key.styleClasses);
                    object.addAll(list3);
                }
            }
            if (bl2) {
                n3 = list == null ? 0 : list.size();
                for (n4 = 0; n4 < n3; ++n4) {
                    stylesheetContainer = list.get(n4);
                    stylesheetContainer.keys.add(this.key);
                    if (stylesheetContainer.selectorPartitioning == null) continue;
                    list3 = stylesheetContainer.selectorPartitioning.match(string4, string3, this.key.styleClasses);
                    object.addAll(list3);
                }
            }
            cache = new Cache((List<Selector>)object);
            map.put(this.key, cache);
            this.key = null;
        }
        object = cache.getStyleMap(cacheContainer, node, setArray, bl);
        return object;
    }

    public static ObservableList<CssError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssError> getErrors() {
        return errors;
    }

    public StyleMap createInlineStyleMap(Styleable styleable) {
        Stylesheet stylesheet = CSSParser.getInstance().parseInlineStyle(styleable);
        if (stylesheet == null) {
            return StyleMap.EMPTY_MAP;
        }
        stylesheet.setOrigin(StyleOrigin.INLINE);
        ArrayList arrayList = new ArrayList(1);
        boolean bl = false;
        List<Rule> list = stylesheet.getRules();
        List list2 = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Rule rule = list.get(i);
            if (rule == null) continue;
            List<Selector> list3 = rule.getUnobservedSelectorList();
            if (list2 == null || list3.isEmpty()) continue;
            list2.addAll(list3);
        }
        return new StyleMap(-1, list2);
    }

    static {
        cacheContainerMap = new WeakHashMap<Scene, CacheContainer>();
        errors = null;
    }

    private static class Cache {
        private final List<Selector> selectors;
        private final Map<Key, Integer> cache;

        Cache(List<Selector> list) {
            this.selectors = list;
            this.cache = new HashMap<Key, Integer>();
        }

        private StyleMap getStyleMap(CacheContainer cacheContainer, Node node, Set<PseudoClass>[] setArray, boolean bl) {
            int n;
            Selector selector;
            Object object;
            if ((this.selectors == null || this.selectors.isEmpty()) && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            int n2 = this.selectors.size();
            long[] lArray = new long[n2 / 64 + 1];
            boolean bl2 = true;
            for (int i = 0; i < n2; ++i) {
                long l;
                object = this.selectors.get(i);
                if (!((Selector)object).applies(node, setArray, 0)) continue;
                int n3 = i / 64;
                lArray[n3] = l = lArray[n3] | 1L << i;
                bl2 = false;
            }
            if (bl2 && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            String string = node.getStyle();
            object = new Key(lArray, string);
            if (this.cache.containsKey(object)) {
                Integer n4 = this.cache.get(object);
                StyleMap styleMap = n4 != null ? cacheContainer.getStyleMap(n4) : StyleMap.EMPTY_MAP;
                return styleMap;
            }
            ArrayList<Selector> arrayList = new ArrayList<Selector>();
            if (bl && (selector = cacheContainer.getInlineStyleSelector(string)) != null) {
                arrayList.add(selector);
            }
            for (n = 0; n < lArray.length; ++n) {
                if (lArray[n] == 0L) continue;
                int n5 = n * 64;
                for (int i = 0; i < 64; ++i) {
                    long l = 1L << i;
                    if ((l & lArray[n]) != l) continue;
                    Selector selector2 = this.selectors.get(n5 + i);
                    arrayList.add(selector2);
                }
            }
            n = cacheContainer.nextSmapId();
            this.cache.put((Key)object, n);
            StyleMap styleMap = new StyleMap(n, arrayList);
            cacheContainer.addStyleMap(styleMap);
            return styleMap;
        }

        private static class Key {
            final long[] key;
            final String inlineStyle;

            Key(long[] lArray, String string) {
                this.key = lArray;
                this.inlineStyle = string != null && string.trim().isEmpty() ? null : string;
            }

            public String toString() {
                return Arrays.toString(this.key) + (this.inlineStyle != null ? "* {" + this.inlineStyle + "}" : "");
            }

            public int hashCode() {
                int n = 3;
                n = 17 * n + Arrays.hashCode(this.key);
                if (this.inlineStyle != null) {
                    n = 17 * n + this.inlineStyle.hashCode();
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Key key = (Key)object;
                if (this.inlineStyle == null ? key.inlineStyle != null : !this.inlineStyle.equals(key.inlineStyle)) {
                    return false;
                }
                return Arrays.equals(this.key, key.key);
            }
        }
    }

    private static class CacheContainer {
        private Map<StyleCache.Key, StyleCache> styleCache;
        private Map<List<String>, Map<Key, Cache>> cacheMap;
        private List<StyleMap> styleMapList;
        private Map<String, Selector> inlineStylesCache;
        private int styleMapId = 0;
        private int baseStyleMapId = 0;

        private CacheContainer() {
        }

        private Map<StyleCache.Key, StyleCache> getStyleCache() {
            if (this.styleCache == null) {
                this.styleCache = new HashMap<StyleCache.Key, StyleCache>();
            }
            return this.styleCache;
        }

        private Map<Key, Cache> getCacheMap(List<StylesheetContainer> list) {
            if (this.cacheMap == null) {
                this.cacheMap = new HashMap<List<String>, Map<Key, Cache>>();
            }
            if (list == null || list.isEmpty()) {
                Map<Key, Cache> map = this.cacheMap.get(null);
                if (map == null) {
                    map = new HashMap<Key, Cache>();
                    this.cacheMap.put(null, map);
                }
                return map;
            }
            int n = list.size();
            if (cacheMapKey == null) {
                cacheMapKey = new ArrayList(n);
            }
            for (int i = 0; i < n; ++i) {
                StylesheetContainer stylesheetContainer = list.get(i);
                if (stylesheetContainer == null || stylesheetContainer.fname == null || stylesheetContainer.fname.isEmpty()) continue;
                cacheMapKey.add(stylesheetContainer.fname);
            }
            Map<Key, Cache> map = this.cacheMap.get(cacheMapKey);
            if (map == null) {
                map = new HashMap<Key, Cache>();
                this.cacheMap.put(cacheMapKey, map);
                cacheMapKey = null;
            } else {
                cacheMapKey.clear();
            }
            return map;
        }

        private List<StyleMap> getStyleMapList() {
            if (this.styleMapList == null) {
                this.styleMapList = new ArrayList<StyleMap>();
            }
            return this.styleMapList;
        }

        private int nextSmapId() {
            this.styleMapId = this.baseStyleMapId + this.getStyleMapList().size();
            return this.styleMapId;
        }

        private void addStyleMap(StyleMap styleMap) {
            assert (styleMap.getId() - this.baseStyleMapId == this.getStyleMapList().size());
            this.getStyleMapList().add(styleMap);
        }

        public StyleMap getStyleMap(int n) {
            int n2 = n - this.baseStyleMapId;
            if (0 <= n2 && n2 < this.getStyleMapList().size()) {
                return this.getStyleMapList().get(n2);
            }
            return StyleMap.EMPTY_MAP;
        }

        private void clearCache() {
            if (this.cacheMap != null) {
                this.cacheMap.clear();
            }
            if (this.styleCache != null) {
                this.styleCache.clear();
            }
            if (this.styleMapList != null) {
                this.styleMapList.clear();
            }
            this.baseStyleMapId = this.styleMapId;
            if (this.baseStyleMapId > 0xFFFFFFF) {
                this.styleMapId = 0;
                this.baseStyleMapId = 0;
            }
        }

        private Selector getInlineStyleSelector(String string) {
            Stylesheet stylesheet;
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            if (this.inlineStylesCache != null && this.inlineStylesCache.containsKey(string)) {
                return this.inlineStylesCache.get(string);
            }
            if (this.inlineStylesCache == null) {
                this.inlineStylesCache = new HashMap<String, Selector>();
            }
            if ((stylesheet = CSSParser.getInstance().parse("*{" + string + "}")) != null) {
                Selector selector;
                stylesheet.setOrigin(StyleOrigin.INLINE);
                List<Rule> list = stylesheet.getRules();
                Rule rule = list != null && !list.isEmpty() ? list.get(0) : null;
                List<Selector> list2 = rule != null ? rule.getUnobservedSelectorList() : null;
                Selector selector2 = selector = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                if (selector != null) {
                    selector.setOrdinal(-1);
                    this.inlineStylesCache.put(string, selector);
                    return selector;
                }
            }
            this.inlineStylesCache.put(string, null);
            return null;
        }
    }

    private static class InstanceHolder {
        static final StyleManager INSTANCE = new StyleManager();

        private InstanceHolder() {
        }
    }

    private static class Key {
        String className;
        String id;
        final StyleClassSet styleClasses = new StyleClassSet();

        private Key() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                if (this.className == null ? key.className != null : !this.className.equals(key.className)) {
                    return false;
                }
                if (this.id == null ? key.id != null : !this.id.equals(key.id)) {
                    return false;
                }
                return this.styleClasses.equals(key.styleClasses);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.id != null ? this.id.hashCode() : 0);
            n = 29 * n + this.styleClasses.hashCode();
            return n;
        }
    }

    private static class RefList<K> {
        final List<Reference<K>> list = new ArrayList<Reference<K>>();

        private RefList() {
        }

        void add(K k) {
            for (int i = this.list.size() - 1; 0 <= i; --i) {
                Reference<K> reference = this.list.get(i);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(i);
                    continue;
                }
                if (k2 != k) continue;
                return;
            }
            this.list.add(new WeakReference<K>(k));
        }
    }

    private static class StylesheetContainer {
        final String fname;
        final Stylesheet stylesheet;
        final SelectorPartitioning selectorPartitioning;
        final RefList<Scene> sceneUsers;
        final RefList<Parent> parentUsers;
        final RefList<Key> keys;
        final List<Image> imageCache;
        final int hash;

        StylesheetContainer(String string, Stylesheet stylesheet) {
            this.fname = string;
            this.hash = string != null ? string.hashCode() : 127;
            this.stylesheet = stylesheet;
            if (stylesheet != null) {
                this.selectorPartitioning = new SelectorPartitioning();
                List<Rule> list = stylesheet.getRules();
                int n = list == null || list.isEmpty() ? 0 : list.size();
                for (int i = 0; i < n; ++i) {
                    Rule rule = list.get(i);
                    List<Selector> list2 = rule.getUnobservedSelectorList();
                    int n2 = list2 == null || list2.isEmpty() ? 0 : list2.size();
                    for (int j = 0; j < n2; ++j) {
                        Selector selector = list2.get(j);
                        this.selectorPartitioning.partition(selector);
                    }
                }
            } else {
                this.selectorPartitioning = null;
            }
            this.sceneUsers = new RefList();
            this.parentUsers = new RefList();
            this.keys = new RefList();
            this.imageCache = new ArrayList<Image>();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StylesheetContainer stylesheetContainer = (StylesheetContainer)object;
            return !(this.fname == null ? stylesheetContainer.fname != null : !this.fname.equals(stylesheetContainer.fname));
        }

        public String toString() {
            return this.fname;
        }
    }
}

