/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.event.BasicEventDispatcher;
import com.sun.javafx.scene.traversal.Direction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;

public final class KeyboardShortcutsHandler
extends BasicEventDispatcher {
    private ObservableMap<KeyCombination, Runnable> accelerators;
    private ObservableMap<KeyCombination, ObservableList<Mnemonic>> mnemonics;
    private boolean mnemonicsDisplayEnabled = false;

    public void addMnemonic(Mnemonic mnemonic) {
        ObservableListWrapper<Mnemonic> observableListWrapper = (ObservableListWrapper<Mnemonic>)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableListWrapper == null) {
            observableListWrapper = new ObservableListWrapper<Mnemonic>(new ArrayList());
            this.getMnemonics().put(mnemonic.getKeyCombination(), observableListWrapper);
        }
        boolean bl = false;
        for (int i = 0; i < observableListWrapper.size(); ++i) {
            if (observableListWrapper.get(i) != mnemonic) continue;
            bl = true;
        }
        if (!bl) {
            observableListWrapper.add(mnemonic);
        }
    }

    public void removeMnemonic(Mnemonic mnemonic) {
        ObservableList observableList = (ObservableList)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableList != null) {
            for (int i = 0; i < observableList.size(); ++i) {
                if (((Mnemonic)observableList.get(i)).getNode() != mnemonic.getNode()) continue;
                observableList.remove(i);
            }
        }
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        if (this.mnemonics == null) {
            this.mnemonics = new ObservableMapWrapper<KeyCombination, ObservableList<Mnemonic>>(new HashMap());
        }
        return this.mnemonics;
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        if (this.accelerators == null) {
            this.accelerators = new ObservableMapWrapper<KeyCombination, Runnable>(new HashMap());
        }
        return this.accelerators;
    }

    public void traverse(Node node, Direction direction) {
        node.impl_traverse(direction);
    }

    public void processTraversal(Event event) {
        EventTarget eventTarget;
        if (event instanceof KeyEvent && event.getEventType() == KeyEvent.KEY_PRESSED && !((KeyEvent)event).isMetaDown() && !((KeyEvent)event).isControlDown() && !((KeyEvent)event).isAltDown() && (eventTarget = event.getTarget()) instanceof Node) {
            switch (((KeyEvent)event).getCode()) {
                case TAB: {
                    if (((KeyEvent)event).isShiftDown()) {
                        this.traverse((Node)eventTarget, Direction.PREVIOUS);
                    } else {
                        this.traverse((Node)eventTarget, Direction.NEXT);
                    }
                    event.consume();
                    break;
                }
                case UP: {
                    this.traverse((Node)eventTarget, Direction.UP);
                    event.consume();
                    break;
                }
                case DOWN: {
                    this.traverse((Node)eventTarget, Direction.DOWN);
                    event.consume();
                    break;
                }
                case LEFT: {
                    this.traverse((Node)eventTarget, Direction.LEFT);
                    event.consume();
                    break;
                }
                case RIGHT: {
                    this.traverse((Node)eventTarget, Direction.RIGHT);
                    event.consume();
                    break;
                }
            }
        }
    }

    @Override
    public Event dispatchBubblingEvent(Event event) {
        if (event.getEventType() == KeyEvent.KEY_PRESSED) {
            if (PlatformUtil.isMac()) {
                if (((KeyEvent)event).isMetaDown()) {
                    this.processMnemonics((KeyEvent)event);
                }
            } else if (((KeyEvent)event).isAltDown() || this.isMnemonicsDisplayEnabled()) {
                this.processMnemonics((KeyEvent)event);
            }
            if (!event.isConsumed()) {
                this.processAccelerators((KeyEvent)event);
            }
            if (!event.isConsumed()) {
                this.processTraversal(event);
            }
        }
        if (!PlatformUtil.isMac()) {
            if (event.getEventType() == KeyEvent.KEY_PRESSED && ((KeyEvent)event).isAltDown() && !event.isConsumed()) {
                if (!this.isMnemonicsDisplayEnabled()) {
                    this.setMnemonicsDisplayEnabled(true);
                } else if (PlatformUtil.isWindows()) {
                    this.setMnemonicsDisplayEnabled(!this.isMnemonicsDisplayEnabled());
                }
            }
            if (event.getEventType() == KeyEvent.KEY_RELEASED && !((KeyEvent)event).isAltDown() && !PlatformUtil.isWindows()) {
                this.setMnemonicsDisplayEnabled(false);
            }
        }
        return event;
    }

    /*
     * WARNING - void declaration
     */
    private void processMnemonics(KeyEvent keyEvent) {
        if (this.mnemonics != null) {
            Object object;
            ObservableList observableList = null;
            for (Map.Entry object2 : this.mnemonics.entrySet()) {
                if (!this.isMnemonicsDisplayEnabled()) {
                    if (!((KeyCombination)object2.getKey()).match(keyEvent)) continue;
                    observableList = (ObservableList)object2.getValue();
                    break;
                }
                object = new KeyEvent(null, keyEvent.getTarget(), KeyEvent.KEY_PRESSED, keyEvent.getCharacter(), keyEvent.getText(), keyEvent.getCode(), keyEvent.isShiftDown(), keyEvent.isControlDown(), true, keyEvent.isMetaDown());
                if (!((KeyCombination)object2.getKey()).match((KeyEvent)object)) continue;
                observableList = (ObservableList)object2.getValue();
                break;
            }
            if (observableList != null) {
                void var4_7;
                boolean bl = false;
                Object var4_6 = null;
                object = null;
                int n = -1;
                int n2 = -1;
                for (int i = 0; i < observableList.size(); ++i) {
                    if (!(observableList.get(i) instanceof Mnemonic)) continue;
                    Node node = ((Mnemonic)observableList.get(i)).getNode();
                    if (object == null && node.impl_isTreeVisible() && !node.isDisabled()) {
                        object = (Mnemonic)observableList.get(i);
                    }
                    if (node.impl_isTreeVisible() && node.isFocusTraversable() && !node.isDisabled()) {
                        if (var4_7 == null) {
                            Node node2 = node;
                        } else {
                            bl = true;
                            if (n != -1 && n2 == -1) {
                                n2 = i;
                            }
                        }
                    }
                    if (!node.isFocused()) continue;
                    n = i;
                }
                if (var4_7 != null) {
                    if (!bl) {
                        var4_7.requestFocus();
                        keyEvent.consume();
                    } else if (n == -1) {
                        var4_7.requestFocus();
                        keyEvent.consume();
                    } else if (n >= observableList.size()) {
                        var4_7.requestFocus();
                        keyEvent.consume();
                    } else {
                        if (n2 != -1) {
                            ((Mnemonic)observableList.get(n2)).getNode().requestFocus();
                        } else {
                            var4_7.requestFocus();
                        }
                        keyEvent.consume();
                    }
                }
                if (!bl && object != null) {
                    ((Mnemonic)object).fire();
                }
            }
        }
    }

    private void processAccelerators(KeyEvent keyEvent) {
        if (this.accelerators != null) {
            for (Map.Entry entry : this.accelerators.entrySet()) {
                Runnable runnable;
                if (!((KeyCombination)entry.getKey()).match(keyEvent) || (runnable = (Runnable)entry.getValue()) == null) continue;
                runnable.run();
                keyEvent.consume();
            }
        }
    }

    private void processMnemonicsKeyDisplay() {
        ObservableList observableList = null;
        if (this.mnemonics != null) {
            for (Map.Entry entry : this.mnemonics.entrySet()) {
                observableList = (ObservableList)entry.getValue();
                if (observableList == null) continue;
                for (int i = 0; i < observableList.size(); ++i) {
                    Node node = ((Mnemonic)observableList.get(i)).getNode();
                    node.impl_setShowMnemonics(this.mnemonicsDisplayEnabled);
                }
            }
        }
    }

    public boolean isMnemonicsDisplayEnabled() {
        return this.mnemonicsDisplayEnabled;
    }

    public void setMnemonicsDisplayEnabled(boolean bl) {
        if (bl != this.mnemonicsDisplayEnabled) {
            this.mnemonicsDisplayEnabled = bl;
            this.processMnemonicsKeyDisplay();
        }
    }
}

