/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class TreeTableRowBehavior<T>
extends CellBehaviorBase<TreeTableRow<T>> {
    private boolean latePress = false;
    private boolean wasSelected = false;

    public TreeTableRowBehavior(TreeTableRow<T> treeTableRow) {
        super(treeTableRow, (List<KeyBinding>)Collections.EMPTY_LIST);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        boolean bl = ((TreeTableRow)this.getControl()).isSelected();
        if (((TreeTableRow)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (IS_TOUCH_SUPPORTED && bl) {
            this.wasSelected = ((TreeTableRow)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        this.latePress = false;
        if (IS_TOUCH_SUPPORTED && !this.wasSelected && ((TreeTableRow)this.getControl()).isSelected()) {
            ((TreeTableRow)this.getControl()).getTreeTableView().getSelectionModel().clearSelection(((TreeTableRow)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        TreeTableRow treeTableRow = (TreeTableRow)this.getControl();
        TreeItem treeItem = treeTableRow.getTreeItem();
        if (treeItem == null) {
            return;
        }
        Node node = treeTableRow.getDisclosureNode();
        if (node != null && node.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            treeItem.setExpanded(!treeItem.isExpanded());
            return;
        }
        TreeTableView treeTableView = treeTableRow.getTreeTableView();
        if (treeTableView == null) {
            return;
        }
        TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = treeTableView.getSelectionModel();
        if (treeTableViewSelectionModel == null || treeTableViewSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        int n = ((TreeTableRow)this.getControl()).getIndex();
        boolean bl = treeTableViewSelectionModel.isSelected(n);
        int n2 = mouseEvent.getClickCount();
        if (n2 == 1) {
            ObservableList observableList = ((TreeTableRow)this.getControl()).getTreeTableView().getVisibleLeafColumns();
            double d = 0.0;
            for (int i = 0; i < observableList.size(); ++i) {
                d += ((TreeTableColumn)observableList.get(i)).getWidth();
            }
            if (mouseEvent.getX() < d) {
                return;
            }
            if (bl && mouseEvent.isShortcutDown()) {
                treeTableViewSelectionModel.clearSelection(n);
            } else if (mouseEvent.isShortcutDown()) {
                treeTableViewSelectionModel.select(treeTableRow.getIndex());
            } else if (mouseEvent.isShiftDown()) {
                TablePositionBase tablePositionBase = TreeTableCellBehavior.getAnchor(treeTableView, treeTableView.getFocusModel().getFocusedCell());
                int n3 = tablePositionBase.getRow();
                boolean bl2 = n3 < n;
                int n4 = Math.min(tablePositionBase.getRow(), n);
                int n5 = Math.max(tablePositionBase.getRow(), n);
                ArrayList arrayList = new ArrayList(treeTableViewSelectionModel.getSelectedIndices());
                int n6 = arrayList.size();
                for (int i = 0; i < n6; ++i) {
                    int n7 = (Integer)arrayList.get(i);
                    if (n7 >= n4 && n7 <= n5) continue;
                    treeTableViewSelectionModel.clearSelection(n7);
                }
                if (n4 == n5) {
                    treeTableViewSelectionModel.select(n4);
                } else if (bl2) {
                    treeTableViewSelectionModel.selectRange(n4, n5 + 1);
                } else {
                    treeTableViewSelectionModel.selectRange(n5, n4 - 1);
                }
            } else {
                treeTableViewSelectionModel.clearAndSelect(treeTableRow.getIndex());
            }
        }
    }

    private boolean isClickOutsideCellBounds(double d) {
        TreeTableRow treeTableRow = (TreeTableRow)this.getControl();
        TreeTableView treeTableView = treeTableRow.getTreeTableView();
        if (treeTableView == null) {
            return false;
        }
        ObservableList observableList = treeTableView.getVisibleLeafColumns();
        double d2 = 0.0;
        for (int i = 0; i < observableList.size(); ++i) {
            d2 += ((TreeTableColumn)observableList.get(i)).getWidth();
        }
        return d > d2;
    }
}

