/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import com.sun.javafx.scene.control.skin.CustomColorDialog;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.stage.WindowEvent;

public class ColorPalette
extends VBox {
    private static final int SQUARE_SIZE = 15;
    private static final int NUM_OF_COLUMNS = 12;
    private static final int NUM_OF_ROWS = 10;
    private static final int LABEL_GAP = 2;
    private boolean customColorAdded = false;
    ColorPickerGrid colorPickerGrid;
    ColorPicker colorPicker;
    GridPane customColorGrid = new GridPane();
    Hyperlink customColorLink = new Hyperlink("Custom Color..");
    Separator separator = new Separator();
    Label customColorLabel = new Label("Custom Colors");
    CustomColorDialog customColorDialog = null;
    private final List<ColorSquare> customSquares = FXCollections.observableArrayList();
    private PopupControl popupControl;
    private ColorSquare focusedSquare;
    private ContextMenu contextMenu = null;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;

    public ColorPalette(Color color, final ColorPicker colorPicker) {
        this.getStyleClass().add("color-palette");
        this.colorPicker = colorPicker;
        this.colorPickerGrid = new ColorPickerGrid(color);
        this.colorPickerGrid.requestFocus();
        this.colorPickerGrid.setFocusTraversable(true);
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(this.colorPickerGrid.prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setVisited(true);
        this.customColorLink.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (ColorPalette.this.customColorDialog == null) {
                    ColorPalette.this.customColorDialog = new CustomColorDialog(ColorPalette.this.popupControl);
                    ColorPalette.this.customColorDialog.customColorProperty().addListener(new ChangeListener<Color>(){

                        @Override
                        public void changed(ObservableValue<? extends Color> observableValue, Color color, Color color2) {
                            colorPicker.setValue(ColorPalette.this.customColorDialog.customColorProperty().get());
                        }
                    });
                    ColorPalette.this.customColorDialog.setOnSave(new Runnable(){

                        @Override
                        public void run() {
                            Color color = (Color)ColorPalette.this.customColorDialog.customColorProperty().get();
                            ColorSquare colorSquare = new ColorSquare(color, true);
                            ColorPalette.this.customSquares.add(colorSquare);
                            ColorPalette.this.buildCustomColors();
                            colorPicker.getCustomColors().add(color);
                            ColorPalette.this.updateSelection(color);
                            Event.fireEvent(colorPicker, new ActionEvent());
                            colorPicker.hide();
                        }
                    });
                    ColorPalette.this.customColorDialog.setOnUse(new Runnable(){

                        @Override
                        public void run() {
                            Event.fireEvent(colorPicker, new ActionEvent());
                            colorPicker.hide();
                        }
                    });
                }
                ColorPalette.this.customColorDialog.setCurrentColor((Color)colorPicker.valueProperty().get());
                if (ColorPalette.this.popupControl != null) {
                    ColorPalette.this.popupControl.setAutoHide(false);
                }
                ColorPalette.this.customColorDialog.show();
                ColorPalette.this.customColorDialog.setOnHidden(new EventHandler<WindowEvent>(){

                    @Override
                    public void handle(WindowEvent windowEvent) {
                        if (ColorPalette.this.popupControl != null) {
                            ColorPalette.this.popupControl.setAutoHide(true);
                        }
                    }
                });
            }
        });
        this.initNavigation();
        this.customColorGrid.getStyleClass().add("color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.customColorGrid.setFocusTraversable(true);
        for (Color color2 : colorPicker.getCustomColors()) {
            this.customSquares.add(new ColorSquare(color2, true));
        }
        this.buildCustomColors();
        colorPicker.getCustomColors().addListener(new ListChangeListener<Color>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Color> change) {
                ColorPalette.this.customSquares.clear();
                for (Color color : colorPicker.getCustomColors()) {
                    ColorPalette.this.customSquares.add(new ColorSquare(color, true));
                }
                ColorPalette.this.buildCustomColors();
            }
        });
        this.getChildren().addAll((Node[])new Node[]{this.colorPickerGrid, this.customColorLabel, this.customColorGrid, this.separator, this.customColorLink});
    }

    private void buildCustomColors() {
        int n = 0;
        int n2 = 0;
        int n3 = this.customSquares.size() % 12;
        int n4 = n3 == 0 ? 0 : 12 - n3;
        this.customColorGrid.getChildren().clear();
        if (this.customSquares.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        if (this.contextMenu == null) {
            MenuItem menuItem = new MenuItem("Remove Color");
            menuItem.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ColorSquare colorSquare = (ColorSquare)ColorPalette.this.contextMenu.getOwnerNode();
                    ColorPalette.this.colorPicker.getCustomColors().remove(colorSquare.rectangle.getFill());
                    ColorPalette.this.customSquares.remove(colorSquare);
                    ColorPalette.this.buildCustomColors();
                }
            });
            this.contextMenu = new ContextMenu(menuItem);
        }
        for (ColorSquare colorSquare : this.customSquares) {
            this.customColorGrid.add(colorSquare, n, n2);
            if (++n != 12) continue;
            n = 0;
            ++n2;
        }
        for (int i = 0; i < n4; ++i) {
            ColorSquare colorSquare;
            colorSquare = new ColorSquare(null);
            this.customColorGrid.add(colorSquare, n, n2);
            ++n;
        }
        this.requestLayout();
    }

    private void initNavigation() {
        this.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                switch (keyEvent.getCode()) {
                    case LEFT: {
                        if (ColorPalette.this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                            ColorPalette.this.processRightKey(keyEvent);
                            break;
                        }
                        ColorPalette.this.processLeftKey(keyEvent);
                        break;
                    }
                    case RIGHT: {
                        if (ColorPalette.this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                            ColorPalette.this.processLeftKey(keyEvent);
                            break;
                        }
                        ColorPalette.this.processRightKey(keyEvent);
                        break;
                    }
                    case UP: {
                        ColorPalette.this.processUpKey(keyEvent);
                        break;
                    }
                    case DOWN: {
                        ColorPalette.this.processDownKey(keyEvent);
                        break;
                    }
                    case ENTER: {
                        ColorPalette.this.processSelectKey(keyEvent);
                        break;
                    }
                }
            }
        });
    }

    private void processSelectKey(KeyEvent keyEvent) {
        if (this.focusedSquare != null) {
            this.focusedSquare.selectColor(keyEvent);
        }
    }

    private void processLeftKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 119; n >= 0; --n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n != 0 ? n - 1 : 119);
            colorSquare3.requestFocus();
            this.focusedSquare = colorSquare3;
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = n2 - 1; n >= 0; --n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            if (colorSquare != this.focusedSquare) continue;
            ColorSquare colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n != 0 ? n - 1 : n2 - 1);
            colorSquare4.requestFocus();
            this.focusedSquare = colorSquare4;
            return;
        }
        if (n == -1) {
            this.focusedSquare = colorSquare = this.colorPickerGrid.getSquares().get(119);
            colorSquare.requestFocus();
        }
    }

    private void processUpKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 119; n >= 0; --n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n - 12 >= 0 ? n - 12 : 108 + n);
            colorSquare3.requestFocus();
            this.focusedSquare = colorSquare3;
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = n2 - 1; n >= 0; --n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            ColorSquare colorSquare4 = null;
            if (colorSquare != this.focusedSquare) continue;
            if (n - 12 >= 0) {
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n - 12);
            } else {
                int n3 = GridPane.getRowIndex((Node)this.customColorGrid.getChildren().get(n2 - 1));
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n3 * 12 + n);
            }
            colorSquare4.requestFocus();
            this.focusedSquare = colorSquare4;
            return;
        }
        if (n == -1) {
            this.focusedSquare = colorSquare = this.colorPickerGrid.getSquares().get(119);
            this.focusedSquare.requestFocus();
        }
    }

    private void processRightKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 0; n < 120; ++n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n != 119 ? n + 1 : 0);
            colorSquare3.requestFocus();
            this.focusedSquare = colorSquare3;
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = 0; n < n2; ++n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            if (colorSquare != this.focusedSquare) continue;
            ColorSquare colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n != n2 - 1 ? n + 1 : 0);
            colorSquare4.requestFocus();
            this.focusedSquare = colorSquare4;
            return;
        }
        if (n == n2) {
            this.focusedSquare = colorSquare = this.colorPickerGrid.getSquares().get(0);
            this.focusedSquare.requestFocus();
        }
    }

    private void processDownKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 0; n < 120; ++n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n + 12 < 120 ? n + 12 : n - 108);
            colorSquare3.requestFocus();
            this.focusedSquare = colorSquare3;
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = 0; n < n2; ++n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            ColorSquare colorSquare4 = null;
            if (colorSquare != this.focusedSquare) continue;
            if (n + 12 < n2) {
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n + 12);
            } else {
                int n3 = GridPane.getRowIndex((Node)this.customColorGrid.getChildren().get(n2 - 1));
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n - n3 * 12);
            }
            colorSquare4.requestFocus();
            this.focusedSquare = colorSquare4;
            return;
        }
        if (n == n2) {
            colorSquare = this.colorPickerGrid.getSquares().get(0);
            this.focusedSquare.requestFocus();
            this.focusedSquare = colorSquare;
        }
    }

    public void setPopupControl(PopupControl popupControl) {
        this.popupControl = popupControl;
    }

    public ColorPickerGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        if (this.customColorDialog != null) {
            return this.customColorDialog.isVisible();
        }
        return false;
    }

    public void clearFocus() {
        this.colorPickerGrid.requestFocus();
    }

    public void updateSelection(Color color) {
        for (ColorSquare colorSquare : this.colorPickerGrid.getSquares()) {
            colorSquare.setSelected(colorSquare.rectangle.getFill().equals(color));
        }
        for (ColorSquare colorSquare : this.customSquares) {
            colorSquare.setSelected(colorSquare.rectangle.getFill().equals(color));
        }
    }

    class ColorPickerGrid
    extends GridPane {
        private final List<ColorSquare> squares;
        double[] rawValues = new double[]{255.0, 255.0, 255.0, 242.0, 242.0, 242.0, 230.0, 230.0, 230.0, 204.0, 204.0, 204.0, 179.0, 179.0, 179.0, 153.0, 153.0, 153.0, 128.0, 128.0, 128.0, 102.0, 102.0, 102.0, 77.0, 77.0, 77.0, 51.0, 51.0, 51.0, 26.0, 26.0, 26.0, 0.0, 0.0, 0.0, 0.0, 51.0, 51.0, 0.0, 26.0, 128.0, 26.0, 0.0, 104.0, 51.0, 0.0, 51.0, 77.0, 0.0, 26.0, 153.0, 0.0, 0.0, 153.0, 51.0, 0.0, 153.0, 77.0, 0.0, 153.0, 102.0, 0.0, 153.0, 153.0, 0.0, 102.0, 102.0, 0.0, 0.0, 51.0, 0.0, 26.0, 77.0, 77.0, 26.0, 51.0, 153.0, 51.0, 26.0, 128.0, 77.0, 26.0, 77.0, 102.0, 26.0, 51.0, 179.0, 26.0, 26.0, 179.0, 77.0, 26.0, 179.0, 102.0, 26.0, 179.0, 128.0, 26.0, 179.0, 179.0, 26.0, 128.0, 128.0, 26.0, 26.0, 77.0, 26.0, 51.0, 102.0, 102.0, 51.0, 77.0, 179.0, 77.0, 51.0, 153.0, 102.0, 51.0, 102.0, 128.0, 51.0, 77.0, 204.0, 51.0, 51.0, 204.0, 102.0, 51.0, 204.0, 128.0, 51.0, 204.0, 153.0, 51.0, 204.0, 204.0, 51.0, 153.0, 153.0, 51.0, 51.0, 102.0, 51.0, 77.0, 128.0, 128.0, 77.0, 102.0, 204.0, 102.0, 77.0, 179.0, 128.0, 77.0, 128.0, 153.0, 77.0, 102.0, 230.0, 77.0, 77.0, 230.0, 128.0, 77.0, 230.0, 153.0, 77.0, 230.0, 179.0, 77.0, 230.0, 230.0, 77.0, 179.0, 179.0, 77.0, 77.0, 128.0, 77.0, 102.0, 153.0, 153.0, 102.0, 128.0, 230.0, 128.0, 102.0, 204.0, 153.0, 102.0, 153.0, 179.0, 102.0, 128.0, 255.0, 102.0, 102.0, 255.0, 153.0, 102.0, 255.0, 179.0, 102.0, 255.0, 204.0, 102.0, 255.0, 255.0, 77.0, 204.0, 204.0, 102.0, 102.0, 153.0, 102.0, 128.0, 179.0, 179.0, 128.0, 153.0, 255.0, 153.0, 128.0, 230.0, 179.0, 128.0, 179.0, 204.0, 128.0, 153.0, 255.0, 128.0, 128.0, 255.0, 153.0, 128.0, 255.0, 204.0, 128.0, 255.0, 230.0, 102.0, 255.0, 255.0, 102.0, 230.0, 230.0, 128.0, 128.0, 179.0, 128.0, 153.0, 204.0, 204.0, 153.0, 179.0, 255.0, 179.0, 153.0, 255.0, 204.0, 153.0, 204.0, 230.0, 153.0, 179.0, 255.0, 153.0, 153.0, 255.0, 179.0, 128.0, 255.0, 204.0, 153.0, 255.0, 230.0, 128.0, 255.0, 255.0, 128.0, 230.0, 230.0, 153.0, 153.0, 204.0, 153.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 179.0, 179.0, 255.0, 179.0, 153.0, 255.0, 230.0, 179.0, 255.0, 230.0, 153.0, 255.0, 255.0, 153.0, 230.0, 230.0, 179.0, 179.0, 230.0, 179.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 230.0, 204.0, 255.0, 255.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 204.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 204.0, 255.0, 255.0, 179.0, 255.0, 255.0, 204.0, 230.0, 230.0, 204.0, 204.0, 255.0, 204.0};

        public ColorPickerGrid(Color color) {
            this.getStyleClass().add("color-picker-grid");
            this.setId("ColorCustomizerColorGrid");
            int n = 0;
            int n2 = 0;
            this.setFocusTraversable(true);
            this.squares = FXCollections.observableArrayList();
            int n3 = this.rawValues.length / 3;
            Color[] colorArray = new Color[n3];
            for (int i = 0; i < n3; ++i) {
                colorArray[i] = new Color(this.rawValues[i * 3] / 255.0, this.rawValues[i * 3 + 1] / 255.0, this.rawValues[i * 3 + 2] / 255.0, 1.0);
                ColorSquare colorSquare = new ColorSquare(colorArray[i]);
                this.squares.add(colorSquare);
            }
            for (ColorSquare colorSquare : this.squares) {
                this.add(colorSquare, n, n2);
                if (++n != 12) continue;
                n = 0;
                ++n2;
            }
            this.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    int n;
                    int n2;
                    int n3;
                    if (!ColorPalette.this.dragDetected) {
                        ColorPalette.this.dragDetected = true;
                        ColorPalette.this.mouseDragColor = (Color)ColorPalette.this.colorPicker.getValue();
                    }
                    if ((n3 = (n2 = (int)(mouseEvent.getX() / 16.0)) + (n = (int)(mouseEvent.getY() / 16.0)) * 12) < 120) {
                        ColorPalette.this.colorPicker.setValue((Color)((ColorSquare)((ColorPickerGrid)ColorPickerGrid.this).squares.get((int)n3)).rectangle.getFill());
                        ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
                    }
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (ColorPalette.this.colorPickerGrid.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
                        ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
                        ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                        ColorPalette.this.colorPicker.hide();
                    } else if (ColorPalette.this.mouseDragColor != null) {
                        ColorPalette.this.colorPicker.setValue(ColorPalette.this.mouseDragColor);
                        ColorPalette.this.updateSelection(ColorPalette.this.mouseDragColor);
                    }
                    ColorPalette.this.dragDetected = false;
                }
            });
        }

        public List<ColorSquare> getSquares() {
            return this.squares;
        }

        @Override
        protected double computePrefWidth(double d) {
            return 192.0;
        }

        @Override
        protected double computePrefHeight(double d) {
            return 160.0;
        }
    }

    class ColorSquare
    extends StackPane {
        Rectangle rectangle;
        boolean isCustom = false;
        boolean isEmpty = false;
        private ReadOnlyBooleanWrapper selected;
        private final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("selected");

        public ColorSquare(Color color) {
            this(color, false);
        }

        public ColorSquare(Color color, boolean bl) {
            this.getStyleClass().add("color-square");
            this.setFocusTraversable(true);
            this.isCustom = bl;
            this.rectangle = new Rectangle(15.0, 15.0);
            this.setFocusTraversable(true);
            if (color == null) {
                this.rectangle.setFill(Color.WHITE);
                this.isEmpty = true;
            } else {
                this.rectangle.setFill(color);
            }
            this.rectangle.setSmooth(false);
            this.rectangle.setStrokeType(StrokeType.INSIDE);
            String string = ColorPickerSkin.colorValueToWeb(color);
            Tooltip.install(this, new Tooltip(string == null ? "" : string));
            this.rectangle.getStyleClass().add("color-rect");
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ColorSquare.this.toFront();
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ColorPalette.this.dragDetected && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
                        if (!ColorSquare.this.isEmpty) {
                            Color color = (Color)ColorSquare.this.rectangle.getFill();
                            ColorPalette.this.colorPicker.setValue(color);
                            ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                            ColorPalette.this.updateSelection(color);
                            mouseEvent.consume();
                        }
                        ColorPalette.this.colorPicker.hide();
                    } else if ((mouseEvent.getButton() == MouseButton.SECONDARY || mouseEvent.getButton() == MouseButton.MIDDLE) && ColorSquare.this.isCustom && ColorPalette.this.contextMenu != null) {
                        if (!ColorPalette.this.contextMenu.isShowing()) {
                            ColorPalette.this.contextMenu.show(ColorSquare.this, Side.RIGHT, 0.0, 0.0);
                            Utils.addMnemonics(ColorPalette.this.contextMenu, ColorSquare.this.getScene(), ColorPalette.this.colorPicker.impl_isShowMnemonics());
                        } else {
                            ColorPalette.this.contextMenu.hide();
                            Utils.removeMnemonics(ColorPalette.this.contextMenu, ColorSquare.this.getScene());
                        }
                    }
                }
            });
            this.focusedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ColorPalette.this.focusedSquare = ColorSquare.this;
                    ColorPalette.this.focusedSquare.requestFocus();
                }
            });
            this.getChildren().add(this.rectangle);
        }

        public void selectColor(KeyEvent keyEvent) {
            if (this.rectangle.getFill() != null) {
                if (this.rectangle.getFill() instanceof Color) {
                    ColorPalette.this.colorPicker.setValue((Color)this.rectangle.getFill());
                    ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                }
                keyEvent.consume();
            }
            ColorPalette.this.colorPicker.hide();
        }

        protected final void setSelected(boolean bl) {
            this.selectedPropertyImpl().set(bl);
        }

        public final boolean isSelected() {
            return this.selected == null ? false : this.selected.get();
        }

        public ReadOnlyBooleanProperty selectedProperty() {
            return this.selectedPropertyImpl().getReadOnlyProperty();
        }

        private ReadOnlyBooleanWrapper selectedPropertyImpl() {
            if (this.selected == null) {
                this.selected = new ReadOnlyBooleanWrapper(){

                    @Override
                    protected void invalidated() {
                        ColorSquare.this.pseudoClassStateChanged(ColorSquare.this.SELECTED_PSEUDOCLASS_STATE, this.get());
                    }

                    @Override
                    public Object getBean() {
                        return ColorSquare.this;
                    }

                    @Override
                    public String getName() {
                        return "selected";
                    }
                };
            }
            return this.selected;
        }
    }
}

