/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.DatePickerBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.DatePickerContent;
import com.sun.javafx.scene.control.skin.DatePickerHijrahContent;
import com.sun.javafx.scene.control.skin.Utils;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.HijrahChronology;
import java.time.format.DateTimeParseException;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;

public class DatePickerSkin
extends ComboBoxPopupControl<LocalDate> {
    private DatePicker datePicker;
    private TextField displayNode;
    private DatePickerContent datePickerContent;
    private TextField textField;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");

    public DatePickerSkin(final DatePicker datePicker) {
        super(datePicker, new DatePickerBehavior(datePicker));
        this.datePicker = datePicker;
        this.textField = this.getEditableInputNode();
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        if (this.arrowButton.getOnMouseReleased() == null) {
            this.arrowButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((DatePickerBehavior)DatePickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                    mouseEvent.consume();
                }
            });
        }
        this.arrow.paddingProperty().addListener(new InvalidationListener(){
            private boolean rounding = false;

            @Override
            public void invalidated(Observable observable) {
                Insets insets;
                Insets insets2;
                if (!this.rounding && !(insets2 = new Insets(Math.round((insets = DatePickerSkin.this.arrow.getPadding()).getTop()), Math.round(insets.getRight()), Math.round(insets.getBottom()), Math.round(insets.getLeft()))).equals(insets)) {
                    this.rounding = true;
                    DatePickerSkin.this.arrow.setPadding(insets2);
                    this.rounding = false;
                }
            }
        });
        datePicker.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                ((ComboBoxListViewSkin.FakeFocusTextField)DatePickerSkin.this.textField).setFakeFocus(bl2);
            }
        });
        datePicker.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (DatePickerSkin.this.textField == null) {
                    return;
                }
                if (keyEvent.getTarget().equals(DatePickerSkin.this.textField)) {
                    return;
                }
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    DatePickerSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    if (!Utils.isTwoLevelFocus()) {
                        keyEvent.consume();
                    }
                    return;
                }
                if (keyEvent.getCode() == KeyCode.F4 && keyEvent.getEventType() == KeyEvent.KEY_RELEASED) {
                    if (datePicker.isShowing()) {
                        datePicker.hide();
                    } else {
                        datePicker.show();
                    }
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getCode() == KeyCode.F10 || keyEvent.getCode() == KeyCode.ESCAPE) {
                    keyEvent.consume();
                    return;
                }
                DatePickerSkin.this.textField.fireEvent(keyEvent.copyFor(DatePickerSkin.this.textField, DatePickerSkin.this.textField));
                keyEvent.consume();
            }
        });
        if (this.textField != null) {
            this.textField.addEventFilter(MouseEvent.DRAG_DETECTED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getTarget().equals(datePicker)) {
                        return;
                    }
                    datePicker.fireEvent(mouseEvent.copyFor(datePicker, datePicker));
                    mouseEvent.consume();
                }
            });
            this.textField.addEventFilter(DragEvent.ANY, new EventHandler<DragEvent>(){

                @Override
                public void handle(DragEvent dragEvent) {
                    if (dragEvent.getTarget().equals(datePicker)) {
                        return;
                    }
                    datePicker.fireEvent(dragEvent.copyFor(datePicker, datePicker));
                    dragEvent.consume();
                }
            });
        }
        this.registerChangeListener(datePicker.chronologyProperty(), "CHRONOLOGY");
        this.registerChangeListener(datePicker.converterProperty(), "CONVERTER");
        this.registerChangeListener(datePicker.dayCellFactoryProperty(), "DAY_CELL_FACTORY");
        this.registerChangeListener(datePicker.showWeekNumbersProperty(), "SHOW_WEEK_NUMBERS");
        this.registerChangeListener(datePicker.valueProperty(), "VALUE");
    }

    @Override
    public Node getPopupContent() {
        if (this.datePickerContent == null) {
            this.datePickerContent = this.datePicker.getChronology() instanceof HijrahChronology ? new DatePickerHijrahContent(this.datePicker) : new DatePickerContent(this.datePicker);
        }
        return this.datePickerContent;
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return 50.0;
    }

    @Override
    protected void focusLost() {
    }

    @Override
    public void show() {
        super.show();
        this.datePickerContent.clearFocus();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("CHRONOLOGY".equals(string) || "DAY_CELL_FACTORY".equals(string)) {
            this.updateDisplayNode();
            this.datePickerContent = null;
            this.popup = null;
        } else if ("EDITOR".equals(string)) {
            this.getEditableInputNode();
        } else if ("SHOWING".equals(string)) {
            if (this.datePicker.isShowing()) {
                if (this.datePickerContent != null) {
                    LocalDate localDate = (LocalDate)this.datePicker.getValue();
                    this.datePickerContent.displayedYearMonthProperty().set(localDate != null ? YearMonth.from(localDate) : YearMonth.now());
                    this.datePickerContent.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        } else if ("SHOW_WEEK_NUMBERS".equals(string)) {
            if (this.datePickerContent != null) {
                this.datePickerContent.updateGrid();
                this.datePickerContent.updateWeeknumberDateCells();
            }
        } else if ("VALUE".equals(string)) {
            this.updateDisplayNode();
            if (this.datePickerContent != null) {
                LocalDate localDate = (LocalDate)this.datePicker.getValue();
                this.datePickerContent.displayedYearMonthProperty().set(localDate != null ? YearMonth.from(localDate) : YearMonth.now());
                this.datePickerContent.updateValues();
            }
        }
    }

    @Override
    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode();
            this.displayNode.getStyleClass().add("date-picker-display-node");
            this.updateDisplayNode();
        }
        this.textField.setEditable(this.datePicker.isEditable());
        return this.displayNode;
    }

    private TextField getEditableInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.datePicker.getEditor();
        this.textField.setFocusTraversable(true);
        this.textField.promptTextProperty().bind(this.datePicker.promptTextProperty());
        this.textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                DatePickerSkin.this.datePicker.getProperties().put("FOCUSED", bl2);
                if (!bl2.booleanValue()) {
                    DatePickerSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    DatePickerSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
                } else {
                    DatePickerSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
                }
            }
        });
        return this.textField;
    }

    private void updateDisplayNode() {
        if (this.displayNode != null) {
            LocalDate localDate = (LocalDate)this.datePicker.getValue();
            StringConverter<LocalDate> stringConverter = this.datePicker.getConverter();
            if (localDate != null && stringConverter != null) {
                this.displayNode.setText(stringConverter.toString(localDate));
            } else {
                this.displayNode.setText("");
            }
        }
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        StringConverter<LocalDate> stringConverter = this.datePicker.getConverter();
        if (stringConverter != null) {
            LocalDate localDate;
            LocalDate localDate2 = localDate = (LocalDate)this.datePicker.getValue();
            String string = this.textField.getText();
            if (string == null || string.isEmpty()) {
                localDate2 = null;
            } else {
                try {
                    localDate2 = stringConverter.fromString(string);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            this.datePicker.setValue(localDate2);
            this.updateDisplayNode();
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && this.datePicker.isShowing()) {
            this.datePicker.hide();
        }
    }
}

