/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TableRowBehavior;
import com.sun.javafx.scene.control.skin.TableRowSkinBase;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;

public class TableRowSkin<T>
extends TableRowSkinBase<T, TableRow<T>, CellBehaviorBase<TableRow<T>>, TableCell<T, ?>> {
    private TableView<T> tableView;
    private TableViewSkin<T> tableViewSkin;

    public TableRowSkin(TableRow<T> tableRow) {
        super(tableRow, new TableRowBehavior<T>(tableRow));
        this.tableView = tableRow.getTableView();
        this.updateTableViewSkin();
        super.init(tableRow);
        this.registerChangeListener(tableRow.tableViewProperty(), "TABLE_VIEW");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("TABLE_VIEW".equals(string)) {
            this.updateTableViewSkin();
            int n = this.cells.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.cells.get(i);
                if (!(node instanceof TableCell)) continue;
                ((TableCell)node).updateTableView(((TableRow)this.getSkinnable()).getTableView());
            }
            this.tableView = ((TableRow)this.getSkinnable()).getTableView();
        }
    }

    @Override
    protected TableCell<T, ?> getCell(TableColumnBase tableColumnBase) {
        TableColumn tableColumn = (TableColumn)tableColumnBase;
        TableCell tableCell = tableColumn.getCellFactory().call(tableColumn);
        tableCell.updateTableColumn(tableColumn);
        tableCell.updateTableView(tableColumn.getTableView());
        tableCell.updateTableRow((TableRow)this.getSkinnable());
        return tableCell;
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return this.tableView.getVisibleLeafColumns();
    }

    @Override
    protected void updateCell(TableCell<T, ?> tableCell, TableRow<T> tableRow) {
        tableCell.updateTableRow(tableRow);
    }

    @Override
    protected DoubleProperty fixedCellSizeProperty() {
        return this.tableView.fixedCellSizeProperty();
    }

    @Override
    protected boolean isColumnPartiallyOrFullyVisible(TableColumnBase tableColumnBase) {
        return this.tableViewSkin == null ? false : this.tableViewSkin.isColumnPartiallyOrFullyVisible((TableColumn)tableColumnBase);
    }

    @Override
    protected TableColumn<T, ?> getTableColumnBase(TableCell<T, ?> tableCell) {
        return tableCell.getTableColumn();
    }

    @Override
    protected ObjectProperty<Node> graphicProperty() {
        return null;
    }

    @Override
    protected Control getVirtualFlowOwner() {
        return ((TableRow)this.getSkinnable()).getTableView();
    }

    private void updateTableViewSkin() {
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView.getSkin() instanceof TableViewSkin) {
            this.tableViewSkin = (TableViewSkin)tableView.getSkin();
        }
    }
}

