/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.AppletWindow;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.stage.Stage;

class GlassAppletWindow
implements AppletWindow {
    private final Window glassWindow;
    private WeakReference<Stage> topStage;
    private String serverName;

    GlassAppletWindow(long l, String string) {
        if (0L == l) {
            if (string != null) {
                throw new RuntimeException("GlassAppletWindow constructor used incorrectly.");
            }
            this.glassWindow = Application.GetApplication().createWindow(null, 0);
        } else {
            this.serverName = string;
            this.glassWindow = Application.GetApplication().createWindow(l);
        }
    }

    Window getGlassWindow() {
        return this.glassWindow;
    }

    @Override
    public void setBackgroundColor(final int n) {
        Application.invokeLater(new Runnable(){

            @Override
            public void run() {
                float f = (float)(n >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(n & 0xFF) / 255.0f;
                GlassAppletWindow.this.glassWindow.setBackground(f, f2, f3);
            }
        });
    }

    @Override
    public void setForegroundColor(int n) {
    }

    @Override
    public void setVisible(final boolean bl) {
        Application.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlassAppletWindow.this.glassWindow.setVisible(bl);
            }
        });
    }

    @Override
    public void setSize(final int n, final int n2) {
        Application.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlassAppletWindow.this.glassWindow.setSize(n, n2);
            }
        });
    }

    @Override
    public int getWidth() {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                atomicInteger.set(GlassAppletWindow.this.glassWindow.getWidth());
            }
        });
        return atomicInteger.get();
    }

    @Override
    public int getHeight() {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                atomicInteger.set(GlassAppletWindow.this.glassWindow.getHeight());
            }
        });
        return atomicInteger.get();
    }

    @Override
    public void setPosition(final int n, final int n2) {
        Application.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlassAppletWindow.this.glassWindow.setPosition(n, n2);
            }
        });
    }

    @Override
    public int getPositionX() {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                atomicInteger.set(GlassAppletWindow.this.glassWindow.getX());
            }
        });
        return atomicInteger.get();
    }

    @Override
    public int getPositionY() {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                atomicInteger.set(GlassAppletWindow.this.glassWindow.getY());
            }
        });
        return atomicInteger.get();
    }

    void dispose() {
        ViewPainter.renderLock.lock();
        try {
            this.glassWindow.close();
        }
        finally {
            ViewPainter.renderLock.unlock();
        }
    }

    @Override
    public void setStageOnTop(Stage stage) {
        this.topStage = null != stage ? new WeakReference<Stage>(stage) : null;
    }

    @Override
    public int getRemoteLayerId() {
        final AtomicInteger atomicInteger = new AtomicInteger(-1);
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                View view = GlassAppletWindow.this.glassWindow.getView();
                if (view != null) {
                    atomicInteger.set(view.getNativeRemoteLayerId(GlassAppletWindow.this.serverName));
                }
            }
        });
        return atomicInteger.get();
    }

    @Override
    public void dispatchEvent(final Map map) {
        Application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GlassAppletWindow.this.glassWindow.dispatchNpapiEvent(map);
            }
        });
    }

    void assertStageOrder() {
        Window window;
        TKStage tKStage;
        Stage stage;
        if (null != this.topStage && null != (stage = (Stage)this.topStage.get()) && (tKStage = stage.impl_getPeer()) instanceof WindowStage && ((WindowStage)tKStage).isVisible() && null != (window = ((WindowStage)tKStage).getPlatformWindow())) {
            window.toFront();
        }
    }
}

