/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class GlassWindowEventHandler
extends Window.EventHandler
implements PrivilegedAction<Void> {
    private final WindowStage stage;
    private Window window;
    private int type;

    public GlassWindowEventHandler(WindowStage windowStage) {
        this.stage = windowStage;
    }

    @Override
    public Void run() {
        if (this.stage == null || this.stage.stageListener == null) {
            return null;
        }
        switch (this.type) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                this.stage.stageListener.changedMaximized(true);
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                this.stage.stageListener.changedMaximized(false);
                break;
            }
            case 512: {
                this.stage.stageListener.changedLocation(this.window.getX(), this.window.getY());
                if (Application.GetApplication().hasWindowManager()) break;
                ViewPainter.renderLock.lock();
                try {
                    GlassScene glassScene = this.stage.getScene();
                    if (glassScene == null) break;
                    glassScene.updateSceneState();
                    break;
                }
                finally {
                    ViewPainter.renderLock.unlock();
                }
            }
            case 511: {
                this.stage.stageListener.changedSize(this.window.getWidth(), this.window.getHeight());
                break;
            }
            case 542: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 551: {
                this.stage.stageListener.initAccessibleTKStageListener();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
                break;
            }
            default: {
                if (!QuantumToolkit.verbose) break;
                System.err.println("GlassWindowEventHandler: unknown type: " + this.type);
            }
        }
        return null;
    }

    @Override
    public void handleWindowEvent(Window window, long l, int n) {
        this.window = window;
        this.type = n;
        AccessControlContext accessControlContext = this.stage.getAccessControlContext();
        AccessController.doPrivileged(this, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScreenChangedEvent(Window window, long l, Screen screen, Screen screen2) {
        GlassScene glassScene = this.stage.getScene();
        if (glassScene != null) {
            ViewPainter.renderLock.lock();
            try {
                glassScene.entireSceneNeedsRepaint();
                glassScene.updateSceneState();
            }
            finally {
                ViewPainter.renderLock.unlock();
            }
        }
    }
}

