/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.function.Predicate;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public final class FilteredList<E>
extends TransformationList<E, E> {
    private int[] filtered;
    private int size;
    private SortHelper helper;
    private static final Predicate ALWAYS_TRUE = new Predicate(){

        public boolean test(Object object) {
            return true;
        }
    };
    private final ObjectProperty<Predicate<? super E>> predicate = new ObjectPropertyBase<Predicate<? super E>>(ALWAYS_TRUE){

        @Override
        protected void invalidated() {
            if (this.get() == null && this.isBound()) {
                this.unbind();
                this.set(ALWAYS_TRUE);
                throw new IllegalArgumentException("Predicate cannot be null.");
            }
            FilteredList.this.refilter();
        }

        @Override
        public Object getBean() {
            return FilteredList.this;
        }

        @Override
        public String getName() {
            return "predicate";
        }
    };

    public FilteredList(@NamedArg(value="source") ObservableList<E> observableList, @NamedArg(value="predicate") Predicate<? super E> predicate) {
        super(observableList);
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.filtered = new int[observableList.size() * 3 / 2 + 1];
        this.predicate.set(predicate);
    }

    public FilteredList(@NamedArg(value="source") ObservableList<E> observableList) {
        this(observableList, ALWAYS_TRUE);
    }

    public final ObjectProperty<Predicate<? super E>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<? super E> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public final void setPredicate(Predicate<? super E> predicate) {
        this.predicate.set(predicate);
    }

    @Override
    protected void sourceChanged(ListChangeListener.Change<? extends E> change) {
        this.beginChange();
        while (change.next()) {
            if (change.wasPermutated()) {
                this.permutate(change);
                continue;
            }
            if (change.wasUpdated()) {
                this.update(change);
                continue;
            }
            this.addRemove(change);
        }
        this.endChange();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSource().get(this.filtered[n]);
    }

    @Override
    public int getSourceIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.filtered[n];
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    private int findPosition(int n) {
        if (this.filtered.length == 0) {
            return 0;
        }
        if (n == 0) {
            return 0;
        }
        int n2 = Arrays.binarySearch(this.filtered, 0, this.size, n);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return n2;
    }

    private void ensureSize(int n) {
        if (this.filtered.length < n) {
            int[] nArray = new int[n * 3 / 2 + 1];
            System.arraycopy(this.filtered, 0, nArray, 0, this.size);
            this.filtered = nArray;
        }
    }

    private void updateIndexes(int n, int n2) {
        int n3 = n;
        while (n3 < this.size) {
            int n4 = n3++;
            this.filtered[n4] = this.filtered[n4] + n2;
        }
    }

    private void permutate(ListChangeListener.Change<? extends E> change) {
        int n = this.findPosition(change.getFrom());
        int n2 = this.findPosition(change.getTo());
        if (n2 > n) {
            for (int i = n; i < n2; ++i) {
                this.filtered[i] = change.getPermutation(this.filtered[i]);
            }
            int[] nArray = this.getSortHelper().sort(this.filtered, n, n2);
            this.nextPermutation(n, n2, nArray);
        }
    }

    private void update(ListChangeListener.Change<? extends E> change) {
        int n = this.findPosition(change.getFrom());
        int n2 = this.findPosition(change.getTo());
        for (int i = n; i < n2; ++i) {
            this.nextUpdate(i);
        }
        this.updateFilter(change.getFrom(), change.getTo());
    }

    private void addRemove(ListChangeListener.Change<? extends E> change) {
        int n;
        Predicate predicate = (Predicate)this.predicate.get();
        this.ensureSize(this.getSource().size());
        int n2 = this.findPosition(change.getFrom());
        int n3 = this.findPosition(change.getFrom() + change.getRemovedSize());
        for (n = n2; n < n3; ++n) {
            this.nextRemove(n2, change.getRemoved().get(this.filtered[n] - change.getFrom()));
        }
        this.updateIndexes(n3, change.getAddedSize() - change.getRemovedSize());
        n = n2;
        int n4 = change.getFrom();
        ListIterator listIterator = this.getSource().listIterator(n4);
        while (n < n3 && listIterator.nextIndex() < change.getTo()) {
            if (!predicate.test(listIterator.next())) continue;
            this.filtered[n] = listIterator.previousIndex();
            this.nextAdd(n, n + 1);
            ++n;
        }
        if (n < n3) {
            System.arraycopy(this.filtered, n3, this.filtered, n, this.size - n3);
            this.size -= n3 - n;
        } else {
            while (listIterator.nextIndex() < change.getTo()) {
                if (predicate.test(listIterator.next())) {
                    System.arraycopy(this.filtered, n, this.filtered, n + 1, this.size - n);
                    this.filtered[n] = listIterator.previousIndex();
                    this.nextAdd(n, n + 1);
                    ++n;
                    ++this.size;
                }
                ++n4;
            }
        }
    }

    private void updateFilter(int n, int n2) {
        block8: {
            ListIterator listIterator;
            Predicate predicate;
            block6: {
                Object e;
                int n3;
                block7: {
                    predicate = (Predicate)this.predicate.get();
                    this.beginChange();
                    if (n != n2 - 1) break block6;
                    n3 = this.findPosition(n);
                    e = this.getSource().get(n);
                    if (this.filtered[n3] != n) break block7;
                    if (!predicate.test(e)) {
                        this.nextRemove(n3, e);
                        System.arraycopy(this.filtered, n3 + 1, this.filtered, n3, this.size - n3 - 1);
                        --this.size;
                    }
                    break block8;
                }
                this.ensureSize(this.getSource().size());
                if (!predicate.test(e)) break block8;
                this.nextAdd(n3, n3 + 1);
                System.arraycopy(this.filtered, n3, this.filtered, n3 + 1, this.size - n3);
                this.filtered[n3] = n;
                ++this.size;
                break block8;
            }
            this.ensureSize(this.getSource().size());
            int n4 = this.findPosition(n);
            int n5 = this.findPosition(n2);
            int n6 = n4;
            if (n6 == 0) {
                int n7 = this.size == 0 ? n2 : this.filtered[0];
                listIterator = this.getSource().listIterator(n);
                while (listIterator.nextIndex() < n7) {
                    Object e = listIterator.next();
                    if (!predicate.test(e)) continue;
                    this.nextAdd(n6, n6 + 1);
                    System.arraycopy(this.filtered, n6, this.filtered, n6 + 1, this.size - n6);
                    this.filtered[n6] = listIterator.previousIndex();
                    ++this.size;
                    ++n5;
                    ++n6;
                }
            }
            ListIterator listIterator2 = this.getSource().listIterator(this.filtered[n6]);
            while (n6 < n5) {
                int n8;
                FilteredList.advanceTo(listIterator2, this.filtered[n6]);
                listIterator = listIterator2.next();
                if (!predicate.test(listIterator)) {
                    this.nextRemove(n6, listIterator);
                    System.arraycopy(this.filtered, n6 + 1, this.filtered, n6, this.size - n6 - 1);
                    --this.size;
                    --n5;
                    --n6;
                }
                int n9 = n8 = n6 == n5 - 1 ? n2 : this.filtered[n6 + 1];
                while (listIterator2.nextIndex() < n8) {
                    Object e = listIterator2.next();
                    if (!predicate.test(e)) continue;
                    this.nextAdd(n6 + 1, n6 + 2);
                    System.arraycopy(this.filtered, n6 + 1, this.filtered, n6 + 2, this.size - n6 - 1);
                    this.filtered[n6 + 1] = listIterator2.previousIndex();
                    ++this.size;
                    ++n5;
                    ++n6;
                }
                ++n6;
            }
        }
        this.endChange();
    }

    private static void advanceTo(ListIterator<?> listIterator, int n) {
        while (listIterator.nextIndex() < n) {
            listIterator.next();
        }
    }

    private void refilter() {
        this.ensureSize(this.getSource().size());
        ArrayList arrayList = null;
        if (this.hasListeners()) {
            arrayList = new ArrayList(this);
        }
        this.size = 0;
        int n = 0;
        Predicate predicate = (Predicate)this.predicate.get();
        for (Object e : this.getSource()) {
            if (predicate.test(e)) {
                this.filtered[this.size++] = n;
            }
            ++n;
        }
        if (this.hasListeners()) {
            this.fireChange(new NonIterableChange.GenericAddRemoveChange(0, this.size, arrayList, this));
        }
    }
}

