/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;

class ControlUtils {
    private static final String SCROLL_TO_INDEX_KEY = "util.scroll.index";
    private static final String SCROLL_TO_COLUMN_KEY = "util.scroll.column";

    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int n) {
        if (control.getSkin() == null) {
            ControlUtils.installScrollToIndexCallback(control, control.skinProperty(), n);
        } else {
            ControlUtils.fireScrollToIndexEvent(control, n);
        }
    }

    private static void installScrollToIndexCallback(final Control control, final Observable observable, int n) {
        final ObservableMap<Object, Object> observableMap = control.getProperties();
        if (!observableMap.containsKey(SCROLL_TO_INDEX_KEY)) {
            observable.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable2) {
                    Integer n = (Integer)observableMap.remove(ControlUtils.SCROLL_TO_INDEX_KEY);
                    if (n != null) {
                        ControlUtils.fireScrollToIndexEvent(control, n);
                    }
                    observable.removeListener(this);
                }
            });
        }
        observableMap.put(SCROLL_TO_INDEX_KEY, n);
    }

    private static void fireScrollToIndexEvent(Control control, int n) {
        Event.fireEvent(control, new ScrollToEvent<Integer>(control, control, ScrollToEvent.scrollToTopIndex(), n));
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> tableColumnBase) {
        if (control.getSkin() == null) {
            ControlUtils.installScrollToColumnCallback(control, control.skinProperty(), tableColumnBase);
        } else {
            ControlUtils.fireScrollToColumnEvent(control, tableColumnBase);
        }
    }

    private static void installScrollToColumnCallback(final Control control, final Observable observable, TableColumnBase<?, ?> tableColumnBase) {
        ObservableMap<Object, Object> observableMap = control.getProperties();
        if (!observableMap.containsKey(SCROLL_TO_COLUMN_KEY)) {
            observable.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable2) {
                    TableColumnBase tableColumnBase = (TableColumnBase)control.getProperties().remove(ControlUtils.SCROLL_TO_COLUMN_KEY);
                    if (tableColumnBase != null) {
                        ControlUtils.fireScrollToColumnEvent(control, tableColumnBase);
                    }
                    observable.removeListener(this);
                }
            });
        }
        observableMap.put(SCROLL_TO_COLUMN_KEY, tableColumnBase);
    }

    private static void fireScrollToColumnEvent(Control control, TableColumnBase<?, ?> tableColumnBase) {
        control.fireEvent(new ScrollToEvent(control, control, ScrollToEvent.scrollToColumn(), tableColumnBase));
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control control) {
        Node node;
        Scene scene = control.getScene();
        Node node2 = node = scene == null ? null : scene.getFocusOwner();
        if (node == null) {
            control.requestFocus();
        } else if (!control.equals(node)) {
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!control.equals(parent)) continue;
                control.requestFocus();
                break;
            }
        }
    }
}

