/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.JobManager;
import com.oracle.javafx.scenebuilder.kit.editor.WatchingController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchModifySelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BringForwardJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BringToFrontJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.CutSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DuplicateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.FitToParentSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ImportFileJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.IncludeFileJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsAccessoryJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PasteIntoJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.PasteJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SendBackwardJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SendToBackJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.TrimSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UseComputedSizesSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UsePredefinedSizeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.MoveColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.MoveRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.SpanJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.UnwrapJob;
import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.editor.report.ErrorReport;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.editor.util.ContextMenuController;
import com.oracle.javafx.scenebuilder.kit.editor.util.InlineEditController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.glossary.BuiltinGlossary;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardEncoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.Effect;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class EditorController {
    private final Selection selection = new Selection();
    private final JobManager jobManager = new JobManager(this, 50);
    private final MessageLog messageLog = new MessageLog();
    private final ErrorReport errorReport = new ErrorReport();
    private final DragController dragController = new DragController(this);
    private final InlineEditController inlineEditController = new InlineEditController(this);
    private final ContextMenuController contextMenuController = new ContextMenuController(this);
    private final WatchingController watchingController = new WatchingController(this);
    private double defaultRootContainerWidth = 600.0;
    private double defaultRootContainerHeight = 400.0;
    private final ObjectProperty<FXOMDocument> fxomDocumentProperty = new SimpleObjectProperty();
    private final ObjectProperty<URL> fxmlLocationProperty = new SimpleObjectProperty();
    private final ObjectProperty<Library> libraryProperty = new SimpleObjectProperty((Object)BuiltinLibrary.getLibrary());
    private final ObjectProperty<Glossary> glossaryProperty = new SimpleObjectProperty((Object)new BuiltinGlossary());
    private final ObjectProperty<ResourceBundle> resourcesProperty = new SimpleObjectProperty(null);
    private final ObjectProperty<EditorPlatform.Theme> themeProperty = new SimpleObjectProperty((Object)EditorPlatform.Theme.MODENA);
    private final ListProperty<File> sceneStyleSheetProperty = new SimpleListProperty();
    private final BooleanProperty pickModeEnabledProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty sampleDataEnabledProperty = new SimpleBooleanProperty(false);
    private final SimpleStringProperty toolStylesheetProperty = new SimpleStringProperty(EditorController.getBuiltinToolStylesheet());
    private Callback<Void, Boolean> requestTextEditingSessionEnd;
    private static String builtinToolStylesheet;
    private static List<Class<? extends Parent>> classesSupportingWrapping;
    private static URL stylesheet;
    private final ChangeListener<ClassLoader> libraryClassLoaderListener = new ChangeListener<ClassLoader>(){

        public void changed(ObservableValue<? extends ClassLoader> ov, ClassLoader t, ClassLoader t1) {
            EditorController.this.libraryClassLoaderDidChange();
        }
    };

    public EditorController() {
        this.jobManager.revisionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                EditorController.this.jobManagerRevisionDidChange();
            }
        });
    }

    public double getDefaultRootContainerWidth() {
        return this.defaultRootContainerWidth;
    }

    public void setDefaultRootContainerWidth(double defaultRootContainerWidth) {
        this.defaultRootContainerWidth = defaultRootContainerWidth;
    }

    public double getDefaultRootContainerHeight() {
        return this.defaultRootContainerHeight;
    }

    public void setDefaultRootContainerHeight(double defaultRootContainerHeight) {
        this.defaultRootContainerHeight = defaultRootContainerHeight;
    }

    public void setFxmlText(String fxmlText) throws IOException {
        this.setFxmlTextAndLocation(fxmlText, this.getFxmlLocation());
    }

    public String getFxmlText() {
        String result;
        FXOMDocument fxomDocument = this.getFxomDocument();
        if (fxomDocument == null) {
            result = null;
        } else {
            boolean sampleDataEnabled = fxomDocument.isSampleDataEnabled();
            if (sampleDataEnabled) {
                fxomDocument.setSampleDataEnabled(false);
            }
            result = fxomDocument.getFxmlText();
            if (sampleDataEnabled) {
                fxomDocument.setSampleDataEnabled(true);
            }
        }
        return result;
    }

    public boolean canGetFxmlText() {
        boolean result;
        if (this.requestTextEditingSessionEnd == null) {
            result = true;
        } else {
            result = (Boolean)this.requestTextEditingSessionEnd.call(null);
            assert (this.requestTextEditingSessionEnd == null || !result);
        }
        return result;
    }

    public void textEditingSessionDidBegin(Callback<Void, Boolean> requestSessionEnd) {
        assert (this.requestTextEditingSessionEnd == null);
        this.requestTextEditingSessionEnd = requestSessionEnd;
    }

    public void textEditingSessionDidEnd() {
        assert (this.requestTextEditingSessionEnd != null);
        this.requestTextEditingSessionEnd = null;
    }

    public boolean isTextEditingSessionOnGoing() {
        return this.requestTextEditingSessionEnd != null;
    }

    public ObservableValue<URL> fxmlLocationProperty() {
        return this.fxmlLocationProperty;
    }

    public void setFxmlLocation(URL fxmlLocation) {
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
        if (this.getFxomDocument() != null) {
            this.getFxomDocument().setLocation(fxmlLocation);
            this.clearUndoRedo();
        }
    }

    public Library getLibrary() {
        return (Library)this.libraryProperty.getValue();
    }

    public void setLibrary(Library library) {
        assert (library != null);
        ((Library)this.libraryProperty.getValue()).classLoaderProperty().removeListener(this.libraryClassLoaderListener);
        this.libraryProperty.setValue((Object)library);
        ((Library)this.libraryProperty.getValue()).classLoaderProperty().addListener(this.libraryClassLoaderListener);
        this.libraryClassLoaderDidChange();
    }

    public ObservableValue<Library> libraryProperty() {
        return this.libraryProperty;
    }

    public Glossary getGlossary() {
        return (Glossary)this.glossaryProperty.getValue();
    }

    public void setLibrary(Glossary glossary) {
        assert (glossary != null);
        this.glossaryProperty.setValue((Object)glossary);
    }

    public ObservableValue<Glossary> glossaryProperty() {
        return this.glossaryProperty;
    }

    public ResourceBundle getResources() {
        return (ResourceBundle)this.resourcesProperty.getValue();
    }

    public void setResources(ResourceBundle resources) {
        this.resourcesProperty.setValue((Object)resources);
        this.resourcesDidChange();
    }

    public ObservableValue<ResourceBundle> resourcesProperty() {
        return this.resourcesProperty;
    }

    public EditorPlatform.Theme getTheme() {
        return (EditorPlatform.Theme)((Object)this.themeProperty.getValue());
    }

    public void setTheme(EditorPlatform.Theme theme) {
        this.themeProperty.setValue((Object)theme);
    }

    public ObservableValue<EditorPlatform.Theme> themeProperty() {
        return this.themeProperty;
    }

    public ObservableList<File> getSceneStyleSheets() {
        return this.sceneStyleSheetProperty.getValue();
    }

    public void setSceneStyleSheets(ObservableList<File> styleSheets) {
        this.sceneStyleSheetProperty.setValue(styleSheets);
    }

    public ObservableListValue<File> sceneStyleSheetProperty() {
        return this.sceneStyleSheetProperty;
    }

    public boolean isPickModeEnabled() {
        return this.pickModeEnabledProperty.getValue();
    }

    public void setPickModeEnabled(boolean pickModeEnabled) {
        this.pickModeEnabledProperty.setValue(Boolean.valueOf(pickModeEnabled));
    }

    public ObservableValue<Boolean> pickModeEnabledProperty() {
        return this.pickModeEnabledProperty;
    }

    public boolean isSampleDataEnabled() {
        return this.sampleDataEnabledProperty.getValue();
    }

    public void setSampleDataEnabled(boolean sampleDataEnabled) {
        this.sampleDataEnabledProperty.setValue(Boolean.valueOf(sampleDataEnabled));
        if (this.getFxomDocument() != null) {
            this.getFxomDocument().setSampleDataEnabled(this.isSampleDataEnabled());
        }
    }

    public ObservableValue<Boolean> sampleDataEnabledProperty() {
        return this.sampleDataEnabledProperty;
    }

    public URL getFxmlLocation() {
        return (URL)this.fxmlLocationProperty.getValue();
    }

    public void setFxmlTextAndLocation(String fxmlText, URL fxmlLocation) throws IOException {
        this.updateFxomDocument(fxmlText, fxmlLocation, this.getResources());
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
    }

    public void setFxmlTextLocationAndResources(String fxmlText, URL fxmlLocation, ResourceBundle resources) throws IOException {
        this.updateFxomDocument(fxmlText, fxmlLocation, resources);
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
    }

    public ObservableValue<FXOMDocument> fxomDocumentProperty() {
        return this.fxomDocumentProperty;
    }

    public FXOMDocument getFxomDocument() {
        return (FXOMDocument)this.fxomDocumentProperty.getValue();
    }

    public String getToolStylesheet() {
        return this.toolStylesheetProperty.getValue();
    }

    public void setToolStylesheet(String stylesheet) {
        assert (stylesheet != null);
        this.toolStylesheetProperty.setValue(stylesheet);
    }

    public ObservableValue<String> toolStylesheetProperty() {
        return this.toolStylesheetProperty;
    }

    public static synchronized String getBuiltinToolStylesheet() {
        if (builtinToolStylesheet == null) {
            URL url = EditorController.class.getResource("css/Theme.css");
            assert (url != null);
            builtinToolStylesheet = url.toExternalForm();
        }
        return builtinToolStylesheet;
    }

    public void startFileWatching() {
        this.watchingController.start();
    }

    public void stopFileWatching() {
        this.watchingController.stop();
    }

    public boolean isFileWatchingStarted() {
        return this.watchingController.isStarted();
    }

    public Selection getSelection() {
        return this.selection;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    public ErrorReport getErrorReport() {
        return this.errorReport;
    }

    public DragController getDragController() {
        return this.dragController;
    }

    public InlineEditController getInlineEditController() {
        return this.inlineEditController;
    }

    public ContextMenuController getContextMenuController() {
        return this.contextMenuController;
    }

    public boolean canUndo() {
        return this.jobManager.canUndo();
    }

    public String getUndoDescription() {
        return this.jobManager.getUndoDescription();
    }

    public void undo() {
        this.jobManager.undo();
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public boolean canRedo() {
        return this.jobManager.canRedo();
    }

    public String getRedoDescription() {
        return this.jobManager.getRedoDescription();
    }

    public void redo() {
        this.jobManager.redo();
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public void clearUndoRedo() {
        this.jobManager.clear();
    }

    public void performEditAction(EditAction editAction) {
        switch (editAction) {
            case ADD_CONTEXT_MENU: {
                this.performAddContextMenu();
                break;
            }
            case ADD_TOOLTIP: {
                this.performAddTooltip();
                break;
            }
            case ADD_COLUMN_BEFORE: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                this.jobManager.push(job);
                break;
            }
            case ADD_COLUMN_AFTER: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.AFTER);
                this.jobManager.push(job);
                break;
            }
            case ADD_ROW_ABOVE: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.ABOVE);
                this.jobManager.push(job);
                break;
            }
            case ADD_ROW_BELOW: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.BELOW);
                this.jobManager.push(job);
                break;
            }
            case BRING_FORWARD: {
                BringForwardJob job = new BringForwardJob(this);
                this.jobManager.push(job);
                break;
            }
            case BRING_TO_FRONT: {
                BringToFrontJob job = new BringToFrontJob(this);
                this.jobManager.push(job);
                break;
            }
            case CUT: {
                CutSelectionJob job = new CutSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case DECREASE_COLUMN_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_COLUMN_SPAN);
                this.jobManager.push(job);
                break;
            }
            case DECREASE_ROW_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_ROW_SPAN);
                this.jobManager.push(job);
                break;
            }
            case DELETE: {
                DeleteSelectionJob job = new DeleteSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case DUPLICATE: {
                DuplicateSelectionJob job = new DuplicateSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case FIT_TO_PARENT: {
                FitToParentSelectionJob job = new FitToParentSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case INCREASE_COLUMN_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_COLUMN_SPAN);
                this.jobManager.push(job);
                break;
            }
            case INCREASE_ROW_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_ROW_SPAN);
                this.jobManager.push(job);
                break;
            }
            case MOVE_COLUMN_BEFORE: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                this.jobManager.push(job);
                break;
            }
            case MOVE_COLUMN_AFTER: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.AFTER);
                this.jobManager.push(job);
                break;
            }
            case MOVE_ROW_ABOVE: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.ABOVE);
                this.jobManager.push(job);
                break;
            }
            case MOVE_ROW_BELOW: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.BELOW);
                this.jobManager.push(job);
                break;
            }
            case PASTE: {
                PasteJob job = new PasteJob(this);
                this.jobManager.push(job);
                break;
            }
            case PASTE_INTO: {
                PasteIntoJob job = new PasteIntoJob(this);
                this.jobManager.push(job);
                break;
            }
            case SEND_BACKWARD: {
                SendBackwardJob job = new SendBackwardJob(this);
                this.jobManager.push(job);
                break;
            }
            case SEND_TO_BACK: {
                SendToBackJob job = new SendToBackJob(this);
                this.jobManager.push(job);
                break;
            }
            case SET_SIZE_320x240: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_320x240);
                this.jobManager.push(job);
                break;
            }
            case SET_SIZE_640x480: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_640x480);
                this.jobManager.push(job);
                break;
            }
            case SET_SIZE_1280x800: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1280x800);
                this.jobManager.push(job);
                break;
            }
            case SET_SIZE_1920x1080: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1920x1080);
                this.jobManager.push(job);
                break;
            }
            case TRIM: {
                TrimSelectionJob job = new TrimSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case UNWRAP: {
                UnwrapJob job = new UnwrapJob(this);
                this.jobManager.push(job);
                break;
            }
            case USE_COMPUTED_SIZES: {
                UseComputedSizesSelectionJob job = new UseComputedSizesSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case WRAP_IN_ANCHOR_PANE: {
                this.performWrap(AnchorPane.class);
                break;
            }
            case WRAP_IN_GRID_PANE: {
                this.performWrap(GridPane.class);
                break;
            }
            case WRAP_IN_GROUP: {
                this.performWrap(Group.class);
                break;
            }
            case WRAP_IN_HBOX: {
                this.performWrap(HBox.class);
                break;
            }
            case WRAP_IN_PANE: {
                this.performWrap(Pane.class);
                break;
            }
            case WRAP_IN_SCROLL_PANE: {
                this.performWrap(ScrollPane.class);
                break;
            }
            case WRAP_IN_SPLIT_PANE: {
                this.performWrap(SplitPane.class);
                break;
            }
            case WRAP_IN_STACK_PANE: {
                this.performWrap(StackPane.class);
                break;
            }
            case WRAP_IN_TAB_PANE: {
                this.performWrap(TabPane.class);
                break;
            }
            case WRAP_IN_TITLED_PANE: {
                this.performWrap(TitledPane.class);
                break;
            }
            case WRAP_IN_TOOL_BAR: {
                this.performWrap(ToolBar.class);
                break;
            }
            case WRAP_IN_VBOX: {
                this.performWrap(VBox.class);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public boolean canPerformEditAction(EditAction editAction) {
        boolean result;
        switch (editAction) {
            case ADD_CONTEXT_MENU: {
                result = this.canPerformAddContextMenu();
                break;
            }
            case ADD_TOOLTIP: {
                result = this.canPerformAddTooltip();
                break;
            }
            case ADD_COLUMN_BEFORE: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                result = job.isExecutable();
                break;
            }
            case ADD_COLUMN_AFTER: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.AFTER);
                result = job.isExecutable();
                break;
            }
            case ADD_ROW_ABOVE: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.ABOVE);
                result = job.isExecutable();
                break;
            }
            case ADD_ROW_BELOW: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.BELOW);
                result = job.isExecutable();
                break;
            }
            case BRING_FORWARD: {
                BringForwardJob job = new BringForwardJob(this);
                result = job.isExecutable();
                break;
            }
            case BRING_TO_FRONT: {
                BringToFrontJob job = new BringToFrontJob(this);
                result = job.isExecutable();
                break;
            }
            case CUT: {
                CutSelectionJob job = new CutSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case DECREASE_COLUMN_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_COLUMN_SPAN);
                result = job.isExecutable();
                break;
            }
            case DECREASE_ROW_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_ROW_SPAN);
                result = job.isExecutable();
                break;
            }
            case DELETE: {
                DeleteSelectionJob job = new DeleteSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case DUPLICATE: {
                DuplicateSelectionJob job = new DuplicateSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case FIT_TO_PARENT: {
                FitToParentSelectionJob job = new FitToParentSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case INCREASE_COLUMN_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_COLUMN_SPAN);
                result = job.isExecutable();
                break;
            }
            case INCREASE_ROW_SPAN: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_ROW_SPAN);
                result = job.isExecutable();
                break;
            }
            case MOVE_COLUMN_BEFORE: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                result = job.isExecutable();
                break;
            }
            case MOVE_COLUMN_AFTER: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.AFTER);
                result = job.isExecutable();
                break;
            }
            case MOVE_ROW_ABOVE: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.ABOVE);
                result = job.isExecutable();
                break;
            }
            case MOVE_ROW_BELOW: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.BELOW);
                result = job.isExecutable();
                break;
            }
            case PASTE: {
                PasteJob job = new PasteJob(this);
                result = job.isExecutable();
                break;
            }
            case PASTE_INTO: {
                PasteIntoJob job = new PasteIntoJob(this);
                result = job.isExecutable();
                break;
            }
            case SEND_BACKWARD: {
                SendBackwardJob job = new SendBackwardJob(this);
                result = job.isExecutable();
                break;
            }
            case SEND_TO_BACK: {
                SendToBackJob job = new SendToBackJob(this);
                result = job.isExecutable();
                break;
            }
            case SET_SIZE_320x240: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_320x240);
                result = job.isExecutable();
                break;
            }
            case SET_SIZE_640x480: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_640x480);
                result = job.isExecutable();
                break;
            }
            case SET_SIZE_1280x800: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1280x800);
                result = job.isExecutable();
                break;
            }
            case SET_SIZE_1920x1080: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1920x1080);
                result = job.isExecutable();
                break;
            }
            case TRIM: {
                TrimSelectionJob job = new TrimSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case UNWRAP: {
                UnwrapJob job = new UnwrapJob(this);
                result = job.isExecutable();
                break;
            }
            case USE_COMPUTED_SIZES: {
                UseComputedSizesSelectionJob job = new UseComputedSizesSelectionJob(this);
                result = job.isExecutable();
                break;
            }
            case WRAP_IN_ANCHOR_PANE: {
                result = this.canPerformWrap(AnchorPane.class);
                break;
            }
            case WRAP_IN_GRID_PANE: {
                result = this.canPerformWrap(GridPane.class);
                break;
            }
            case WRAP_IN_GROUP: {
                result = this.canPerformWrap(Group.class);
                break;
            }
            case WRAP_IN_HBOX: {
                result = this.canPerformWrap(HBox.class);
                break;
            }
            case WRAP_IN_PANE: {
                result = this.canPerformWrap(Pane.class);
                break;
            }
            case WRAP_IN_SCROLL_PANE: {
                result = this.canPerformWrap(ScrollPane.class);
                break;
            }
            case WRAP_IN_SPLIT_PANE: {
                result = this.canPerformWrap(SplitPane.class);
                break;
            }
            case WRAP_IN_STACK_PANE: {
                result = this.canPerformWrap(StackPane.class);
                break;
            }
            case WRAP_IN_TAB_PANE: {
                result = this.canPerformWrap(TabPane.class);
                break;
            }
            case WRAP_IN_TITLED_PANE: {
                result = this.canPerformWrap(TitledPane.class);
                break;
            }
            case WRAP_IN_TOOL_BAR: {
                result = this.canPerformWrap(ToolBar.class);
                break;
            }
            case WRAP_IN_VBOX: {
                result = this.canPerformWrap(VBox.class);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void performControlAction(ControlAction controlAction) {
        switch (controlAction) {
            case COPY: {
                this.performCopy();
                break;
            }
            case EDIT_INCLUDED_FILE: {
                this.performEditIncludedFile();
                break;
            }
            case REVEAL_INCLUDED_FILE: {
                this.performRevealIncludedFile();
                break;
            }
            case SELECT_ALL: {
                this.performSelectAll();
                break;
            }
            case SELECT_NONE: {
                this.performSelectNone();
                break;
            }
            case SELECT_PARENT: {
                this.performSelectParent();
                break;
            }
            case SELECT_NEXT: {
                this.performSelectNext();
                break;
            }
            case SELECT_PREVIOUS: {
                this.performSelectPrevious();
                break;
            }
            case TOGGLE_SAMPLE_DATA: {
                this.setSampleDataEnabled(!this.isSampleDataEnabled());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
    }

    public boolean canPerformControlAction(ControlAction controlAction) {
        boolean result;
        if (this.getFxomDocument() == null || this.getFxomDocument().getFxomRoot() == null) {
            return false;
        }
        switch (controlAction) {
            case COPY: {
                result = this.canPerformCopy();
                break;
            }
            case EDIT_INCLUDED_FILE: 
            case REVEAL_INCLUDED_FILE: {
                result = this.canPerformIncludedFileAction();
                break;
            }
            case SELECT_ALL: {
                result = this.canPerformSelectAll();
                break;
            }
            case SELECT_NONE: {
                result = this.canPerformSelectNone();
                break;
            }
            case SELECT_PARENT: {
                result = this.canPerformSelectParent();
                break;
            }
            case SELECT_NEXT: {
                result = this.canPerformSelectNext();
                break;
            }
            case SELECT_PREVIOUS: {
                result = this.canPerformSelectPrevious();
                break;
            }
            case TOGGLE_SAMPLE_DATA: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void performImportFxml(File fxmlFile) {
        this.performImport(fxmlFile);
    }

    public void performImportMedia(File mediaFile) {
        this.performImport(mediaFile);
    }

    private void performImport(File file) {
        ImportFileJob job = new ImportFileJob(file, this);
        if (job.isExecutable()) {
            this.jobManager.push(job);
        } else {
            Object sceneGraphTarget;
            String target = job.getTargetObject() == null ? null : ((sceneGraphTarget = job.getTargetObject().getSceneGraphObject()) == null ? null : sceneGraphTarget.getClass().getSimpleName());
            if (target != null) {
                this.getMessageLog().logWarningMessage("import.from.file.failed.target", file.getName(), target);
            } else {
                this.getMessageLog().logWarningMessage("import.from.file.failed", file.getName());
            }
        }
    }

    public void performIncludeFxml(File fxmlFile) {
        IncludeFileJob job = new IncludeFileJob(fxmlFile, this);
        if (job.isExecutable()) {
            this.jobManager.push(job);
        } else {
            Object sceneGraphTarget;
            String target = job.getTargetObject() == null ? null : ((sceneGraphTarget = job.getTargetObject().getSceneGraphObject()) == null ? null : sceneGraphTarget.getClass().getSimpleName());
            if (target != null) {
                this.getMessageLog().logWarningMessage("include.file.failed.target", fxmlFile.getName(), target);
            } else {
                this.getMessageLog().logWarningMessage("include.file.failed", fxmlFile.getName());
            }
        }
    }

    public void performInsert(LibraryItem libraryItem) {
        Job job;
        assert (this.canPerformInsert(libraryItem));
        FXOMDocument newItemDocument = libraryItem.instantiate();
        assert (newItemDocument != null);
        FXOMObject newObject = newItemDocument.getFxomRoot();
        assert (newObject != null);
        newObject.moveToFxomDocument(this.getFxomDocument());
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        if (rootObject == null) {
            job = new BatchJob(this, true, I18N.getString("drop.job.insert.library.item", libraryItem.getName()));
            ((BatchJob)job).addSubJob(new SetDocumentRootJob(newObject, this));
            DesignHierarchyMask mask = new DesignHierarchyMask(newObject);
            if (mask.needResizeWhenTopElement()) {
                ((BatchJob)job).addSubJob(new UsePredefinedSizeJob(this, Size.SIZE_DEFAULT, newObject));
            }
            ((BatchJob)job).addSubJob(new UpdateSelectionJob(newObject, this));
        } else {
            FXOMObject target = this.selection.isEmpty() || this.selection.isSelected(rootObject) ? rootObject : this.selection.getAncestor();
            job = new InsertAsSubComponentJob(newObject, target, -1, this);
        }
        this.jobManager.push(job);
    }

    public boolean canPerformInsert(LibraryItem libraryItem) {
        boolean result;
        if (this.getFxomDocument() == null) {
            result = false;
        } else {
            assert (libraryItem.getLibrary().getClassLoader() == null || libraryItem.getLibrary().getClassLoader() == this.getFxomDocument().getClassLoader());
            FXOMDocument newItemDocument = libraryItem.instantiate();
            if (newItemDocument == null) {
                result = false;
            } else {
                FXOMObject newItemRoot = newItemDocument.getFxomRoot();
                newItemRoot.moveToFxomDocument(this.getFxomDocument());
                assert (newItemDocument.getFxomRoot() == null);
                FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
                if (rootObject == null) {
                    SetDocumentRootJob job = new SetDocumentRootJob(newItemRoot, this);
                    result = job.isExecutable();
                } else {
                    FXOMObject targetCandidate = this.selection.isEmpty() || this.selection.isSelected(rootObject) ? rootObject : this.selection.getAncestor();
                    InsertAsSubComponentJob job = new InsertAsSubComponentJob(newItemRoot, targetCandidate, -1, this);
                    result = job.isExecutable();
                }
            }
        }
        return result;
    }

    public void performWrap(Class<? extends Parent> wrappingClass) {
        assert (this.canPerformWrap(wrappingClass));
        AbstractWrapInJob job = AbstractWrapInJob.getWrapInJob(this, wrappingClass);
        this.jobManager.push(job);
    }

    public boolean canPerformWrap(Class<? extends Parent> wrappingClass) {
        if (!EditorController.getClassesSupportingWrapping().contains(wrappingClass)) {
            return false;
        }
        AbstractWrapInJob job = AbstractWrapInJob.getWrapInJob(this, wrappingClass);
        return job.isExecutable();
    }

    public static synchronized Collection<Class<? extends Parent>> getClassesSupportingWrapping() {
        if (classesSupportingWrapping == null) {
            classesSupportingWrapping = new ArrayList<Class<? extends Parent>>();
            classesSupportingWrapping.add(AnchorPane.class);
            classesSupportingWrapping.add(GridPane.class);
            classesSupportingWrapping.add(Group.class);
            classesSupportingWrapping.add(HBox.class);
            classesSupportingWrapping.add(Pane.class);
            classesSupportingWrapping.add(ScrollPane.class);
            classesSupportingWrapping.add(SplitPane.class);
            classesSupportingWrapping.add(StackPane.class);
            classesSupportingWrapping.add(TabPane.class);
            classesSupportingWrapping.add(TitledPane.class);
            classesSupportingWrapping.add(ToolBar.class);
            classesSupportingWrapping.add(VBox.class);
            classesSupportingWrapping = Collections.unmodifiableList(classesSupportingWrapping);
        }
        return classesSupportingWrapping;
    }

    private void performCopy() {
        assert (this.canPerformCopy());
        assert (this.selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)this.selection.getGroup();
        ClipboardEncoder encoder = new ClipboardEncoder(osg.getSortedItems());
        assert (encoder.isEncodable());
        Clipboard.getSystemClipboard().setContent((Map)encoder.makeEncoding());
    }

    private boolean canPerformCopy() {
        return this.selection.getGroup() instanceof ObjectSelectionGroup;
    }

    private void performSelectAll() {
        assert (this.canPerformSelectAll());
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        if (this.selection.isEmpty()) {
            this.selection.select(rootObject);
        } else if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
            FXOMObject ancestor = this.selection.getAncestor();
            assert (ancestor != null);
            DesignHierarchyMask mask = new DesignHierarchyMask(ancestor);
            HashSet<FXOMObject> selectableObjects = new HashSet<FXOMObject>();
            if (mask.getFxomObject().getSceneGraphObject() instanceof BorderPane) {
                FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
                FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
                FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
                FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
                FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
                for (FXOMObject accessoryObject : new FXOMObject[]{top, left, center, right, bottom}) {
                    if (accessoryObject == null) continue;
                    selectableObjects.add(accessoryObject);
                }
            } else {
                assert (mask.isAcceptingSubComponent());
                selectableObjects.addAll(mask.getSubComponents());
            }
            this.selection.select(selectableObjects);
        } else if (this.selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)this.selection.getGroup();
            FXOMObject gridPane = gsg.getParentObject();
            assert (gridPane instanceof FXOMInstance);
            DesignHierarchyMask gridPaneMask = new DesignHierarchyMask(gridPane);
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = gridPaneMask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = gridPaneMask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), 0);
            for (int index = 1; index < size; ++index) {
                this.selection.toggleSelection((FXOMInstance)gridPane, gsg.getType(), index);
            }
        } else assert (this.selection.getGroup() == null) : "Add implementation for " + this.selection.getGroup();
    }

    private boolean canPerformSelectAll() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return true;
        }
        if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
            FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
            if (this.selection.isSelected(rootObject)) {
                return false;
            }
            FXOMObject ancestor = this.selection.getAncestor();
            assert (ancestor != null);
            DesignHierarchyMask mask = new DesignHierarchyMask(ancestor);
            if (mask.getFxomObject().getSceneGraphObject() instanceof BorderPane) {
                FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
                FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
                FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
                FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
                FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
                for (FXOMObject bpAccessoryObject : new FXOMObject[]{top, left, center, right, bottom}) {
                    if (bpAccessoryObject == null || this.selection.isSelected(bpAccessoryObject)) continue;
                    return true;
                }
            } else if (mask.isAcceptingSubComponent()) {
                for (FXOMObject subComponentObject : mask.getSubComponents()) {
                    if (this.selection.isSelected(subComponentObject)) continue;
                    return true;
                }
            }
        } else {
            if (this.selection.getGroup() instanceof GridSelectionGroup) {
                GridSelectionGroup gsg = (GridSelectionGroup)this.selection.getGroup();
                assert (!gsg.getIndexes().isEmpty());
                return true;
            }
            assert (this.selection.getGroup() == null) : "Add implementation for " + this.selection.getGroup();
        }
        return false;
    }

    private void performSelectParent() {
        assert (this.canPerformSelectParent());
        FXOMObject ancestor = this.selection.getAncestor();
        assert (ancestor != null);
        this.selection.select(ancestor);
    }

    private boolean canPerformSelectParent() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        return !this.selection.isEmpty() && !this.selection.isSelected(rootObject);
    }

    private void performSelectNext() {
        assert (this.canPerformSelectNext());
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            assert (items.size() == 1);
            FXOMObject selectedObject = items.iterator().next();
            FXOMObject nextSibling = selectedObject.getNextSlibing();
            assert (nextSibling != null);
            this.selection.select(nextSibling);
        } else {
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            assert (gridPane instanceof FXOMInstance);
            Set<Integer> indexes = gsg.getIndexes();
            assert (indexes.size() == 1);
            int selectedIndex = indexes.iterator().next();
            int nextIndex = selectedIndex + 1;
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = mask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = mask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (nextIndex < size);
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), nextIndex);
        }
    }

    private boolean canPerformSelectNext() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            if (items.size() != 1) {
                return false;
            }
            FXOMObject selectedObject = items.iterator().next();
            return selectedObject.getNextSlibing() != null;
        }
        if (asg instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            Set<Integer> indexes = gsg.getIndexes();
            if (indexes.size() != 1) {
                return false;
            }
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = mask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = mask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            int index = indexes.iterator().next();
            return index < size - 1;
        }
        assert (this.selection.getGroup() == null) : "Add implementation for " + this.selection.getGroup();
        return false;
    }

    private void performSelectPrevious() {
        assert (this.canPerformSelectPrevious());
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            assert (items.size() == 1);
            FXOMObject selectedObject = items.iterator().next();
            FXOMObject previousSibling = selectedObject.getPreviousSlibing();
            assert (previousSibling != null);
            this.selection.select(previousSibling);
        } else {
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            FXOMObject gridPane = gsg.getParentObject();
            assert (gridPane instanceof FXOMInstance);
            Set<Integer> indexes = gsg.getIndexes();
            assert (indexes.size() == 1);
            int selectedIndex = indexes.iterator().next();
            int previousIndex = selectedIndex - 1;
            assert (previousIndex >= 0);
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), previousIndex);
        }
    }

    private boolean canPerformSelectPrevious() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            if (items.size() != 1) {
                return false;
            }
            FXOMObject selectedObject = items.iterator().next();
            return selectedObject.getPreviousSlibing() != null;
        }
        if (asg instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            Set<Integer> indexes = gsg.getIndexes();
            if (indexes.size() != 1) {
                return false;
            }
            int index = indexes.iterator().next();
            return index > 0;
        }
        assert (this.selection.getGroup() == null) : "Add implementation for " + this.selection.getGroup();
        return false;
    }

    private void performSelectNone() {
        assert (this.canPerformSelectNone());
        this.selection.clear();
    }

    private boolean canPerformSelectNone() {
        return !this.getSelection().isEmpty();
    }

    public File getIncludedFile() {
        AbstractSelectionGroup asg = this.getSelection().getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return null;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (osg.getItems().size() != 1) {
            return null;
        }
        FXOMObject fxomObject = osg.getItems().iterator().next();
        if (!(fxomObject instanceof FXOMIntrinsic)) {
            return null;
        }
        FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fxomObject;
        if (fxomIntrinsic.getType() != FXOMIntrinsic.Type.FX_INCLUDE) {
            return null;
        }
        String source = fxomIntrinsic.getSource();
        if (source == null) {
            return null;
        }
        if (source.startsWith("/")) {
            ClassLoader classLoader = this.getFxomDocument().getClassLoader();
            if (classLoader != null) {
                File file;
                PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH, source);
                URL url = pv.resolveClassLoaderRelativePath(classLoader);
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException(ex);
                }
                return file;
            }
        } else {
            URL location = this.getFxmlLocation();
            if (location != null) {
                File file;
                PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH, source);
                URL url = pv.resolveDocumentRelativePath(location);
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException(ex);
                }
                return file;
            }
        }
        return null;
    }

    private boolean canPerformIncludedFileAction() {
        return this.getIncludedFile() != null;
    }

    private void performEditIncludedFile() {
        assert (this.canPerformIncludedFileAction());
        File includedFile = this.getIncludedFile();
        assert (includedFile != null);
        try {
            EditorPlatform.open(includedFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.file.open.title"));
            errorDialog.setMessage(I18N.getString("error.file.open.message", includedFile.getAbsolutePath()));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    private void performRevealIncludedFile() {
        assert (this.canPerformIncludedFileAction());
        File includedFile = this.getIncludedFile();
        assert (includedFile != null);
        try {
            EditorPlatform.revealInFileBrowser(includedFile);
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.file.reveal.title"));
            errorDialog.setMessage(I18N.getString("error.file.reveal.message", includedFile.getAbsolutePath()));
            errorDialog.setDetails(I18N.getString("error.write.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    public boolean canPerformSetEffect() {
        return this.isSelectionNode();
    }

    public void performSetEffect(Class<? extends Effect> effectClass) {
        assert (this.canPerformSetEffect());
        Effect effect = Utils.newInstance(effectClass);
        PropertyName pn = new PropertyName("effect");
        PropertyMetadata pm = Metadata.getMetadata().queryProperty(Node.class, pn);
        assert (pm instanceof ValuePropertyMetadata);
        ValuePropertyMetadata vpm = (ValuePropertyMetadata)pm;
        BatchModifySelectionJob job = new BatchModifySelectionJob(vpm, effect, this);
        this.getJobManager().push(job);
    }

    public boolean canPerformAddContextMenu() {
        return this.isSelectionControl();
    }

    public void performAddContextMenu() {
        assert (this.canPerformAddContextMenu());
        String contextMenuFxmlPath = "builtin/ContextMenu.fxml";
        URL contextMenuFxmlURL = BuiltinLibrary.class.getResource("builtin/ContextMenu.fxml");
        assert (contextMenuFxmlURL != null);
        try {
            String contextMenuFxmlText = FXOMDocument.readContentFromURL(contextMenuFxmlURL);
            AbstractSelectionGroup asg = this.selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            BatchJob job = new BatchJob(this, true, I18N.getString("label.action.edit.add.context.menu"));
            for (FXOMObject fxomObject : osg.getItems()) {
                FXOMDocument contextMenuDocument = new FXOMDocument(contextMenuFxmlText, contextMenuFxmlURL, this.getLibrary().getClassLoader(), null);
                assert (contextMenuDocument != null);
                FXOMObject contextMenuObject = contextMenuDocument.getFxomRoot();
                assert (contextMenuObject != null);
                contextMenuObject.moveToFxomDocument(this.getFxomDocument());
                assert (contextMenuDocument.getFxomRoot() == null);
                InsertAsAccessoryJob insertJob = new InsertAsAccessoryJob(contextMenuObject, fxomObject, DesignHierarchyMask.Accessory.CONTEXT_MENU, this);
                job.addSubJob(insertJob);
            }
            this.getJobManager().push(job);
        }
        catch (IOException x) {
            throw new IllegalStateException("Bug in " + this.getClass().getSimpleName(), x);
        }
    }

    public boolean canPerformAddTooltip() {
        return this.isSelectionControl();
    }

    public void performAddTooltip() {
        assert (this.canPerformAddTooltip());
        String tooltipFxmlPath = "builtin/Tooltip.fxml";
        URL tooltipFxmlURL = BuiltinLibrary.class.getResource("builtin/Tooltip.fxml");
        assert (tooltipFxmlURL != null);
        try {
            String tooltipFxmlText = FXOMDocument.readContentFromURL(tooltipFxmlURL);
            AbstractSelectionGroup asg = this.selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            BatchJob job = new BatchJob(this, true, I18N.getString("label.action.edit.add.tooltip"));
            for (FXOMObject fxomObject : osg.getItems()) {
                FXOMDocument tooltipDocument = new FXOMDocument(tooltipFxmlText, tooltipFxmlURL, this.getLibrary().getClassLoader(), null);
                assert (tooltipDocument != null);
                FXOMObject tooltipObject = tooltipDocument.getFxomRoot();
                assert (tooltipObject != null);
                tooltipObject.moveToFxomDocument(this.getFxomDocument());
                assert (tooltipDocument.getFxomRoot() == null);
                InsertAsAccessoryJob insertJob = new InsertAsAccessoryJob(tooltipObject, fxomObject, DesignHierarchyMask.Accessory.TOOLTIP, this);
                job.addSubJob(insertJob);
            }
            this.getJobManager().push(job);
        }
        catch (IOException x) {
            throw new IllegalStateException("Bug in " + this.getClass().getSimpleName(), x);
        }
    }

    public static synchronized URL getStylesheet() {
        if (stylesheet == null) {
            stylesheet = EditorController.class.getResource("EditorController.css");
            assert (stylesheet != null);
        }
        return stylesheet;
    }

    public boolean is3D() {
        Object sgroot;
        boolean res = false;
        FXOMDocument doc = this.getFxomDocument();
        if (doc != null && (sgroot = doc.getSceneGraphRoot()) instanceof Node) {
            Bounds rootBounds = ((Node)sgroot).getLayoutBounds();
            res = rootBounds.getDepth() > 0.0;
        }
        return res;
    }

    public boolean isNode() {
        Object sgroot;
        boolean res = false;
        FXOMDocument doc = this.getFxomDocument();
        if (doc != null && (sgroot = doc.getSceneGraphRoot()) instanceof Node) {
            res = true;
        }
        return res;
    }

    public boolean isSelectionNode() {
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            for (FXOMObject fxomObject : osg.getItems()) {
                boolean isNode = fxomObject.getSceneGraphObject() instanceof Node;
                if (isNode) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isSelectionControl() {
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            for (FXOMObject fxomObject : osg.getItems()) {
                boolean isControl = fxomObject.getSceneGraphObject() instanceof Control;
                if (isControl) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void updateFxomDocument(String fxmlText, URL fxmlLocation, ResourceBundle resources) throws IOException {
        FXOMDocument newFxomDocument = fxmlText != null ? new FXOMDocument(fxmlText, fxmlLocation, this.getLibrary().getClassLoader(), resources) : null;
        this.jobManager.clear();
        this.selection.clear();
        this.messageLog.clear();
        this.errorReport.setFxomDocument(newFxomDocument);
        this.fxomDocumentProperty.setValue((Object)newFxomDocument);
        this.watchingController.fxomDocumentDidChange();
    }

    private void libraryClassLoaderDidChange() {
        if (this.getFxomDocument() != null) {
            this.errorReport.forget();
            this.getFxomDocument().setClassLoader(((Library)this.libraryProperty.get()).getClassLoader());
        }
    }

    private void resourcesDidChange() {
        if (this.getFxomDocument() != null) {
            this.errorReport.forget();
            this.getFxomDocument().setResources(this.getResources());
        }
    }

    private void jobManagerRevisionDidChange() {
        this.errorReport.forget();
        this.watchingController.jobManagerRevisionDidChange();
    }

    static {
        stylesheet = null;
    }

    public static enum Size {
        SIZE_320x240,
        SIZE_640x480,
        SIZE_1280x800,
        SIZE_1920x1080,
        SIZE_PREFERRED,
        SIZE_DEFAULT;

    }

    public static enum ControlAction {
        COPY,
        SELECT_ALL,
        SELECT_NONE,
        SELECT_PARENT,
        SELECT_NEXT,
        SELECT_PREVIOUS,
        EDIT_INCLUDED_FILE,
        REVEAL_INCLUDED_FILE,
        TOGGLE_CSS_SELECTION,
        TOGGLE_SAMPLE_DATA;

    }

    public static enum EditAction {
        CUT,
        PASTE,
        PASTE_INTO,
        DUPLICATE,
        DELETE,
        TRIM,
        TOGGLE_FX_ROOT,
        FIT_TO_PARENT,
        USE_COMPUTED_SIZES,
        ADD_CONTEXT_MENU,
        ADD_TOOLTIP,
        SET_SIZE_320x240,
        SET_SIZE_640x480,
        SET_SIZE_1280x800,
        SET_SIZE_1920x1080,
        MOVE_ROW_ABOVE,
        MOVE_ROW_BELOW,
        MOVE_COLUMN_BEFORE,
        MOVE_COLUMN_AFTER,
        ADD_ROW_ABOVE,
        ADD_ROW_BELOW,
        ADD_COLUMN_BEFORE,
        ADD_COLUMN_AFTER,
        INCREASE_ROW_SPAN,
        DECREASE_ROW_SPAN,
        INCREASE_COLUMN_SPAN,
        DECREASE_COLUMN_SPAN,
        BRING_TO_FRONT,
        SEND_TO_BACK,
        BRING_FORWARD,
        SEND_BACKWARD,
        UNWRAP,
        WRAP_IN_ANCHOR_PANE,
        WRAP_IN_GRID_PANE,
        WRAP_IN_GROUP,
        WRAP_IN_HBOX,
        WRAP_IN_PANE,
        WRAP_IN_SCROLL_PANE,
        WRAP_IN_SPLIT_PANE,
        WRAP_IN_STACK_PANE,
        WRAP_IN_TAB_PANE,
        WRAP_IN_TITLED_PANE,
        WRAP_IN_TOOL_BAR,
        WRAP_IN_VBOX;

    }
}

