/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.scene.input.MouseEvent;

public class EditorPlatform {
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    public static final boolean IS_LINUX = osName.contains("linux");
    public static final boolean IS_MAC = osName.contains("mac");
    public static final boolean IS_WINDOWS = osName.contains("windows");
    public static final String DOCUMENTATION_URL = "http://docs.oracle.com/javafx/index.html";
    public static final String JAVADOC_HOME = "http://docs.oracle.com/javase/8/javafx/api/";
    private static final URL caspianThemeUrl = Deprecation.getCaspianStylesheetURL();
    private static final URL caspianHighContrastThemeUrl = Deprecation.getCaspianHighContrastStylesheetURL();
    private static final URL caspianEmbeddedThemeUrl = Deprecation.getCaspianEmbeddedStylesheetURL();
    private static final URL caspianEmbeddedQVGAThemeUrl = Deprecation.getCaspianEmbeddedQVGAStylesheetURL();
    private static final URL modenaThemeUrl = Deprecation.getModenaStylesheetURL();
    private static final URL modenaTouchThemeUrl = Deprecation.getModenaTouchStylesheetURL();
    private static final URL modenaHighContrastBlackonwhiteThemeUrl = Deprecation.getModenaHighContrastBlackonwhiteStylesheetURL();
    private static final URL modenaHighContrastWhiteonblackThemeUrl = Deprecation.getModenaHighContrastWhiteonblackStylesheetURL();
    private static final URL modenaHighContrastYellowonblackThemeUrl = Deprecation.getModenaHighContrastYellowonblackStylesheetURL();

    public static List<URL> getThemeStylesheetURLs(Theme theme) {
        ArrayList<URL> result = new ArrayList<URL>();
        switch (theme) {
            default: {
                break;
            }
            case MODENA: {
                break;
            }
            case MODENA_TOUCH: {
                result.add(modenaTouchThemeUrl);
                break;
            }
            case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                result.add(modenaHighContrastBlackonwhiteThemeUrl);
                break;
            }
            case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                result.add(modenaHighContrastWhiteonblackThemeUrl);
                break;
            }
            case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                result.add(modenaHighContrastYellowonblackThemeUrl);
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE: {
                result.add(modenaTouchThemeUrl);
                result.add(modenaHighContrastBlackonwhiteThemeUrl);
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK: {
                result.add(modenaTouchThemeUrl);
                result.add(modenaHighContrastWhiteonblackThemeUrl);
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                result.add(modenaTouchThemeUrl);
                result.add(modenaHighContrastYellowonblackThemeUrl);
                break;
            }
            case CASPIAN: {
                result.add(caspianThemeUrl);
                break;
            }
            case CASPIAN_HIGH_CONTRAST: {
                result.add(caspianThemeUrl);
                result.add(caspianHighContrastThemeUrl);
                break;
            }
            case CASPIAN_EMBEDDED: {
                result.add(caspianThemeUrl);
                result.add(caspianEmbeddedThemeUrl);
                break;
            }
            case CASPIAN_EMBEDDED_HIGH_CONTRAST: {
                result.add(caspianThemeUrl);
                result.add(caspianEmbeddedThemeUrl);
                result.add(caspianHighContrastThemeUrl);
                break;
            }
            case CASPIAN_EMBEDDED_QVGA: {
                result.add(caspianThemeUrl);
                result.add(caspianEmbeddedThemeUrl);
                result.add(caspianEmbeddedQVGAThemeUrl);
                break;
            }
            case CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST: {
                result.add(caspianThemeUrl);
                result.add(caspianEmbeddedThemeUrl);
                result.add(caspianEmbeddedQVGAThemeUrl);
                result.add(caspianHighContrastThemeUrl);
            }
        }
        if (!theme.equals((Object)Theme.MODENA)) assert (!result.isEmpty()) : "Missing logic for " + (Object)((Object)theme);
        return result;
    }

    public static URL getPlatformThemeStylesheetURL() {
        return modenaThemeUrl;
    }

    public static boolean isModena(Theme theme) {
        return theme.toString().startsWith("MODENA");
    }

    public static boolean isModenaBlackonwhite(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("BLACK_ON_WHITE");
    }

    public static boolean isModenaWhiteonblack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("WHITE_ON_BLACK");
    }

    public static boolean isModenaYellowonblack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("YELLOW_ON_BLACK");
    }

    public static boolean isModenaHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST");
    }

    public static boolean isModenaTouch(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("TOUCH");
    }

    public static boolean isModenaTouchHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST") && theme.toString().contains("TOUCH");
    }

    public static boolean isCaspian(Theme theme) {
        return theme.toString().startsWith("CASPIAN");
    }

    public static void open(String path) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (IS_MAC) {
            args.add("open");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("cmd");
            args.add("/c");
            args.add("start");
            if (path.contains(" ")) {
                args.add("\"html\"");
            }
            args.add(path);
        } else if (IS_LINUX) {
            args.add("xdg-open");
            args.add(path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null);
        }
    }

    public static void revealInFileBrowser(File filePath) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String path = filePath.toURI().toURL().toExternalForm();
        if (IS_MAC) {
            args.add("open");
            args.add("-R");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("explorer");
            args.add("/select," + path);
        } else if (IS_LINUX) {
            args.add("nautilus");
            int osVersionNumerical = Integer.parseInt(System.getProperty("os.version").substring(0, 1));
            if (osVersionNumerical < 3 && (path = filePath.getAbsoluteFile().getParent()) == null) {
                path = ".";
            }
            args.add(path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null);
        }
    }

    public static boolean isContinuousSelectKeyDown(MouseEvent e) {
        return e.isShiftDown();
    }

    public static boolean isNonContinousSelectKeyDown(MouseEvent e) {
        return IS_MAC ? e.isMetaDown() : e.isControlDown();
    }

    public static boolean isAssertionEnabled() {
        boolean result = false;
        if (!$assertionsDisabled) {
            result = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return result;
    }

    private static void executeDaemon(List<String> cmd, File wDir) throws IOException {
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder = builder.directory(wDir);
            builder.start();
        }
        catch (RuntimeException ex) {
            throw new IOException(ex);
        }
    }

    public static enum Theme {
        MODENA,
        MODENA_TOUCH,
        MODENA_HIGH_CONTRAST_BLACK_ON_WHITE,
        MODENA_HIGH_CONTRAST_WHITE_ON_BLACK,
        MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK,
        MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE,
        MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK,
        MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK,
        CASPIAN,
        CASPIAN_HIGH_CONTRAST,
        CASPIAN_EMBEDDED,
        CASPIAN_EMBEDDED_HIGH_CONTRAST,
        CASPIAN_EMBEDDED_QVGA,
        CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;

    }
}

