/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class JobManager {
    private final EditorController editorController;
    private final int undoStackMaxSize;
    private final List<Job> undoStack = new ArrayList<Job>();
    private final List<Job> redoStack = new ArrayList<Job>();
    private final SimpleIntegerProperty revision = new SimpleIntegerProperty();
    private boolean lock;

    JobManager(EditorController editorController, int undoStackMaxSize) {
        assert (editorController != null);
        assert (undoStackMaxSize >= 1);
        this.editorController = editorController;
        this.undoStackMaxSize = undoStackMaxSize;
    }

    public List<Job> getUndoStack() {
        return Collections.unmodifiableList(this.undoStack);
    }

    public List<Job> getRedoStack() {
        return Collections.unmodifiableList(this.redoStack);
    }

    public void push(Job job) {
        assert (job != null);
        assert (job.getEditorController() == this.editorController);
        assert (job.isExecutable());
        if (this.lock) {
            throw new IllegalStateException("Pushing jobs from another job or a job manager listener is forbidden");
        }
        this.executeJob(job);
        this.undoStack.add(0, job);
        if (this.undoStack.size() > this.undoStackMaxSize) {
            this.undoStack.remove(this.undoStack.size() - 1);
        }
        this.redoStack.clear();
        this.incrementRevision();
    }

    public void clear() {
        if (this.lock) {
            throw new IllegalStateException("Clearing job stack from another job or a job manager listener is forbidden");
        }
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public String getUndoDescription() {
        String result = this.canUndo() ? this.undoStack.get(0).getDescription() : null;
        return result;
    }

    public void undo() {
        assert (this.canUndo());
        if (this.lock) {
            throw new IllegalStateException("Undoing jobs from another job or a job manager listener is forbidden");
        }
        Job job = this.undoStack.get(0);
        this.undoJob(job);
        this.undoStack.remove(0);
        this.redoStack.add(0, job);
        this.incrementRevision();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public String getRedoDescription() {
        String result = this.canRedo() ? this.redoStack.get(0).getDescription() : null;
        return result;
    }

    public void redo() {
        assert (this.canRedo());
        if (this.lock) {
            throw new IllegalStateException("Redoing jobs from another job or a job manager listener is forbidden");
        }
        Job job = this.redoStack.get(0);
        this.redoJob(job);
        this.redoStack.remove(0);
        this.undoStack.add(0, job);
        this.incrementRevision();
    }

    public ReadOnlyIntegerProperty revisionProperty() {
        return this.revision;
    }

    public Job getCurrentJob() {
        if (this.undoStack.size() > 0) {
            return this.undoStack.get(0);
        }
        return null;
    }

    private void executeJob(Job job) {
        this.lock = true;
        try {
            job.execute();
        }
        finally {
            this.lock = false;
        }
    }

    private void undoJob(Job job) {
        this.lock = true;
        try {
            job.undo();
        }
        finally {
            this.lock = false;
        }
    }

    private void redoJob(Job job) {
        this.lock = true;
        try {
            job.redo();
        }
        finally {
            this.lock = false;
        }
    }

    private void incrementRevision() {
        this.lock = true;
        try {
            this.revision.set(this.revision.get() + 1);
        }
        finally {
            this.lock = false;
        }
    }
}

