/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.LiveUpdater;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DocumentDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.RootDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.BackupSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyPath;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.input.TransferMode;

public class DragController {
    private final EditorController editorController;
    private final ObjectProperty<AbstractDragSource> dragSourceProperty = new SimpleObjectProperty(null);
    private final ObjectProperty<AbstractDropTarget> dropTargetProperty = new SimpleObjectProperty(null);
    private LiveUpdater liveUpdater;
    private Job backupSelectionJob;
    private boolean liveUpdateEnabled;
    private boolean dropAccepted;
    private AbstractDropTarget committedDropTarget;
    private Timer mouseTimer;
    private static final long MOUSE_TIMER_DELAY = 500L;

    public DragController(EditorController editorController) {
        this.editorController = editorController;
    }

    public void begin(AbstractDragSource dragSource) {
        assert (dragSource != null);
        assert (dragSource.isAcceptable());
        assert (this.getDragSource() == null);
        assert (this.getDropTarget() == null);
        assert (this.liveUpdater == null);
        assert (this.backupSelectionJob == null);
        assert (!this.dropAccepted);
        assert (this.committedDropTarget == null);
        assert (this.mouseTimer == null);
        this.liveUpdater = new LiveUpdater(dragSource, this.editorController);
        this.dragSourceProperty.set((Object)dragSource);
        this.dropTargetProperty.set(null);
        this.backupSelectionJob = new BackupSelectionJob(this.editorController);
        this.editorController.getSelection().clear();
    }

    public void end() {
        assert (this.getDragSource() != null);
        this.liveUpdater.setDropTarget(null);
        this.dropAccepted = false;
        this.dropTargetProperty.set(null);
        if (this.committedDropTarget != null) {
            assert (this.committedDropTarget.acceptDragSource(this.getDragSource()));
            Job dropJob = this.committedDropTarget.makeDropJob(this.getDragSource(), this.editorController);
            UpdateSelectionJob selectJob = new UpdateSelectionJob(this.getDragSource().getDraggedObjects(), this.editorController);
            BatchJob batchJob = new BatchJob(this.editorController, dropJob.getDescription());
            if (this.committedDropTarget.isSelectRequiredAfterDrop()) {
                batchJob.addSubJob(this.backupSelectionJob);
            }
            batchJob.addSubJob(dropJob);
            if (this.committedDropTarget.isSelectRequiredAfterDrop()) {
                batchJob.addSubJob(selectJob);
            }
            this.editorController.getJobManager().push(batchJob);
        }
        if (this.mouseTimer != null) {
            this.mouseTimer.cancel();
            this.mouseTimer = null;
        }
        this.liveUpdater = null;
        this.backupSelectionJob = null;
        this.committedDropTarget = null;
        this.dragSourceProperty.set(null);
    }

    public AbstractDragSource getDragSource() {
        return (AbstractDragSource)this.dragSourceProperty.get();
    }

    public Property<AbstractDragSource> dragSourceProperty() {
        return this.dragSourceProperty;
    }

    public void setDropTarget(AbstractDropTarget newDropTarget) {
        assert (this.getDragSource() != null);
        assert (newDropTarget == null || this.committedDropTarget == null);
        this.dropAccepted = newDropTarget == null ? false : (this.isDragSourceInParentChain(newDropTarget) ? false : newDropTarget.acceptDragSource(this.getDragSource()));
        this.dropTargetProperty.set((Object)newDropTarget);
        this.trackMouse();
        if (this.dropAccepted) {
            FXOMObject nextParent;
            assert (this.getDropTarget() != null);
            assert (this.getDropTarget().acceptDragSource(this.getDragSource()));
            assert (!this.getDragSource().getDraggedObjects().isEmpty());
            FXOMObject firstObject = this.getDragSource().getDraggedObjects().get(0);
            FXOMObject currentParent = firstObject.getParentObject();
            if (currentParent == (nextParent = this.getDropTarget().getTargetObject()) && this.liveUpdateEnabled) {
                this.liveUpdater.setDropTarget(newDropTarget);
            }
        }
    }

    public AbstractDropTarget getDropTarget() {
        return (AbstractDropTarget)this.dropTargetProperty.get();
    }

    public Property<AbstractDropTarget> dropTargetProperty() {
        return this.dropTargetProperty;
    }

    public boolean isDropAccepted() {
        return this.dropAccepted;
    }

    public TransferMode[] getAcceptedTransferModes() {
        TransferMode[] result = this.getDropTarget() == null ? TransferMode.NONE : (this.dropAccepted ? (this.getDragSource() instanceof DocumentDragSource ? new TransferMode[]{TransferMode.MOVE} : new TransferMode[]{TransferMode.COPY}) : TransferMode.NONE);
        assert (result.length == 0 || this.getDropTarget() != null);
        return result;
    }

    public void commit() {
        assert (this.isDropAccepted());
        assert (this.committedDropTarget == null);
        this.committedDropTarget = this.getDropTarget();
    }

    public boolean isLiveUpdated() {
        return this.getDropTarget() == this.liveUpdater.getDropTarget();
    }

    private void mouseDidStopMoving() {
        if (this.dropAccepted && this.getDropTarget() != this.liveUpdater.getDropTarget() && this.liveUpdateEnabled) {
            this.liveUpdater.setDropTarget(this.getDropTarget());
        }
    }

    private void trackMouse() {
        boolean runAsDaemon = true;
        if (this.mouseTimer == null) {
            this.mouseTimer = new Timer(true);
        } else {
            this.mouseTimer.cancel();
            this.mouseTimer = new Timer(true);
        }
        this.mouseTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DragController.this.mouseTimer = null;
                        DragController.this.mouseDidStopMoving();
                    }
                });
            }
        }, 500L);
    }

    private boolean isDragSourceInParentChain(AbstractDropTarget newDropTarget) {
        boolean result;
        assert (newDropTarget != null);
        if (newDropTarget instanceof RootDropTarget) {
            result = false;
        } else {
            List<FXOMObject> draggedObjects = this.getDragSource().getDraggedObjects();
            DesignHierarchyPath dropTargetPath = new DesignHierarchyPath(newDropTarget.getTargetObject());
            result = false;
            for (FXOMObject draggedObject : draggedObjects) {
                DesignHierarchyPath draggedObjectPath = new DesignHierarchyPath(draggedObject);
                DesignHierarchyPath commonPath = draggedObjectPath.getCommonPathWith(dropTargetPath);
                if (!commonPath.equals(draggedObjectPath)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

