/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;

public class ContainerXYDropTarget
extends AbstractDropTarget {
    private final FXOMInstance targetContainer;
    private final double sceneX;
    private final double sceneY;

    public ContainerXYDropTarget(FXOMInstance targetContainer, double sceneX, double sceneY) {
        assert (targetContainer != null);
        assert (targetContainer.getSceneGraphObject() instanceof Parent);
        this.targetContainer = targetContainer;
        this.sceneX = sceneX;
        this.sceneY = sceneY;
    }

    public double getSceneX() {
        return this.sceneX;
    }

    public double getSceneY() {
        return this.sceneY;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetContainer;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        boolean result;
        assert (dragSource != null);
        if (dragSource.getDraggedObjects().isEmpty()) {
            result = false;
        } else {
            boolean containsIntrinsic = false;
            for (FXOMObject draggedObject : dragSource.getDraggedObjects()) {
                if (!(draggedObject instanceof FXOMIntrinsic)) continue;
                containsIntrinsic = true;
            }
            if (containsIntrinsic) {
                result = false;
            } else {
                DesignHierarchyMask m = new DesignHierarchyMask(this.targetContainer);
                result = m.isAcceptingSubComponent(dragSource.getDraggedObjects());
            }
        }
        return result;
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        BatchJob result;
        assert (this.acceptDragSource(dragSource));
        assert (editorController != null);
        List<FXOMObject> draggedObjects = dragSource.getDraggedObjects();
        FXOMObject hitObject = dragSource.getHitObject();
        double hitX = dragSource.getHitX();
        double hitY = dragSource.getHitY();
        FXOMObject currentParent = hitObject.getParentObject();
        if (currentParent == this.targetContainer) {
            assert (hitObject.getSceneGraphObject() instanceof Node);
            assert (hitObject instanceof FXOMInstance);
            boolean shouldRefreshSceneGraph = false;
            result = new BatchJob(editorController, false, dragSource.makeDropJobDescription());
            Point2D dxy = this.computeRelocationDXY((FXOMInstance)hitObject, hitX, hitY);
            for (FXOMObject draggedObject : dragSource.getDraggedObjects()) {
                assert (draggedObject.getSceneGraphObject() instanceof Node);
                assert (draggedObject instanceof FXOMInstance);
                Node draggedNode = (Node)draggedObject.getSceneGraphObject();
                double newLayoutX = Math.round(draggedNode.getLayoutX() + dxy.getX());
                double newLayoutY = Math.round(draggedNode.getLayoutY() + dxy.getY());
                result.addSubJob(new RelocateNodeJob((FXOMInstance)draggedObject, newLayoutX, newLayoutY, editorController));
            }
        } else {
            boolean shouldRefreshSceneGraph = true;
            result = new BatchJob(editorController, true, dragSource.makeDropJobDescription());
            if (currentParent != null) {
                for (FXOMObject draggedObject : draggedObjects) {
                    result.addSubJob(new DeleteObjectJob(draggedObject, editorController));
                }
            }
            for (FXOMObject draggedObject : draggedObjects) {
                result.addSubJob(new InsertAsSubComponentJob(draggedObject, this.targetContainer, -1, editorController));
            }
            assert (hitObject.getSceneGraphObject() instanceof Node);
            Node hitNode = (Node)hitObject.getSceneGraphObject();
            double layoutX0 = hitNode.getLayoutX();
            double layoutY0 = hitNode.getLayoutY();
            HashMap<FXOMObject, Point2D> layoutDXY = new HashMap<FXOMObject, Point2D>();
            for (FXOMObject draggedObject : draggedObjects) {
                assert (draggedObject.getSceneGraphObject() instanceof Node);
                Node draggedNode = (Node)draggedObject.getSceneGraphObject();
                double layoutDX = draggedNode.getLayoutX() - layoutX0;
                double layoutDY = draggedNode.getLayoutY() - layoutY0;
                layoutDXY.put(draggedObject, new Point2D(layoutDX, layoutDY));
            }
            Parent targetParent = (Parent)this.targetContainer.getSceneGraphObject();
            Point2D targetCenter = targetParent.sceneToLocal(this.sceneX, this.sceneY);
            Bounds layoutBounds = hitNode.getLayoutBounds();
            Point2D currentOrigin = hitNode.localToParent(0.0, 0.0);
            Point2D currentCenter = hitNode.localToParent((layoutBounds.getMinX() + layoutBounds.getMaxX()) / 2.0, (layoutBounds.getMinY() + layoutBounds.getMaxY()) / 2.0);
            double currentDX = currentOrigin.getX() - currentCenter.getX();
            double currentDY = currentOrigin.getY() - currentCenter.getY();
            double targetOriginX = targetCenter.getX() + currentDX;
            double targetOriginY = targetCenter.getY() + currentDY;
            for (FXOMObject draggedObject : draggedObjects) {
                assert (draggedObject instanceof FXOMInstance);
                Point2D dxy = (Point2D)layoutDXY.get(draggedObject);
                assert (dxy != null);
                double newLayoutX = Math.round(targetOriginX + dxy.getX());
                double newLayoutY = Math.round(targetOriginY + dxy.getY());
                result.addSubJob(new RelocateNodeJob((FXOMInstance)draggedObject, newLayoutX, newLayoutY, editorController));
            }
            result.addSubJob(new AdjustAllToggleGroupJob(editorController));
        }
        assert (result.isExecutable());
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.targetContainer);
        hash = 53 * hash + (int)(Double.doubleToLongBits(this.sceneX) ^ Double.doubleToLongBits(this.sceneX) >>> 32);
        hash = 53 * hash + (int)(Double.doubleToLongBits(this.sceneY) ^ Double.doubleToLongBits(this.sceneY) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerXYDropTarget other = (ContainerXYDropTarget)obj;
        if (!Objects.equals(this.targetContainer, other.targetContainer)) {
            return false;
        }
        if (Double.doubleToLongBits(this.sceneX) != Double.doubleToLongBits(other.sceneX)) {
            return false;
        }
        return Double.doubleToLongBits(this.sceneY) == Double.doubleToLongBits(other.sceneY);
    }

    public String toString() {
        return "ContainerXYDropTarget{targetContainer=" + this.targetContainer + ", sceneX=" + this.sceneX + ", sceneY=" + this.sceneY + '}';
    }

    private Point2D computeRelocationDXY(FXOMInstance hitObject, double hitX, double hitY) {
        assert (hitObject != null);
        assert (hitObject.getSceneGraphObject() instanceof Node);
        Node sceneGraphNode = (Node)hitObject.getSceneGraphObject();
        Point2D currentHit = sceneGraphNode.localToParent(hitX, hitY);
        Parent sceneGraphParent = sceneGraphNode.getParent();
        Point2D newHit = sceneGraphParent.sceneToLocal(this.sceneX, this.sceneY);
        double dx = newHit.getX() - currentHit.getX();
        double dy = newHit.getY() - currentHit.getY();
        return new Point2D(dx, dy);
    }
}

