/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.List;
import java.util.Objects;

public class ContainerZDropTarget
extends AbstractDropTarget {
    private final FXOMInstance targetContainer;
    private final FXOMObject beforeChild;

    public ContainerZDropTarget(FXOMInstance targetContainer, FXOMObject beforeChild) {
        assert (targetContainer != null);
        this.targetContainer = targetContainer;
        this.beforeChild = beforeChild;
    }

    public FXOMObject getBeforeChild() {
        return this.beforeChild;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetContainer;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        boolean result;
        assert (dragSource != null);
        if (dragSource.getDraggedObjects().isEmpty()) {
            result = false;
        } else {
            DesignHierarchyMask m = new DesignHierarchyMask(this.targetContainer);
            if (m.isAcceptingSubComponent(dragSource.getDraggedObjects())) {
                FXOMObject draggedObject0 = dragSource.getDraggedObjects().get(0);
                boolean sameContainer = this.targetContainer == draggedObject0.getParentObject();
                boolean sameIndex = this.beforeChild == draggedObject0 || this.beforeChild == draggedObject0.getNextSlibing();
                result = !sameContainer || !sameIndex;
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        assert (dragSource != null);
        assert (!dragSource.getDraggedObjects().isEmpty());
        assert (editorController != null);
        boolean shouldRefreshSceneGraph = true;
        BatchJob result = new BatchJob(editorController, true, dragSource.makeDropJobDescription());
        List<FXOMObject> draggedObjects = dragSource.getDraggedObjects();
        FXOMObject currentParent = draggedObjects.get(0).getParentObject();
        if (currentParent == this.targetContainer) {
            for (FXOMObject draggedObject : dragSource.getDraggedObjects()) {
                result.addSubJob(new ReIndexObjectJob(draggedObject, this.beforeChild, editorController));
            }
        } else {
            int targetIndex;
            if (currentParent != null) {
                for (FXOMObject draggedObject : draggedObjects) {
                    result.addSubJob(new DeleteObjectJob(draggedObject, editorController));
                }
            }
            if (this.beforeChild == null) {
                DesignHierarchyMask m = new DesignHierarchyMask(this.targetContainer);
                targetIndex = m.getSubComponentCount();
            } else {
                targetIndex = this.beforeChild.getIndexInParentProperty();
                assert (targetIndex != -1);
            }
            for (FXOMObject draggedObject : draggedObjects) {
                InsertAsSubComponentJob j = new InsertAsSubComponentJob(draggedObject, this.targetContainer, targetIndex++, editorController);
                result.addSubJob(j);
            }
        }
        result.addSubJob(new AdjustAllToggleGroupJob(editorController));
        assert (result.isExecutable());
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.targetContainer);
        hash = 97 * hash + Objects.hashCode(this.beforeChild);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerZDropTarget other = (ContainerZDropTarget)obj;
        if (!Objects.equals(this.targetContainer, other.targetContainer)) {
            return false;
        }
        return Objects.equals(this.beforeChild, other.beforeChild);
    }

    public String toString() {
        return "ContainerZDropTarget{targetContainer=" + this.targetContainer + ", beforeChild=" + this.beforeChild + '}';
    }
}

