/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.GridSnapshot;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.InsertColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.InsertRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.MoveCellContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.GridBounds;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;

public class GridPaneDropTarget
extends AbstractDropTarget {
    private final FXOMObject targetGridPane;
    private final int targetIndex;
    private final int targetColumnIndex;
    private final int targetRowIndex;
    private final ColumnArea targetColumnArea;
    private final RowArea targetRowArea;

    public GridPaneDropTarget(FXOMObject targetGridPane, int columnIndex, int rowIndex, ColumnArea targetColumnArea, RowArea targetRowArea) {
        assert (targetGridPane != null);
        assert (targetGridPane.getSceneGraphObject() instanceof GridPane);
        assert (columnIndex >= 0);
        assert (rowIndex >= 0);
        this.targetGridPane = targetGridPane;
        this.targetIndex = -1;
        this.targetColumnIndex = columnIndex;
        this.targetRowIndex = rowIndex;
        this.targetColumnArea = targetColumnArea;
        this.targetRowArea = targetRowArea;
    }

    public GridPaneDropTarget(FXOMObject targetGridPane, int targetIndex) {
        assert (targetGridPane != null);
        assert (targetGridPane.getSceneGraphObject() instanceof GridPane);
        assert (targetIndex >= -1);
        this.targetGridPane = targetGridPane;
        this.targetIndex = targetIndex;
        this.targetColumnIndex = 0;
        this.targetRowIndex = 0;
        GridPane gridPane = (GridPane)targetGridPane.getSceneGraphObject();
        this.targetColumnArea = Deprecation.getGridPaneColumnCount(gridPane) == 0 ? ColumnArea.LEFT : ColumnArea.CENTER;
        this.targetRowArea = Deprecation.getGridPaneRowCount(gridPane) == 0 ? RowArea.TOP : RowArea.CENTER;
    }

    public int getTargetColumnIndex() {
        return this.targetColumnIndex;
    }

    public int getTargetRowIndex() {
        return this.targetRowIndex;
    }

    public ColumnArea getTargetColumnArea() {
        return this.targetColumnArea;
    }

    public RowArea getTargetRowArea() {
        return this.targetRowArea;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetGridPane;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        boolean result;
        assert (dragSource != null);
        if (dragSource.getDraggedObjects().isEmpty()) {
            result = false;
        } else {
            DesignHierarchyMask m = new DesignHierarchyMask(this.targetGridPane);
            if (m.isAcceptingSubComponent(dragSource.getDraggedObjects())) {
                FXOMObject draggedObject0 = dragSource.getDraggedObjects().get(0);
                assert (draggedObject0.getSceneGraphObject() instanceof Node);
                Node draggedNode0 = (Node)draggedObject0.getSceneGraphObject();
                Integer columIndexObj = GridPane.getColumnIndex((Node)draggedNode0);
                Integer rowIndexObj = GridPane.getRowIndex((Node)draggedNode0);
                int currentColumnIndex = columIndexObj == null ? 0 : columIndexObj;
                int currentRowIndex = rowIndexObj == null ? 0 : rowIndexObj;
                boolean sameContainer = this.targetGridPane == draggedObject0.getParentObject();
                boolean sameColumnIndex = this.targetColumnIndex == currentColumnIndex;
                boolean sameRowIndex = this.targetRowIndex == currentRowIndex;
                boolean sameArea = this.targetColumnArea == ColumnArea.CENTER && this.targetRowArea == RowArea.CENTER;
                result = !sameContainer || !sameColumnIndex || !sameRowIndex || !sameArea;
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        int insertCount;
        int insertCount2;
        assert (this.acceptDragSource(dragSource));
        assert (editorController != null);
        boolean shouldRefreshSceneGraph = true;
        BatchJob result = new BatchJob(editorController, true, dragSource.makeDropJobDescription());
        List<FXOMObject> draggedObjects = dragSource.getDraggedObjects();
        FXOMObject hitObject = dragSource.getHitObject();
        FXOMObject currentParent = hitObject.getParentObject();
        boolean reparenting = currentParent != this.targetGridPane;
        GridPane gridPane = (GridPane)this.targetGridPane.getSceneGraphObject();
        GridSnapshot gridSnapshot = currentParent != null && currentParent.getSceneGraphObject() instanceof GridPane ? new GridSnapshot(draggedObjects) : new GridSnapshot(draggedObjects, 1);
        if (reparenting) {
            result.addSubJob(new ClearSelectionJob(editorController));
            if (currentParent != null) {
                for (FXOMObject draggedObject : draggedObjects) {
                    result.addSubJob(new DeleteObjectJob(draggedObject, editorController));
                }
            }
        }
        GridBounds snapshotBounds = gridSnapshot.getBounds();
        int hitColumnIndex = gridSnapshot.getColumnIndex(hitObject);
        int hitRowIndex = gridSnapshot.getRowIndex(hitObject);
        int destColumnIndex = this.targetColumnArea == ColumnArea.RIGHT ? this.targetColumnIndex + 1 : this.targetColumnIndex;
        int destRowIndex = this.targetRowArea == RowArea.BOTTOM ? this.targetRowIndex + 1 : this.targetRowIndex;
        int columnDelta = destColumnIndex - hitColumnIndex;
        int rowDelta = destRowIndex - hitRowIndex;
        GridBounds adjustedBounds = snapshotBounds.move(columnDelta, rowDelta);
        switch (this.targetColumnArea) {
            case LEFT: 
            case RIGHT: {
                insertCount2 = snapshotBounds.getColumnSpan();
                result.addSubJob(new InsertColumnJob(this.targetGridPane, destColumnIndex, insertCount2, editorController));
                break;
            }
            case CENTER: {
                int targetColumnCount = Deprecation.getGridPaneColumnCount(gridPane);
                if (adjustedBounds.getMaxColumnIndex() > targetColumnCount) {
                    insertCount = adjustedBounds.getMaxColumnIndex() - targetColumnCount;
                    result.addSubJob(new InsertColumnJob(this.targetGridPane, targetColumnCount, insertCount, editorController));
                }
                if (adjustedBounds.getMinColumnIndex() >= 0) break;
                insertCount = -adjustedBounds.getMinColumnIndex();
                result.addSubJob(new InsertColumnJob(this.targetGridPane, 0, insertCount, editorController));
                break;
            }
        }
        switch (this.targetRowArea) {
            case TOP: 
            case BOTTOM: {
                insertCount2 = snapshotBounds.getRowSpan();
                result.addSubJob(new InsertRowJob(this.targetGridPane, destRowIndex, insertCount2, editorController));
                break;
            }
            case CENTER: {
                int targetRowCount = Deprecation.getGridPaneRowCount(gridPane);
                if (adjustedBounds.getMaxRowIndex() > targetRowCount) {
                    insertCount = adjustedBounds.getMaxRowIndex() - targetRowCount;
                    result.addSubJob(new InsertRowJob(this.targetGridPane, targetRowCount, insertCount, editorController));
                }
                if (adjustedBounds.getMinRowIndex() >= 0) break;
                insertCount = -adjustedBounds.getMinRowIndex();
                result.addSubJob(new InsertRowJob(this.targetGridPane, 0, insertCount, editorController));
                break;
            }
        }
        if (reparenting) {
            for (FXOMObject draggedObject : draggedObjects) {
                InsertAsSubComponentJob j = new InsertAsSubComponentJob(draggedObject, this.targetGridPane, this.targetIndex, editorController);
                result.addSubJob(j);
            }
        }
        for (FXOMObject draggedObject : draggedObjects) {
            assert (draggedObject instanceof FXOMInstance);
            result.addSubJob(new MoveCellContentJob((FXOMInstance)draggedObject, columnDelta, rowDelta, editorController));
        }
        if (reparenting) {
            result.addSubJob(new AdjustAllToggleGroupJob(editorController));
            result.addSubJob(new UpdateSelectionJob(draggedObjects, editorController));
        }
        assert (result.isExecutable());
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }

    public static enum RowArea {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum ColumnArea {
        LEFT,
        CENTER,
        RIGHT;

    }
}

