/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.LibraryDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UsePredefinedSizeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;

public class RootDropTarget
extends AbstractDropTarget {
    @Override
    public FXOMObject getTargetObject() {
        return null;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        assert (dragSource != null);
        return dragSource.getDraggedObjects().size() == 1;
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        DesignHierarchyMask mask;
        assert (dragSource != null);
        assert (dragSource.getDraggedObjects().size() == 1);
        FXOMObject newRoot = dragSource.getDraggedObjects().get(0);
        UsePredefinedSizeJob resizeJob = dragSource instanceof LibraryDragSource ? ((mask = new DesignHierarchyMask(newRoot)).needResizeWhenTopElement() ? new UsePredefinedSizeJob(editorController, EditorController.Size.SIZE_DEFAULT, newRoot) : null) : null;
        BatchJob result = new BatchJob(editorController, true, dragSource.makeDropJobDescription());
        result.addSubJob(new SetDocumentRootJob(newRoot, editorController));
        if (resizeJob != null && resizeJob.isExecutable()) {
            result.addSubJob(resizeJob);
        }
        result.addSubJob(new AdjustAllToggleGroupJob(editorController));
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }
}

